/* 
 * $Id: ctkutil.c,v 1.2 2000/06/27 04:42:30 terpstra Exp $
 *
 * CTK - Console Toolkit
 *
 * Copyright (C) 1998-2000 Stormix Technologies Inc.
 *
 * License: LGPL
 *
 * Authors: Kevin Lindsay, Wesley Terpstra
 *  
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *    
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#include <stdio.h>
#include <glib.h>
#include <string.h>
#include <stdlib.h>

/* Miscellaneous functions */

/* Insert a character into a string */
void
    ctk_util_strinschr(gchar **string, gchar *mark, guint chr)
{
	gchar *front;
	gchar *back;
	guint tot_len;
	guint mark_len;
	
	if (!string || !*string || !mark)
	    return;

	mark_len = strlen(mark);
	tot_len = mark_len+(mark-*string)+1;
	
	front = g_strndup(*string,(mark-*string));
	back = g_malloc(mark_len+2);
	*back = chr;
	*(back+1) = 0;
	strcat(back,mark);
	
	*string = g_realloc(*string,tot_len+1);
	strcpy(*string,front);
	strcat(*string,back);
	
	g_free(front);
	g_free(back);
	
	return;

}

/* Insert a string into a string */
gint
    ctk_util_strinsstr(gchar **string, gchar *mark, gchar *ins_str)
{
	gchar *front;
	gchar *back;
	guint tot_len;
	guint mark_len;
	guint ins_str_len;
	
	if (!string|| !*string || !mark || !ins_str)
	    return 0;
	
	mark_len = strlen(mark);
	ins_str_len = strlen(ins_str);

	tot_len = mark_len+(mark-*string)+ins_str_len;

	front = g_strndup(*string,(mark-*string));
	back = g_malloc(mark_len+ins_str_len+1);
	strcpy(back,ins_str);
	strcat(back,mark);
	
	*string = g_realloc(*string,tot_len+1);
	
	if (!*string) {
		g_free(front);
		g_free(back);
		return 0;
	}

	strcpy(*string,front);
	strcat(*string,back);
	
	g_free(front);
	g_free(back);
	
	return 1;

}

/* Remove a character from a pointer in a string */
void
    ctk_util_strdelch(gchar **string, gchar *mark)
{
	gchar *back;
	guint mark_len;
	guint mark_pos;

	if (!string || !*string || !mark)
	    return;

	mark_pos = mark-*string;

	mark_len = strlen(mark);

	back = g_malloc(mark_len+1);
	strcpy(back,mark);
	    
	strcpy(*string+(mark_pos-1),back);
	
	g_free(back);
	
}

/* Get the longest field width of string with the specified delimiter */
gint
    ctk_util_getstrwidth(const gchar *string, gint ch)
{
	gint width;
	gint longest_width;
	const gchar *ptr;

	if (!string)
	    return 0;
	
	/* Get longest width */
	ptr = string;
	width = 0;
	longest_width = 0;
	while (*ptr) {			
		if (*ptr == ch) {
			if (width < longest_width)
			    width = longest_width;
			longest_width = 0;
		} 
		else if (*ptr)
		    longest_width += 1;
		ptr += 1;
	}
	
	if (width < longest_width)
	    width = longest_width;

	return width;
	
}

/* Get the number of fields in a string according to the supplied
 * delimiter */
gint
    ctk_util_fields(const gchar *string, gint ch)
{
	const gchar *ptr;
	gint lines;
	
	if (!string)
	    return 0;
	
	/* Get the number of lines in the text */
	ptr = string;
	for (lines = 1; *ptr; ptr += 1) {
		if (*ptr == ch)
		    lines += 1;
	}

	return lines;
}

/* Convert a float to a string with a specified number of decimal
 * places */
gchar *
    ctk_util_ftos(gfloat num, guint digits)
{
	static gchar *buffer = NULL;

	buffer = realloc(buffer,128);
	*buffer = 0;

	snprintf(buffer,127,"%.*f",(gint)digits,num);
	
	return(buffer);
}

/* Check if a number is even */
gboolean
    ctk_util_iseven(gint num)
{

	if ((num / 2)*2 == num)
	    return TRUE;

	return FALSE;
}
