/*--------------------------------------------------------------------------+
$Id: Model.java 26268 2010-02-18 10:44:30Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.commons.xml.example;

import java.util.ArrayList;
import java.util.List;

/**
 * XML facility demo model class.
 * 
 * @author Florian Deissenboeck
 * @author $Author: juergens $
 * @version $Rev: 26268 $
 * @levd.rating GREEN Hash: 08971906EFA15A1730E4F03878D09AD5
 */
public class Model {
	/** The persons. */
	private final ArrayList<Person> persons = new ArrayList<Person>();

	/** Add a person. */
	public void add(Person person) {
		persons.add(person);
	}

	/** Get list of persons. */
	public List<Person> getPersons() {
		return persons;
	}

	/** Clear model. */
	public void clear() {
		persons.clear();
	}

	/** Deep equals. */
	@Override
	public boolean equals(Object other) {
		if (!(other instanceof Model)) {
			return false;
		}
		Model otherModel = (Model) other;

		if (persons.size() != otherModel.persons.size()) {
			return false;
		}

		for (int i = 0; i < persons.size(); i++) {
			if (!(persons.get(i).equals(otherModel.persons.get(i)))) {
				return false;
			}
		}

		return true;
	}

	/** {@inheritDoc} */
	@Override
	public int hashCode() {
		// using fixed hash code here as this method should not be used in the
		// tests
		return 13;
	}
}