/*--------------------------------------------------------------------------+
$Id: OptionApplicatorTest.java 26283 2010-02-18 11:18:57Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.commons.options;

import edu.tum.cs.commons.reflect.TypeConversionException;
import junit.framework.TestCase;

/**
 * Tests for <code>OptionApplicator</code>
 * 
 * 
 * @author Benjamin Hummel
 * @author $Author: juergens $
 * @version $Rev: 26283 $
 * @levd.rating GREEN Hash: 7596C3F25A1AFFE1B6045965CBE64FD2
 */
public class OptionApplicatorTest extends TestCase {

	/**
	 * Test an option taking no argument.
	 * 
	 * @throws OptionException
	 */
	public void testSimpleOption() throws NoSuchMethodException,
			OptionException {
		SimpleOptionHandler soh = new SimpleOptionHandler();
		OptionApplicator oa = new OptionApplicator(soh,
				SimpleOptionHandler.class.getMethod("increaseCounter"), false);
		assertFalse(oa.requiresParameter());
		assertEquals(0, soh.counter);
		oa.applyOption();
		assertEquals(1, soh.counter);
	}

	/**
	 * Test an option with an argument.
	 * 
	 * @throws OptionException
	 */
	public void testArgumentOption() throws NoSuchMethodException,
			TypeConversionException, OptionException {
		SimpleOptionHandler soh = new SimpleOptionHandler();
		OptionApplicator oa = new OptionApplicator(soh,
				SimpleOptionHandler.class
						.getMethod("storeDouble", double.class), false);
		assertTrue(oa.requiresParameter());
		oa.applyOption("4.2");
		assertTrue(Math.abs(4.2 - soh.storedDouble) < 1e-6);
	}
}