/*--------------------------------------------------------------------------+
$Id: RegexReplacement.java 26283 2010-02-18 11:18:57Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.commons.string;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

/**
 * Default implementation of {@link IRegexReplacement}.
 * 
 * 
 * @author Florian Deissenboeck
 * @author $Author: juergens $
 * @version $Rev: 26283 $
 * @levd.rating GREEN Hash: 09EE4C50B63A33A746B17374B444B592
 */
public class RegexReplacement implements IRegexReplacement {

    /** The pattern. */
    private final Pattern pattern;

    /** The replacement. */
    private final String replacement;

    /**
     * Create a new regex replacement. Syntax for patterns and replacements is
     * specified in the API documentation of {@link java.util.regex.Pattern} and
     * {@link java.util.regex.Matcher}.
     * 
     * @throws PatternSyntaxException
     *             if the pattern has a syntax error
     */
    public RegexReplacement(String regex, String replacement)
            throws PatternSyntaxException {
        pattern = Pattern.compile(regex);
        this.replacement = replacement;
    }

    /**
     * Create a new regex replacement that does not replace the pattern matches
     * by another string but deletes them. Syntax for patterns is specified in
     * the API documentation of {@link java.util.regex.Pattern}.
     * 
     * @throws PatternSyntaxException
     *             if the pattern has a syntax error
     */
    public RegexReplacement(String regex) throws PatternSyntaxException {
        this(regex, StringUtils.EMPTY_STRING);
    }
    
    /** {@inheritDoc} */
    public Pattern getPattern() {
        return pattern;
    }
    
    /** {@inheritDoc} */
    public String getReplacement() {
        return replacement;
    }

}