/*--------------------------------------------------------------------------+
$Id: ArrayUtils.java 29779 2010-08-19 07:32:58Z deissenb $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.commons.collections;


/**
 * Utility methods for arrays.
 * 
 * @author hummelb
 * @author $Author: deissenb $
 * @version $Rev: 29779 $
 * @levd.rating GREEN Hash: A1919A9F7B9B0DE52A0860D17B16AB6A
 */
public class ArrayUtils {

	/** Returns whether one array is a prefix of another one. */
	public static boolean isPrefix(byte[] prefix, byte[] array) {
		if (prefix.length > array.length) {
			return false;
		}
		for (int i = 0; i < prefix.length; ++i) {
			if (prefix[i] != array[i]) {
				return false;
			}
		}
		return true;
	}
}
