/* Generated by GOB (v2.0.14)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 14

#define selfp (self->_priv)

#include "complearn-vcart.h"

#include "complearn-vcart-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 8 "complearn-vcart.gob"

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <limits.h>
#include <string.h>
#include <assert.h>
#include <math.h>
#include <gmodule.h>
#include <libintl.h>

#define COMPRESSOR_NAME "art"

#define _(O) gettext(O)

G_MODULE_EXPORT const gchar* g_module_check_init(void *gm)
{
  complearn_vcart_new();
  return NULL;
}

struct ARTCompressionInstance {
  void *baseClass;
  int c[256];
};

static double simple_art_compress(const GString *inp)
{
  struct ARTCompressionInstance *artci = calloc(sizeof(*artci), 1);
  int sum = 0;
  int i;
  double codelen = 0.0;

  for (i = 0; i < 256 ; i++) {
    artci->c[i] = 1;
  }
  sum = 256;

  unsigned char *data = inp->str;
  for (i = 0; i < inp->len; i++) {
    unsigned char cur;
    double prob;
    cur = data[i];
    prob = ((double) artci->c[cur]) / ((double) sum);
    codelen -= log(prob);
    artci->c[cur] += 1;
    sum += 1;
  }
  free(artci);
  return codelen/log(2);
}



#line 81 "complearn-vcart.c"
/* self casting macros */
#define SELF(x) COMPLEARN_VCART(x)
#define SELF_CONST(x) COMPLEARN_VCART_CONST(x)
#define IS_SELF(x) COMPLEARN_IS_VCART(x)
#define TYPE_SELF COMPLEARN_TYPE_VCART
#define SELF_CLASS(x) COMPLEARN_VCART_CLASS(x)

#define SELF_GET_CLASS(x) COMPLEARN_VCART_GET_CLASS(x)

/* self typedefs */
typedef CompLearnVCArt Self;
typedef CompLearnVCArtClass SelfClass;

/* here are local prototypes */
static void complearn_vcart_init (CompLearnVCArt * o) G_GNUC_UNUSED;
static void complearn_vcart_class_init (CompLearnVCArtClass * c) G_GNUC_UNUSED;

/* pointer to the class of our parent */
static CompLearnRealCompressorAdaptorClass *parent_class = NULL;

/* Short form macros */
#define self_new complearn_vcart_new
#define self_compress complearn_vcart_compress
#define self_decompress complearn_vcart_decompress
#define self_blurb complearn_vcart_blurb
#define self_name complearn_vcart_name
#define self_is_operational complearn_vcart_is_operational
#define self_compressor_version complearn_vcart_compressor_version
#define self_binding_version complearn_vcart_binding_version
#define self_compressed_size complearn_vcart_compressed_size
#define self_is_just_size complearn_vcart_is_just_size


static void
___CompLearn_Real_Compressor_init (CompLearnRealCompressorIface *iface)
{
#line 73 "complearn-vcart.gob"
	iface->compress = self_compress;
#line 77 "complearn-vcart.gob"
	iface->decompress = self_decompress;
#line 81 "complearn-vcart.gob"
	iface->blurb = self_blurb;
#line 85 "complearn-vcart.gob"
	iface->name = self_name;
#line 89 "complearn-vcart.gob"
	iface->is_operational = self_is_operational;
#line 93 "complearn-vcart.gob"
	iface->compressor_version = self_compressor_version;
#line 97 "complearn-vcart.gob"
	iface->binding_version = self_binding_version;
#line 101 "complearn-vcart.gob"
	iface->compressed_size = self_compressed_size;
#line 105 "complearn-vcart.gob"
	iface->is_just_size = self_is_just_size;
#line 136 "complearn-vcart.c"
}

GType
complearn_vcart_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (CompLearnVCArtClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) complearn_vcart_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (CompLearnVCArt),
			0 /* n_preallocs */,
			(GInstanceInitFunc) complearn_vcart_init,
			NULL
		};

		static const GInterfaceInfo CompLearn_Real_Compressor_info = {
			(GInterfaceInitFunc) ___CompLearn_Real_Compressor_init,
			NULL,
			NULL
		};

		type = g_type_register_static (COMPLEARN_TYPE_REAL_COMPRESSOR_ADAPTOR, "CompLearnVCArt", &info, (GTypeFlags)0);
		g_type_add_interface_static (type,
			COMPLEARN_TYPE_REAL_COMPRESSOR,
			&CompLearn_Real_Compressor_info);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((CompLearnVCArt *)g_object_new(complearn_vcart_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static CompLearnVCArt * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static CompLearnVCArt *
GET_NEW_VARG (const char *first, ...)
{
	CompLearnVCArt *ret;
	va_list ap;
	va_start (ap, first);
	ret = (CompLearnVCArt *)g_object_new_valist (complearn_vcart_get_type (), first, ap);
	va_end (ap);
	return ret;
}

static void 
complearn_vcart_init (CompLearnVCArt * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "CompLearn:VCArt::init"
}
#undef __GOB_FUNCTION__
static void 
complearn_vcart_class_init (CompLearnVCArtClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "CompLearn:VCArt::class_init"

	parent_class = g_type_class_ref (COMPLEARN_TYPE_REAL_COMPRESSOR_ADAPTOR);

}
#undef __GOB_FUNCTION__



#line 67 "complearn-vcart.gob"
GObject * 
complearn_vcart_new (void)
#line 211 "complearn-vcart.c"
{
#define __GOB_FUNCTION__ "CompLearn:VCArt::new"
{
#line 68 "complearn-vcart.gob"
	
    GObject *self = (GObject *) GET_NEW;
    SET_DEFAULT_PROPS(COMPRESSOR_NAME, COMPLEARN_VCART_GET_CLASS, self);
    return G_OBJECT (self);
  }}
#line 221 "complearn-vcart.c"
#undef __GOB_FUNCTION__

#line 73 "complearn-vcart.gob"
GString * 
complearn_vcart_compress (CompLearnRealCompressor * rc, const GString * input)
#line 227 "complearn-vcart.c"
{
#define __GOB_FUNCTION__ "CompLearn:VCArt::compress"
{
#line 74 "complearn-vcart.gob"
	
    return NULL;
  }}
#line 235 "complearn-vcart.c"
#undef __GOB_FUNCTION__

#line 77 "complearn-vcart.gob"
GString * 
complearn_vcart_decompress (CompLearnRealCompressor * rc, const GString * input)
#line 241 "complearn-vcart.c"
{
#define __GOB_FUNCTION__ "CompLearn:VCArt::decompress"
{
#line 78 "complearn-vcart.gob"
	
    return NULL;
  }}
#line 249 "complearn-vcart.c"
#undef __GOB_FUNCTION__

#line 81 "complearn-vcart.gob"
GString * 
complearn_vcart_blurb (CompLearnRealCompressor * rc)
#line 255 "complearn-vcart.c"
{
#define __GOB_FUNCTION__ "CompLearn:VCArt::blurb"
{
#line 82 "complearn-vcart.gob"
	
    return g_string_new(_("simple non-coding arirthmetic with fractional bit return"));
  }}
#line 263 "complearn-vcart.c"
#undef __GOB_FUNCTION__

#line 85 "complearn-vcart.gob"
GString * 
complearn_vcart_name (CompLearnRealCompressor * rc)
#line 269 "complearn-vcart.c"
{
#define __GOB_FUNCTION__ "CompLearn:VCArt::name"
{
#line 86 "complearn-vcart.gob"
	
    return g_string_new(COMPRESSOR_NAME);
  }}
#line 277 "complearn-vcart.c"
#undef __GOB_FUNCTION__

#line 89 "complearn-vcart.gob"
gboolean 
complearn_vcart_is_operational (CompLearnRealCompressor * rc)
#line 283 "complearn-vcart.c"
{
#define __GOB_FUNCTION__ "CompLearn:VCArt::is_operational"
{
#line 90 "complearn-vcart.gob"
	
    return TRUE;
  }}
#line 291 "complearn-vcart.c"
#undef __GOB_FUNCTION__

#line 93 "complearn-vcart.gob"
GString * 
complearn_vcart_compressor_version (CompLearnRealCompressor * rc)
#line 297 "complearn-vcart.c"
{
#define __GOB_FUNCTION__ "CompLearn:VCArt::compressor_version"
{
#line 94 "complearn-vcart.gob"
	
    return g_string_new("0.0.0");
  }}
#line 305 "complearn-vcart.c"
#undef __GOB_FUNCTION__

#line 97 "complearn-vcart.gob"
GString * 
complearn_vcart_binding_version (CompLearnRealCompressor * rc)
#line 311 "complearn-vcart.c"
{
#define __GOB_FUNCTION__ "CompLearn:VCArt::binding_version"
{
#line 98 "complearn-vcart.gob"
	
    return g_string_new("0.0.0");
  }}
#line 319 "complearn-vcart.c"
#undef __GOB_FUNCTION__

#line 101 "complearn-vcart.gob"
gdouble 
complearn_vcart_compressed_size (CompLearnRealCompressor * rc, const GString * input)
#line 325 "complearn-vcart.c"
{
#define __GOB_FUNCTION__ "CompLearn:VCArt::compressed_size"
{
#line 102 "complearn-vcart.gob"
	
    return simple_art_compress(input);
  }}
#line 333 "complearn-vcart.c"
#undef __GOB_FUNCTION__

#line 105 "complearn-vcart.gob"
gboolean 
complearn_vcart_is_just_size (CompLearnRealCompressor * rc)
#line 339 "complearn-vcart.c"
{
#define __GOB_FUNCTION__ "CompLearn:VCArt::is_just_size"
{
#line 106 "complearn-vcart.gob"
	
    return TRUE;
  }}
#line 347 "complearn-vcart.c"
#undef __GOB_FUNCTION__
