/* Generated by GOB (v2.0.14)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 14

#define selfp (self->_priv)

#include <string.h> /* memset() */

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 6 "complearn-ncd.gob"

#include <stdio.h>
#include <stdlib.h>
#include <glib.h>
#include <libintl.h>
#include <unistd.h>
#include <getopt.h>
#include "real-compressor.h"
#include "complearn/complearn.h"
#include "complearn-ncd.h"
#include "complearn-ncd-private.h"

#define _(O) gettext(O)

#define NCD_INTERP_LITERAL   0
#define NCD_INTERP_FILE      1
#define NCD_INTERP_TERMLIST  2
#define NCD_INTERP_FILELIST  3
#define NCD_INTERP_DIRECTORY 4

static CompLearnNcd *clncd;


#line 46 "complearn-ncd.c"
/* self casting macros */
#define SELF(x) COMPLEARN_NCD(x)
#define SELF_CONST(x) COMPLEARN_NCD_CONST(x)
#define IS_SELF(x) COMPLEARN_IS_NCD(x)
#define TYPE_SELF COMPLEARN_TYPE_NCD
#define SELF_CLASS(x) COMPLEARN_NCD_CLASS(x)

#define SELF_GET_CLASS(x) COMPLEARN_NCD_GET_CLASS(x)

/* self typedefs */
typedef CompLearnNcd Self;
typedef CompLearnNcdClass SelfClass;

/* here are local prototypes */
static void ___object_set_property (GObject *object, guint property_id, const GValue *value, GParamSpec *pspec);
static void ___object_get_property (GObject *object, guint property_id, GValue *value, GParamSpec *pspec);
static void complearn_ncd_init (CompLearnNcd * o) G_GNUC_UNUSED;
static void complearn_ncd_class_init (CompLearnNcdClass * klass) G_GNUC_UNUSED;
static CompLearnRealCompressor * complearn_ncd_get_real_compressor (void) G_GNUC_UNUSED;

enum {
	PROP_0,
	PROP_OUTPUT_FILESTEM,
	PROP_COMPRESSOR,
	PROP_CHOP_NAMES,
	PROP_WRITE_TXT,
	PROP_CLB_OUTPUT,
	PROP_PLAIN_OUTPUT,
	PROP_NEXUS_OUTPUT,
	PROP_ZERO_DIAGONAL,
	PROP_SVD_PROJECT,
	PROP_HTML_OUTPUT,
	PROP_SHOW_LABELS,
	PROP_JUST_SIZE,
	PROP_AVERAGE_MATRIX
};

/* pointer to the class of our parent */
static GObjectClass *parent_class = NULL;

/* Short form macros */
#define self_new complearn_ncd_new
#define self_get_output_filestem complearn_ncd_get_output_filestem
#define self_set_output_filestem complearn_ncd_set_output_filestem
#define self_get_compressor complearn_ncd_get_compressor
#define self_set_compressor complearn_ncd_set_compressor
#define self_get_chop_names complearn_ncd_get_chop_names
#define self_set_chop_names complearn_ncd_set_chop_names
#define self_get_write_txt complearn_ncd_get_write_txt
#define self_set_write_txt complearn_ncd_set_write_txt
#define self_get_clb_output complearn_ncd_get_clb_output
#define self_set_clb_output complearn_ncd_set_clb_output
#define self_get_plain_output complearn_ncd_get_plain_output
#define self_set_plain_output complearn_ncd_set_plain_output
#define self_get_nexus_output complearn_ncd_get_nexus_output
#define self_set_nexus_output complearn_ncd_set_nexus_output
#define self_get_zero_diagonal complearn_ncd_get_zero_diagonal
#define self_set_zero_diagonal complearn_ncd_set_zero_diagonal
#define self_get_svd_project complearn_ncd_get_svd_project
#define self_set_svd_project complearn_ncd_set_svd_project
#define self_get_html_output complearn_ncd_get_html_output
#define self_set_html_output complearn_ncd_set_html_output
#define self_get_show_labels complearn_ncd_get_show_labels
#define self_set_show_labels complearn_ncd_set_show_labels
#define self_get_just_size complearn_ncd_get_just_size
#define self_set_just_size complearn_ncd_set_just_size
#define self_get_average_matrix complearn_ncd_get_average_matrix
#define self_set_average_matrix complearn_ncd_set_average_matrix
#define self_process_options complearn_ncd_process_options
#define self_get_argument complearn_ncd_get_argument
#define self_add_argument complearn_ncd_add_argument
#define self_print_help_and_exit complearn_ncd_print_help_and_exit
#define self_do_single_list complearn_ncd_do_single_list
#define self_vector_prettyprint complearn_ncd_vector_prettyprint
#define self_make_output_filename complearn_ncd_make_output_filename
#define self_complearn_fix_labels complearn_ncd_complearn_fix_labels
#define self_do_double_list complearn_ncd_do_double_list
#define self_get_complete_output_filename complearn_ncd_get_complete_output_filename
#define self_set_nexus_output_mode complearn_ncd_set_nexus_output_mode
#define self_set_binary_output_mode complearn_ncd_set_binary_output_mode
#define self_set_quiet_mode complearn_ncd_set_quiet_mode
#define self_set_directory_mode complearn_ncd_set_directory_mode
#define self_set_literal_mode complearn_ncd_set_literal_mode
#define self_set_file_mode complearn_ncd_set_file_mode
#define self_print_compressor_list complearn_ncd_print_compressor_list
#define self_set_write_mode complearn_ncd_set_write_mode
#define self_set_size_mode complearn_ncd_set_size_mode
#define self_set_termlist_mode complearn_ncd_set_termlist_mode
#define self_set_filelist_mode complearn_ncd_set_filelist_mode
#define self_interpret_argument complearn_ncd_interpret_argument
#define self_mymndf complearn_ncd_mymndf
#define self_top complearn_ncd_top
#define self_get_compressor_driver complearn_ncd_get_compressor_driver
#define self_ncd_matrix complearn_ncd_ncd_matrix
#define self_load_compressor complearn_ncd_load_compressor
#define self_get_real_compressor complearn_ncd_get_real_compressor
GType
complearn_ncd_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (CompLearnNcdClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) complearn_ncd_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (CompLearnNcd),
			0 /* n_preallocs */,
			(GInstanceInitFunc) complearn_ncd_init,
			NULL
		};

		type = g_type_register_static (G_TYPE_OBJECT, "CompLearnNcd", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((CompLearnNcd *)g_object_new(complearn_ncd_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static CompLearnNcd * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static CompLearnNcd *
GET_NEW_VARG (const char *first, ...)
{
	CompLearnNcd *ret;
	va_list ap;
	va_start (ap, first);
	ret = (CompLearnNcd *)g_object_new_valist (complearn_ncd_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "CompLearn:Ncd::finalize"
	CompLearnNcd *self G_GNUC_UNUSED = COMPLEARN_NCD (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
}
#undef __GOB_FUNCTION__

static void 
complearn_ncd_init (CompLearnNcd * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "CompLearn:Ncd::init"
	o->_priv = G_TYPE_INSTANCE_GET_PRIVATE(o,COMPLEARN_TYPE_NCD,CompLearnNcdPrivate);
}
#undef __GOB_FUNCTION__
#line 34 "complearn-ncd.gob"
static void 
complearn_ncd_class_init (CompLearnNcdClass * klass G_GNUC_UNUSED)
#line 207 "complearn-ncd.c"
{
#define __GOB_FUNCTION__ "CompLearn:Ncd::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) klass;

	g_type_class_add_private(klass,sizeof(CompLearnNcdPrivate));

	parent_class = g_type_class_ref (G_TYPE_OBJECT);

	g_object_class->finalize = ___finalize;
	g_object_class->get_property = ___object_get_property;
	g_object_class->set_property = ___object_set_property;
    {
	GParamSpec   *param_spec;

	param_spec = g_param_spec_string
		("output_filestem" /* name */,
		 _("output_filestem") /* nick */,
		 _("prefix of output filename for matrix") /* blurb */,
		 _("distmatrix") /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (g_object_class,
		PROP_OUTPUT_FILESTEM,
		param_spec);
	param_spec = g_param_spec_string
		("compressor" /* name */,
		 _("compressor") /* nick */,
		 _("default compressor to use") /* blurb */,
		 _("zlib") /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (g_object_class,
		PROP_COMPRESSOR,
		param_spec);
	param_spec = g_param_spec_boolean
		("chop_names" /* name */,
		 _("chop_names") /* nick */,
		 _("remove common prefixes/suffixes from names") /* blurb */,
		 TRUE /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (g_object_class,
		PROP_CHOP_NAMES,
		param_spec);
	param_spec = g_param_spec_boolean
		("write_txt" /* name */,
		 _("write_txt") /* nick */,
		 _("write text format matrix to file") /* blurb */,
		 FALSE /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (g_object_class,
		PROP_WRITE_TXT,
		param_spec);
	param_spec = g_param_spec_boolean
		("clb_output" /* name */,
		 _("clb_output") /* nick */,
		 _("print a clb-format output distance matrix") /* blurb */,
		 FALSE /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (g_object_class,
		PROP_CLB_OUTPUT,
		param_spec);
	param_spec = g_param_spec_boolean
		("plain_output" /* name */,
		 _("plain_output") /* nick */,
		 _("print a plain format output distance matrix") /* blurb */,
		 TRUE /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (g_object_class,
		PROP_PLAIN_OUTPUT,
		param_spec);
	param_spec = g_param_spec_boolean
		("nexus_output" /* name */,
		 _("nexus_output") /* nick */,
		 _("print a NEXUS format output distance matrix") /* blurb */,
		 FALSE /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (g_object_class,
		PROP_NEXUS_OUTPUT,
		param_spec);
	param_spec = g_param_spec_boolean
		("zero_diagonal" /* name */,
		 _("zero_diagonal") /* nick */,
		 _("zero diagonal when arguments are the same") /* blurb */,
		 TRUE /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (g_object_class,
		PROP_ZERO_DIAGONAL,
		param_spec);
	param_spec = g_param_spec_boolean
		("svd_project" /* name */,
		 _("svd_project") /* nick */,
		 _("perform SVD projection on the matrix") /* blurb */,
		 FALSE /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (g_object_class,
		PROP_SVD_PROJECT,
		param_spec);
	param_spec = g_param_spec_boolean
		("html_output" /* name */,
		 _("html_output") /* nick */,
		 _("print HTML table in text output mode") /* blurb */,
		 FALSE /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (g_object_class,
		PROP_HTML_OUTPUT,
		param_spec);
	param_spec = g_param_spec_boolean
		("show_labels" /* name */,
		 _("show_labels") /* nick */,
		 _("print labels in default text output mode") /* blurb */,
		 TRUE /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (g_object_class,
		PROP_SHOW_LABELS,
		param_spec);
	param_spec = g_param_spec_boolean
		("just_size" /* name */,
		 _("just_size") /* nick */,
		 _("only calculate compressed size, not NCD") /* blurb */,
		 FALSE /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (g_object_class,
		PROP_JUST_SIZE,
		param_spec);
	param_spec = g_param_spec_boolean
		("average_matrix" /* name */,
		 _("average_matrix") /* nick */,
		 _("average matrix before outputting result") /* blurb */,
		 TRUE /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (g_object_class,
		PROP_AVERAGE_MATRIX,
		param_spec);
    }
}
#undef __GOB_FUNCTION__

static void
___object_set_property (GObject *object,
	guint property_id,
	const GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "CompLearn:Ncd::set_property"
{
	CompLearnNcd *self G_GNUC_UNUSED;

	self = COMPLEARN_NCD (object);

	switch (property_id) {
	case PROP_OUTPUT_FILESTEM:
		{
#line 48 "complearn-ncd.gob"
{ char *old = self->_priv->output_filestem; self->_priv->output_filestem = g_value_dup_string (VAL); g_free (old); }
#line 359 "complearn-ncd.c"
		}
		break;
	case PROP_COMPRESSOR:
		{
#line 56 "complearn-ncd.gob"
{ char *old = self->_priv->compressor; self->_priv->compressor = g_value_dup_string (VAL); g_free (old); }
#line 366 "complearn-ncd.c"
		}
		break;
	case PROP_CHOP_NAMES:
		{
#line 64 "complearn-ncd.gob"
self->_priv->chop_names = g_value_get_boolean (VAL);
#line 373 "complearn-ncd.c"
		}
		break;
	case PROP_WRITE_TXT:
		{
#line 72 "complearn-ncd.gob"
self->_priv->write_txt = g_value_get_boolean (VAL);
#line 380 "complearn-ncd.c"
		}
		break;
	case PROP_CLB_OUTPUT:
		{
#line 80 "complearn-ncd.gob"
self->_priv->clb_output = g_value_get_boolean (VAL);
#line 387 "complearn-ncd.c"
		}
		break;
	case PROP_PLAIN_OUTPUT:
		{
#line 88 "complearn-ncd.gob"
self->_priv->plain_output = g_value_get_boolean (VAL);
#line 394 "complearn-ncd.c"
		}
		break;
	case PROP_NEXUS_OUTPUT:
		{
#line 96 "complearn-ncd.gob"
self->_priv->nexus_output = g_value_get_boolean (VAL);
#line 401 "complearn-ncd.c"
		}
		break;
	case PROP_ZERO_DIAGONAL:
		{
#line 104 "complearn-ncd.gob"
self->_priv->zero_diagonal = g_value_get_boolean (VAL);
#line 408 "complearn-ncd.c"
		}
		break;
	case PROP_SVD_PROJECT:
		{
#line 112 "complearn-ncd.gob"
self->_priv->svd_project = g_value_get_boolean (VAL);
#line 415 "complearn-ncd.c"
		}
		break;
	case PROP_HTML_OUTPUT:
		{
#line 120 "complearn-ncd.gob"
self->_priv->html_output = g_value_get_boolean (VAL);
#line 422 "complearn-ncd.c"
		}
		break;
	case PROP_SHOW_LABELS:
		{
#line 128 "complearn-ncd.gob"
self->_priv->show_labels = g_value_get_boolean (VAL);
#line 429 "complearn-ncd.c"
		}
		break;
	case PROP_JUST_SIZE:
		{
#line 136 "complearn-ncd.gob"
self->_priv->just_size = g_value_get_boolean (VAL);
#line 436 "complearn-ncd.c"
		}
		break;
	case PROP_AVERAGE_MATRIX:
		{
#line 144 "complearn-ncd.gob"
self->_priv->average_matrix = g_value_get_boolean (VAL);
#line 443 "complearn-ncd.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__

static void
___object_get_property (GObject *object,
	guint property_id,
	GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "CompLearn:Ncd::get_property"
{
	CompLearnNcd *self G_GNUC_UNUSED;

	self = COMPLEARN_NCD (object);

	switch (property_id) {
	case PROP_OUTPUT_FILESTEM:
		{
#line 48 "complearn-ncd.gob"
g_value_set_string (VAL, self->_priv->output_filestem);
#line 474 "complearn-ncd.c"
		}
		break;
	case PROP_COMPRESSOR:
		{
#line 56 "complearn-ncd.gob"
g_value_set_string (VAL, self->_priv->compressor);
#line 481 "complearn-ncd.c"
		}
		break;
	case PROP_CHOP_NAMES:
		{
#line 64 "complearn-ncd.gob"
g_value_set_boolean (VAL, self->_priv->chop_names);
#line 488 "complearn-ncd.c"
		}
		break;
	case PROP_WRITE_TXT:
		{
#line 72 "complearn-ncd.gob"
g_value_set_boolean (VAL, self->_priv->write_txt);
#line 495 "complearn-ncd.c"
		}
		break;
	case PROP_CLB_OUTPUT:
		{
#line 80 "complearn-ncd.gob"
g_value_set_boolean (VAL, self->_priv->clb_output);
#line 502 "complearn-ncd.c"
		}
		break;
	case PROP_PLAIN_OUTPUT:
		{
#line 88 "complearn-ncd.gob"
g_value_set_boolean (VAL, self->_priv->plain_output);
#line 509 "complearn-ncd.c"
		}
		break;
	case PROP_NEXUS_OUTPUT:
		{
#line 96 "complearn-ncd.gob"
g_value_set_boolean (VAL, self->_priv->nexus_output);
#line 516 "complearn-ncd.c"
		}
		break;
	case PROP_ZERO_DIAGONAL:
		{
#line 104 "complearn-ncd.gob"
g_value_set_boolean (VAL, self->_priv->zero_diagonal);
#line 523 "complearn-ncd.c"
		}
		break;
	case PROP_SVD_PROJECT:
		{
#line 112 "complearn-ncd.gob"
g_value_set_boolean (VAL, self->_priv->svd_project);
#line 530 "complearn-ncd.c"
		}
		break;
	case PROP_HTML_OUTPUT:
		{
#line 120 "complearn-ncd.gob"
g_value_set_boolean (VAL, self->_priv->html_output);
#line 537 "complearn-ncd.c"
		}
		break;
	case PROP_SHOW_LABELS:
		{
#line 128 "complearn-ncd.gob"
g_value_set_boolean (VAL, self->_priv->show_labels);
#line 544 "complearn-ncd.c"
		}
		break;
	case PROP_JUST_SIZE:
		{
#line 136 "complearn-ncd.gob"
g_value_set_boolean (VAL, self->_priv->just_size);
#line 551 "complearn-ncd.c"
		}
		break;
	case PROP_AVERAGE_MATRIX:
		{
#line 144 "complearn-ncd.gob"
g_value_set_boolean (VAL, self->_priv->average_matrix);
#line 558 "complearn-ncd.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__



#line 36 "complearn-ncd.gob"
GObject * 
complearn_ncd_new (void)
#line 578 "complearn-ncd.c"
{
#define __GOB_FUNCTION__ "CompLearn:Ncd::new"
{
#line 37 "complearn-ncd.gob"
	
    GObject *ret = (GObject *) GET_NEW;
    CompLearnNcd *self = COMPLEARN_NCD(ret);
    if (clncd)
      g_error(_("Only one ncd object may be created."));
    clncd = self;
    self->_priv = calloc(1, sizeof(*self->_priv));
    SET_DEFAULT_PROPS("ncd", COMPLEARN_NCD_GET_CLASS, self);
    return G_OBJECT (ret);
  }}
#line 593 "complearn-ncd.c"
#undef __GOB_FUNCTION__

#line 48 "complearn-ncd.gob"
gchar * 
complearn_ncd_get_output_filestem (CompLearnNcd * self)
#line 599 "complearn-ncd.c"
{
#define __GOB_FUNCTION__ "CompLearn:Ncd::get_output_filestem"
{
#line 48 "complearn-ncd.gob"
		gchar* val; g_object_get (G_OBJECT (self), "output_filestem", &val, NULL); return val;
}}
#line 606 "complearn-ncd.c"
#undef __GOB_FUNCTION__

#line 48 "complearn-ncd.gob"
void 
complearn_ncd_set_output_filestem (CompLearnNcd * self, gchar * val)
#line 612 "complearn-ncd.c"
{
#define __GOB_FUNCTION__ "CompLearn:Ncd::set_output_filestem"
{
#line 48 "complearn-ncd.gob"
		g_object_set (G_OBJECT (self), "output_filestem", val, NULL);
}}
#line 619 "complearn-ncd.c"
#undef __GOB_FUNCTION__

#line 56 "complearn-ncd.gob"
gchar * 
complearn_ncd_get_compressor (CompLearnNcd * self)
#line 625 "complearn-ncd.c"
{
#define __GOB_FUNCTION__ "CompLearn:Ncd::get_compressor"
{
#line 56 "complearn-ncd.gob"
		gchar* val; g_object_get (G_OBJECT (self), "compressor", &val, NULL); return val;
}}
#line 632 "complearn-ncd.c"
#undef __GOB_FUNCTION__

#line 56 "complearn-ncd.gob"
void 
complearn_ncd_set_compressor (CompLearnNcd * self, gchar * val)
#line 638 "complearn-ncd.c"
{
#define __GOB_FUNCTION__ "CompLearn:Ncd::set_compressor"
{
#line 56 "complearn-ncd.gob"
		g_object_set (G_OBJECT (self), "compressor", val, NULL);
}}
#line 645 "complearn-ncd.c"
#undef __GOB_FUNCTION__

#line 64 "complearn-ncd.gob"
gboolean 
complearn_ncd_get_chop_names (CompLearnNcd * self)
#line 651 "complearn-ncd.c"
{
#define __GOB_FUNCTION__ "CompLearn:Ncd::get_chop_names"
{
#line 64 "complearn-ncd.gob"
		gboolean val; g_object_get (G_OBJECT (self), "chop_names", &val, NULL); return val;
}}
#line 658 "complearn-ncd.c"
#undef __GOB_FUNCTION__

#line 64 "complearn-ncd.gob"
void 
complearn_ncd_set_chop_names (CompLearnNcd * self, gboolean val)
#line 664 "complearn-ncd.c"
{
#define __GOB_FUNCTION__ "CompLearn:Ncd::set_chop_names"
{
#line 64 "complearn-ncd.gob"
		g_object_set (G_OBJECT (self), "chop_names", val, NULL);
}}
#line 671 "complearn-ncd.c"
#undef __GOB_FUNCTION__

#line 72 "complearn-ncd.gob"
gboolean 
complearn_ncd_get_write_txt (CompLearnNcd * self)
#line 677 "complearn-ncd.c"
{
#define __GOB_FUNCTION__ "CompLearn:Ncd::get_write_txt"
{
#line 72 "complearn-ncd.gob"
		gboolean val; g_object_get (G_OBJECT (self), "write_txt", &val, NULL); return val;
}}
#line 684 "complearn-ncd.c"
#undef __GOB_FUNCTION__

#line 72 "complearn-ncd.gob"
void 
complearn_ncd_set_write_txt (CompLearnNcd * self, gboolean val)
#line 690 "complearn-ncd.c"
{
#define __GOB_FUNCTION__ "CompLearn:Ncd::set_write_txt"
{
#line 72 "complearn-ncd.gob"
		g_object_set (G_OBJECT (self), "write_txt", val, NULL);
}}
#line 697 "complearn-ncd.c"
#undef __GOB_FUNCTION__

#line 80 "complearn-ncd.gob"
gboolean 
complearn_ncd_get_clb_output (CompLearnNcd * self)
#line 703 "complearn-ncd.c"
{
#define __GOB_FUNCTION__ "CompLearn:Ncd::get_clb_output"
{
#line 80 "complearn-ncd.gob"
		gboolean val; g_object_get (G_OBJECT (self), "clb_output", &val, NULL); return val;
}}
#line 710 "complearn-ncd.c"
#undef __GOB_FUNCTION__

#line 80 "complearn-ncd.gob"
void 
complearn_ncd_set_clb_output (CompLearnNcd * self, gboolean val)
#line 716 "complearn-ncd.c"
{
#define __GOB_FUNCTION__ "CompLearn:Ncd::set_clb_output"
{
#line 80 "complearn-ncd.gob"
		g_object_set (G_OBJECT (self), "clb_output", val, NULL);
}}
#line 723 "complearn-ncd.c"
#undef __GOB_FUNCTION__

#line 88 "complearn-ncd.gob"
gboolean 
complearn_ncd_get_plain_output (CompLearnNcd * self)
#line 729 "complearn-ncd.c"
{
#define __GOB_FUNCTION__ "CompLearn:Ncd::get_plain_output"
{
#line 88 "complearn-ncd.gob"
		gboolean val; g_object_get (G_OBJECT (self), "plain_output", &val, NULL); return val;
}}
#line 736 "complearn-ncd.c"
#undef __GOB_FUNCTION__

#line 88 "complearn-ncd.gob"
void 
complearn_ncd_set_plain_output (CompLearnNcd * self, gboolean val)
#line 742 "complearn-ncd.c"
{
#define __GOB_FUNCTION__ "CompLearn:Ncd::set_plain_output"
{
#line 88 "complearn-ncd.gob"
		g_object_set (G_OBJECT (self), "plain_output", val, NULL);
}}
#line 749 "complearn-ncd.c"
#undef __GOB_FUNCTION__

#line 96 "complearn-ncd.gob"
gboolean 
complearn_ncd_get_nexus_output (CompLearnNcd * self)
#line 755 "complearn-ncd.c"
{
#define __GOB_FUNCTION__ "CompLearn:Ncd::get_nexus_output"
{
#line 96 "complearn-ncd.gob"
		gboolean val; g_object_get (G_OBJECT (self), "nexus_output", &val, NULL); return val;
}}
#line 762 "complearn-ncd.c"
#undef __GOB_FUNCTION__

#line 96 "complearn-ncd.gob"
void 
complearn_ncd_set_nexus_output (CompLearnNcd * self, gboolean val)
#line 768 "complearn-ncd.c"
{
#define __GOB_FUNCTION__ "CompLearn:Ncd::set_nexus_output"
{
#line 96 "complearn-ncd.gob"
		g_object_set (G_OBJECT (self), "nexus_output", val, NULL);
}}
#line 775 "complearn-ncd.c"
#undef __GOB_FUNCTION__

#line 104 "complearn-ncd.gob"
gboolean 
complearn_ncd_get_zero_diagonal (CompLearnNcd * self)
#line 781 "complearn-ncd.c"
{
#define __GOB_FUNCTION__ "CompLearn:Ncd::get_zero_diagonal"
{
#line 104 "complearn-ncd.gob"
		gboolean val; g_object_get (G_OBJECT (self), "zero_diagonal", &val, NULL); return val;
}}
#line 788 "complearn-ncd.c"
#undef __GOB_FUNCTION__

#line 104 "complearn-ncd.gob"
void 
complearn_ncd_set_zero_diagonal (CompLearnNcd * self, gboolean val)
#line 794 "complearn-ncd.c"
{
#define __GOB_FUNCTION__ "CompLearn:Ncd::set_zero_diagonal"
{
#line 104 "complearn-ncd.gob"
		g_object_set (G_OBJECT (self), "zero_diagonal", val, NULL);
}}
#line 801 "complearn-ncd.c"
#undef __GOB_FUNCTION__

#line 112 "complearn-ncd.gob"
gboolean 
complearn_ncd_get_svd_project (CompLearnNcd * self)
#line 807 "complearn-ncd.c"
{
#define __GOB_FUNCTION__ "CompLearn:Ncd::get_svd_project"
{
#line 112 "complearn-ncd.gob"
		gboolean val; g_object_get (G_OBJECT (self), "svd_project", &val, NULL); return val;
}}
#line 814 "complearn-ncd.c"
#undef __GOB_FUNCTION__

#line 112 "complearn-ncd.gob"
void 
complearn_ncd_set_svd_project (CompLearnNcd * self, gboolean val)
#line 820 "complearn-ncd.c"
{
#define __GOB_FUNCTION__ "CompLearn:Ncd::set_svd_project"
{
#line 112 "complearn-ncd.gob"
		g_object_set (G_OBJECT (self), "svd_project", val, NULL);
}}
#line 827 "complearn-ncd.c"
#undef __GOB_FUNCTION__

#line 120 "complearn-ncd.gob"
gboolean 
complearn_ncd_get_html_output (CompLearnNcd * self)
#line 833 "complearn-ncd.c"
{
#define __GOB_FUNCTION__ "CompLearn:Ncd::get_html_output"
{
#line 120 "complearn-ncd.gob"
		gboolean val; g_object_get (G_OBJECT (self), "html_output", &val, NULL); return val;
}}
#line 840 "complearn-ncd.c"
#undef __GOB_FUNCTION__

#line 120 "complearn-ncd.gob"
void 
complearn_ncd_set_html_output (CompLearnNcd * self, gboolean val)
#line 846 "complearn-ncd.c"
{
#define __GOB_FUNCTION__ "CompLearn:Ncd::set_html_output"
{
#line 120 "complearn-ncd.gob"
		g_object_set (G_OBJECT (self), "html_output", val, NULL);
}}
#line 853 "complearn-ncd.c"
#undef __GOB_FUNCTION__

#line 128 "complearn-ncd.gob"
gboolean 
complearn_ncd_get_show_labels (CompLearnNcd * self)
#line 859 "complearn-ncd.c"
{
#define __GOB_FUNCTION__ "CompLearn:Ncd::get_show_labels"
{
#line 128 "complearn-ncd.gob"
		gboolean val; g_object_get (G_OBJECT (self), "show_labels", &val, NULL); return val;
}}
#line 866 "complearn-ncd.c"
#undef __GOB_FUNCTION__

#line 128 "complearn-ncd.gob"
void 
complearn_ncd_set_show_labels (CompLearnNcd * self, gboolean val)
#line 872 "complearn-ncd.c"
{
#define __GOB_FUNCTION__ "CompLearn:Ncd::set_show_labels"
{
#line 128 "complearn-ncd.gob"
		g_object_set (G_OBJECT (self), "show_labels", val, NULL);
}}
#line 879 "complearn-ncd.c"
#undef __GOB_FUNCTION__

#line 136 "complearn-ncd.gob"
gboolean 
complearn_ncd_get_just_size (CompLearnNcd * self)
#line 885 "complearn-ncd.c"
{
#define __GOB_FUNCTION__ "CompLearn:Ncd::get_just_size"
{
#line 136 "complearn-ncd.gob"
		gboolean val; g_object_get (G_OBJECT (self), "just_size", &val, NULL); return val;
}}
#line 892 "complearn-ncd.c"
#undef __GOB_FUNCTION__

#line 136 "complearn-ncd.gob"
void 
complearn_ncd_set_just_size (CompLearnNcd * self, gboolean val)
#line 898 "complearn-ncd.c"
{
#define __GOB_FUNCTION__ "CompLearn:Ncd::set_just_size"
{
#line 136 "complearn-ncd.gob"
		g_object_set (G_OBJECT (self), "just_size", val, NULL);
}}
#line 905 "complearn-ncd.c"
#undef __GOB_FUNCTION__

#line 144 "complearn-ncd.gob"
gboolean 
complearn_ncd_get_average_matrix (CompLearnNcd * self)
#line 911 "complearn-ncd.c"
{
#define __GOB_FUNCTION__ "CompLearn:Ncd::get_average_matrix"
{
#line 144 "complearn-ncd.gob"
		gboolean val; g_object_get (G_OBJECT (self), "average_matrix", &val, NULL); return val;
}}
#line 918 "complearn-ncd.c"
#undef __GOB_FUNCTION__

#line 144 "complearn-ncd.gob"
void 
complearn_ncd_set_average_matrix (CompLearnNcd * self, gboolean val)
#line 924 "complearn-ncd.c"
{
#define __GOB_FUNCTION__ "CompLearn:Ncd::set_average_matrix"
{
#line 144 "complearn-ncd.gob"
		g_object_set (G_OBJECT (self), "average_matrix", val, NULL);
}}
#line 931 "complearn-ncd.c"
#undef __GOB_FUNCTION__

#line 151 "complearn-ncd.gob"
void 
complearn_ncd_process_options (char ** argv)
#line 937 "complearn-ncd.c"
{
#define __GOB_FUNCTION__ "CompLearn:Ncd::process_options"
{
#line 151 "complearn-ncd.gob"
	
    CompLearnNcd *ncd = complearn_ncd_top();
    int argc = complearn_count_strings((const char * const *) argv);
    optind = 1;
    int option_index = 0, c;
    struct option long_options[] = {
      {"binary-output", 0, 0, 'b' },
      {"compressor", 0, 0, 'c'},
      {"directory-mode", 0, 0, 'd'},
      {"file-mode", 0, 0, 'f'},
      {"help", 0, 0, 'h'},
      {"list", 0, 0, 'L'},
      {"literal-mode", 0, 0, 'l'},
      {"nexus-output", 0, 0, 'n'},
      {"output", 0, 0, 'o'},
      {"plainlist-mode", 0, 0, 'p'},
      {"quiet", 0, 0, 'q'},
      {"size", 0, 0, 's'},
      {"termlist-mode", 0, 0, 't'},
      {"verbose", 0, 0, 'v'},
      {"write", 0, 0, 'w'},
      { 0, 0, 0, 0 } };
    while (1) {
      c = getopt_long(argc, (char **) argv, "bc:dfhLlno:pqstvw", long_options, &option_index);
      if (c == -1)
        break;
      switch (c) {
        case 'b': complearn_ncd_set_binary_output_mode(); break;
        case 'c': complearn_ncd_set_compressor(complearn_ncd_top(), optarg);
                  break;
        case 'd': complearn_ncd_set_directory_mode(); break;
        case '?': exit(1); break;
        case 'f': complearn_ncd_set_file_mode(); break;
        case 'h': complearn_ncd_print_help_and_exit(); break;
        case 'L': complearn_ncd_print_compressor_list(); break;
        case 'l': complearn_ncd_set_literal_mode(); break;
        case 'n': complearn_ncd_set_nexus_output_mode(); break;
        case 'o': complearn_ncd_set_output_filestem(complearn_ncd_top(), optarg); complearn_ncd_set_write_mode(); break;
        case 'p': complearn_ncd_set_filelist_mode(); break;
        case 'q': complearn_ncd_set_quiet_mode(); break;
        case 's': complearn_ncd_set_size_mode(); break;
        case 't': complearn_ncd_set_termlist_mode(); break;
        case 'v': complearn_environment_set_verbose_mode(); break;
        case 'w': complearn_ncd_set_write_mode(); break;
        default: g_error(_("Unrecognized option '%c'"), c); break;
      }
    }
    if (optind < argc) {
      int i;
      for (i = optind; i < argc; i += 1)
        complearn_ncd_add_argument(argv[i]);
    }
    switch (g_slist_length(ncd->_priv->listlist)) {
      case 0: complearn_ncd_print_help_and_exit(); break;
     default: complearn_ncd_print_help_and_exit(); break;
      case 1: complearn_ncd_do_single_list(); break;
      case 2: complearn_ncd_do_double_list(); break;
    }
  }}
#line 1001 "complearn-ncd.c"
#undef __GOB_FUNCTION__

#line 210 "complearn-ncd.gob"
GSList * 
complearn_ncd_get_argument (int whichone)
#line 1007 "complearn-ncd.c"
{
#define __GOB_FUNCTION__ "CompLearn:Ncd::get_argument"
{
#line 210 "complearn-ncd.gob"
	
    return g_slist_nth_data(
    complearn_ncd_top()->_priv->listlist, whichone);
  }}
#line 1016 "complearn-ncd.c"
#undef __GOB_FUNCTION__

#line 214 "complearn-ncd.gob"
void 
complearn_ncd_add_argument (const char * arg)
#line 1022 "complearn-ncd.c"
{
#define __GOB_FUNCTION__ "CompLearn:Ncd::add_argument"
{
#line 214 "complearn-ncd.gob"
	
    CompLearnNcd *ncd = complearn_ncd_top();
    GSList *result = complearn_ncd_interpret_argument(g_string_new(arg));
    ncd->_priv->listlist = g_slist_append(ncd->_priv->listlist, result);
  }}
#line 1032 "complearn-ncd.c"
#undef __GOB_FUNCTION__

#line 219 "complearn-ncd.gob"
void 
complearn_ncd_print_help_and_exit (void)
#line 1038 "complearn-ncd.c"
{
#define __GOB_FUNCTION__ "CompLearn:Ncd::print_help_and_exit"
{
#line 219 "complearn-ncd.gob"
	
    fprintf(stderr, "%s",
_(
"Usage: ncd [options] ...  <arg>\n"
"\n"
"Use one argument form to do simple single-object or object-vector     \n"
"compression or\n"
"       ncd [options] ...  <arg1> <arg2>\n"
"  for compression-matrix or NCD matrix calculation\n"
"OPTIONS:                                                              \n"
"  -b, --binary-output         enable binary output mode for matrix    \n"
"  -c, --compressor=COMPNAME   set compressor to use                   \n"
"  -d, --directory-mode        directory of files                      \n"
"  -f, --file-mode             a single file                           \n"
"  -h, --help                  print this help message                 \n"
"  -l, --literal-mode          a single string literal      (default)  \n"
"  -L, --list                  list compressors                        \n"
"  -n, --nexus-output          output NEXUS format distance matrix     \n"
"  -o, --output=FILESTEM       use FILESTEM instead of distmatrix      \n"
"  -p, --plainlist-mode        lines with each line a file             \n"
"  -q, --quiet                 do not print plain text distance matrix \n"
"  -t, --termlist-mode         lines with each line a literal          \n"
"  -s, --size                  just compressed sizes in bits no NCD    \n"
"  -v, --verbose               print extra detailed information        \n"
"\n")
);
    exit(0);
  }}
#line 1071 "complearn-ncd.c"
#undef __GOB_FUNCTION__

#line 247 "complearn-ncd.gob"
void 
complearn_ncd_do_single_list (void)
#line 1077 "complearn-ncd.c"
{
#define __GOB_FUNCTION__ "CompLearn:Ncd::do_single_list"
{
#line 247 "complearn-ncd.gob"
	
    CompLearnNcd *top = complearn_ncd_top();
    g_assert(g_slist_length(top->_priv->listlist) == 1);
    GSList *it, *a = (GSList *) top->_priv->listlist->data;
    CompLearnCompressorDriver *dr = complearn_ncd_get_compressor_driver();
    gsl_vector *result = gsl_vector_calloc(g_slist_length(a));
    int i = 0;
    for (it = a; it; it = g_slist_next(it)) {
      complearn_compressor_driver_store(dr, ((CLArgumentEntry *) (it->data))->block);
      gsl_vector_set(result, i,
        complearn_compressor_driver_compress_single(dr, i));
      i += 1;
    }
    complearn_ncd_vector_prettyprint(result);
  }}
#line 1097 "complearn-ncd.c"
#undef __GOB_FUNCTION__

#line 262 "complearn-ncd.gob"
void 
complearn_ncd_vector_prettyprint (gsl_vector * result)
#line 1103 "complearn-ncd.c"
{
#define __GOB_FUNCTION__ "CompLearn:Ncd::vector_prettyprint"
{
#line 262 "complearn-ncd.gob"
	
    int i;
    for (i = 0; i < result->size; i += 1) {
      printf("%f\n", gsl_vector_get(result, i));
    }
  }}
#line 1114 "complearn-ncd.c"
#undef __GOB_FUNCTION__

#line 268 "complearn-ncd.gob"
char * 
complearn_ncd_make_output_filename (const char * fileext)
#line 1120 "complearn-ncd.c"
{
#define __GOB_FUNCTION__ "CompLearn:Ncd::make_output_filename"
{
#line 268 "complearn-ncd.gob"
	
    return g_strconcat(complearn_ncd_get_output_filestem(complearn_ncd_top()),
                       ".", fileext, NULL); }}
#line 1128 "complearn-ncd.c"
#undef __GOB_FUNCTION__

#line 271 "complearn-ncd.gob"
void 
complearn_ncd_complearn_fix_labels (LabeledMatrix * lm)
#line 1134 "complearn-ncd.c"
{
#define __GOB_FUNCTION__ "CompLearn:Ncd::complearn_fix_labels"
{
#line 271 "complearn-ncd.gob"
	
    if (lm->labels1)
      lm->labels1 = complearn_fix_labels(lm->labels1);
    if (lm->labels2)
      lm->labels2 = complearn_fix_labels(lm->labels2);
  }}
#line 1145 "complearn-ncd.c"
#undef __GOB_FUNCTION__

#line 277 "complearn-ncd.gob"
void 
complearn_ncd_do_double_list (void)
#line 1151 "complearn-ncd.c"
{
#define __GOB_FUNCTION__ "CompLearn:Ncd::do_double_list"
{
#line 277 "complearn-ncd.gob"
	
    CompLearnNcd *top = complearn_ncd_top();
    g_assert(g_slist_length(top->_priv->listlist) == 2);
    GSList *a = (GSList *) top->_priv->listlist->data;
    GSList *b = (GSList *) g_slist_next(top->_priv->listlist)->data;
    LabeledMatrix *result = complearn_ncd_ncd_matrix(a,b);
    if (complearn_ncd_get_chop_names(complearn_ncd_top()))
      complearn_ncd_complearn_fix_labels(result);
    GString *txtVersion = complearn_matrix_prettyprint_text(result);
    GString *output_file_block = NULL;
    if (complearn_ncd_get_clb_output(complearn_ncd_top()))
      output_file_block = complearn_matrix_prettyprint_clb(result);
    if (complearn_ncd_get_nexus_output(complearn_ncd_top()))
      output_file_block = complearn_matrix_prettyprint_nex(result, NULL);
    fprintf(stdout, "%s", txtVersion->str);
    if (output_file_block) {
      complearn_write_file(complearn_ncd_get_complete_output_filename(), output_file_block);
      g_string_free(output_file_block, TRUE);
    }
  }}
#line 1176 "complearn-ncd.c"
#undef __GOB_FUNCTION__

#line 297 "complearn-ncd.gob"
char * 
complearn_ncd_get_complete_output_filename (void)
#line 1182 "complearn-ncd.c"
{
#define __GOB_FUNCTION__ "CompLearn:Ncd::get_complete_output_filename"
{
#line 297 "complearn-ncd.gob"
	
  char *fn = NULL;
  if (complearn_ncd_get_nexus_output(complearn_ncd_top()))
    fn = complearn_ncd_make_output_filename("nex");
  else {
    if (complearn_ncd_get_clb_output(complearn_ncd_top()))
      fn = complearn_ncd_make_output_filename("clb");
    else {
      int html = complearn_ncd_get_html_output(complearn_ncd_top());
      fn = complearn_ncd_make_output_filename(html ? "html" : "txt");
    }
  }
  return fn;
}}
#line 1201 "complearn-ncd.c"
#undef __GOB_FUNCTION__

#line 311 "complearn-ncd.gob"
void 
complearn_ncd_set_nexus_output_mode (void)
#line 1207 "complearn-ncd.c"
{
#define __GOB_FUNCTION__ "CompLearn:Ncd::set_nexus_output_mode"
{
#line 311 "complearn-ncd.gob"
	
  complearn_ncd_set_nexus_output(complearn_ncd_top(), TRUE);
}}
#line 1215 "complearn-ncd.c"
#undef __GOB_FUNCTION__

#line 314 "complearn-ncd.gob"
void 
complearn_ncd_set_binary_output_mode (void)
#line 1221 "complearn-ncd.c"
{
#define __GOB_FUNCTION__ "CompLearn:Ncd::set_binary_output_mode"
{
#line 314 "complearn-ncd.gob"
	
  complearn_ncd_set_clb_output(complearn_ncd_top(), TRUE);
}}
#line 1229 "complearn-ncd.c"
#undef __GOB_FUNCTION__

#line 317 "complearn-ncd.gob"
void 
complearn_ncd_set_quiet_mode (void)
#line 1235 "complearn-ncd.c"
{
#define __GOB_FUNCTION__ "CompLearn:Ncd::set_quiet_mode"
{
#line 317 "complearn-ncd.gob"
	
  complearn_ncd_set_plain_output(complearn_ncd_top(), FALSE);
}}
#line 1243 "complearn-ncd.c"
#undef __GOB_FUNCTION__

#line 320 "complearn-ncd.gob"
void 
complearn_ncd_set_directory_mode (void)
#line 1249 "complearn-ncd.c"
{
#define __GOB_FUNCTION__ "CompLearn:Ncd::set_directory_mode"
{
#line 320 "complearn-ncd.gob"
	
    complearn_ncd_top()->_priv->interp = NCD_INTERP_DIRECTORY;
  }}
#line 1257 "complearn-ncd.c"
#undef __GOB_FUNCTION__

#line 323 "complearn-ncd.gob"
void 
complearn_ncd_set_literal_mode (void)
#line 1263 "complearn-ncd.c"
{
#define __GOB_FUNCTION__ "CompLearn:Ncd::set_literal_mode"
{
#line 323 "complearn-ncd.gob"
	
    complearn_ncd_top()->_priv->interp = NCD_INTERP_LITERAL;
  }}
#line 1271 "complearn-ncd.c"
#undef __GOB_FUNCTION__

#line 326 "complearn-ncd.gob"
void 
complearn_ncd_set_file_mode (void)
#line 1277 "complearn-ncd.c"
{
#define __GOB_FUNCTION__ "CompLearn:Ncd::set_file_mode"
{
#line 326 "complearn-ncd.gob"
	
    complearn_ncd_top()->_priv->interp = NCD_INTERP_FILE;
  }}
#line 1285 "complearn-ncd.c"
#undef __GOB_FUNCTION__

#line 329 "complearn-ncd.gob"
void 
complearn_ncd_print_compressor_list (void)
#line 1291 "complearn-ncd.c"
{
#define __GOB_FUNCTION__ "CompLearn:Ncd::print_compressor_list"
{
#line 329 "complearn-ncd.gob"
	
    char **result = complearn_environment_compressor_list();
    char **t;
    printf(_("Available compressors:\n"));
    for (t = result; *t; t++)
      printf("  %s\n", *t);
    exit(0);
  }}
#line 1304 "complearn-ncd.c"
#undef __GOB_FUNCTION__

#line 337 "complearn-ncd.gob"
void 
complearn_ncd_set_write_mode (void)
#line 1310 "complearn-ncd.c"
{
#define __GOB_FUNCTION__ "CompLearn:Ncd::set_write_mode"
{
#line 337 "complearn-ncd.gob"
	
    complearn_ncd_set_write_txt(complearn_ncd_top(), TRUE);
  }}
#line 1318 "complearn-ncd.c"
#undef __GOB_FUNCTION__

#line 340 "complearn-ncd.gob"
void 
complearn_ncd_set_size_mode (void)
#line 1324 "complearn-ncd.c"
{
#define __GOB_FUNCTION__ "CompLearn:Ncd::set_size_mode"
{
#line 340 "complearn-ncd.gob"
	
    complearn_ncd_set_just_size(complearn_ncd_top(), TRUE);
  }}
#line 1332 "complearn-ncd.c"
#undef __GOB_FUNCTION__

#line 343 "complearn-ncd.gob"
void 
complearn_ncd_set_termlist_mode (void)
#line 1338 "complearn-ncd.c"
{
#define __GOB_FUNCTION__ "CompLearn:Ncd::set_termlist_mode"
{
#line 343 "complearn-ncd.gob"
	
    complearn_ncd_top()->_priv->interp = NCD_INTERP_TERMLIST;
  }}
#line 1346 "complearn-ncd.c"
#undef __GOB_FUNCTION__

#line 346 "complearn-ncd.gob"
void 
complearn_ncd_set_filelist_mode (void)
#line 1352 "complearn-ncd.c"
{
#define __GOB_FUNCTION__ "CompLearn:Ncd::set_filelist_mode"
{
#line 346 "complearn-ncd.gob"
	
    complearn_ncd_top()->_priv->interp = NCD_INTERP_FILELIST;
  }}
#line 1360 "complearn-ncd.c"
#undef __GOB_FUNCTION__

#line 349 "complearn-ncd.gob"
GSList * 
complearn_ncd_interpret_argument (GString * arg)
#line 1366 "complearn-ncd.c"
{
#define __GOB_FUNCTION__ "CompLearn:Ncd::interpret_argument"
{
#line 349 "complearn-ncd.gob"
	
    GSList *result = NULL;
/*
    GError *gerr = NULL;
    GIOChannel *gio = NULL;
*/
    switch (complearn_ncd_top()->_priv->interp) {
      case NCD_INTERP_LITERAL:
        result = g_slist_append(result, complearn_new_arg(g_string_new_len(arg->str,arg->len),arg->str));
        return result;
      case NCD_INTERP_FILE:
        result = g_slist_append(result, complearn_new_arg(complearn_read_whole_file(arg->str),arg->str));
        return result;
      case NCD_INTERP_DIRECTORY:
        result = complearn_read_directory_of_files(arg->str);
        return result;
      case NCD_INTERP_FILELIST:
        result = complearn_read_list_of_files(arg->str);
        return result;
      case NCD_INTERP_TERMLIST:
        result = complearn_read_list_of_strings(arg->str);
        return result;
      default:
        g_error(_("Unhandled interpretation\n"));
    }
  }}
#line 1397 "complearn-ncd.c"
#undef __GOB_FUNCTION__

#line 375 "complearn-ncd.gob"
gdouble 
complearn_ncd_mymndf (double cab, double ca, double cb)
#line 1403 "complearn-ncd.c"
{
#define __GOB_FUNCTION__ "CompLearn:Ncd::mymndf"
{
#line 375 "complearn-ncd.gob"
	
    double result;
    double maxc = ca < cb ? cb : ca;
    double minc = ca < cb ? ca : cb;
    result = (cab - minc) / maxc;
    return result;
  }}
#line 1415 "complearn-ncd.c"
#undef __GOB_FUNCTION__

#line 382 "complearn-ncd.gob"
CompLearnNcd * 
complearn_ncd_top (void)
#line 1421 "complearn-ncd.c"
{
#define __GOB_FUNCTION__ "CompLearn:Ncd::top"
{
#line 383 "complearn-ncd.gob"
	
  if (clncd == NULL)
    complearn_ncd_new();
  g_assert(clncd != 0);
  return clncd;
  }}
#line 1432 "complearn-ncd.c"
#undef __GOB_FUNCTION__

#line 389 "complearn-ncd.gob"
CompLearnCompressorDriver * 
complearn_ncd_get_compressor_driver (void)
#line 1438 "complearn-ncd.c"
{
#define __GOB_FUNCTION__ "CompLearn:Ncd::get_compressor_driver"
{
#line 390 "complearn-ncd.gob"
	
  CompLearnRealCompressor *rc = complearn_ncd_get_real_compressor();
  CompLearnNcd *ncd = COMPLEARN_NCD(complearn_ncd_top());
  CompLearnCompressorDriver *dri = COMPLEARN_COMPRESSOR_DRIVER(
                                       complearn_compressor_driver_new());
   complearn_compressor_driver_set_compressor(dri, complearn_ncd_get_real_compressor());
  return dri;
}}
#line 1451 "complearn-ncd.c"
#undef __GOB_FUNCTION__

#line 399 "complearn-ncd.gob"
LabeledMatrix * 
complearn_ncd_ncd_matrix (GSList * a, GSList * b)
#line 1457 "complearn-ncd.c"
{
#define __GOB_FUNCTION__ "CompLearn:Ncd::ncd_matrix"
{
#line 400 "complearn-ncd.gob"
	
  CompLearnNcd *ncd = COMPLEARN_NCD(complearn_ncd_top());
  LabeledMatrix *result = calloc(sizeof(*result), 1);
  result->mat = gsl_matrix_calloc(g_slist_length(a), g_slist_length(b));
  result->labels1 = calloc(result->mat->size1 + 1, sizeof(gpointer));
  result->labels2 = calloc(result->mat->size2 + 1, sizeof(gpointer));
  GSList *ita, *itb;
  gsl_vector *singlesizes = gsl_vector_calloc(result->mat->size1+result->mat->size2);
  int i, j, boff=0, k;
  CompLearnCompressorDriver *dr = complearn_ncd_get_compressor_driver();
  for (ita = a; ita; ita=g_slist_next(ita)) {
    complearn_compressor_driver_store(dr, ((CLArgumentEntry *) (ita->data))->block);
    gsl_vector_set(singlesizes, boff,
        complearn_compressor_driver_compress_single(dr, boff));
    result->labels1[boff] = g_strdup(((CLArgumentEntry *) (ita->data))->label);
    boff += 1;
  }
  k = boff;
  for (itb = b; itb; itb=g_slist_next(itb)) {
    complearn_compressor_driver_store(dr, ((CLArgumentEntry *) (itb->data))->block);
      gsl_vector_set(singlesizes, k,
        complearn_compressor_driver_compress_single(dr, k));
    result->labels2[k-boff] = g_strdup(((CLArgumentEntry *) (itb->data))->label);
      k += 1;
  }
  i = 0;

  for (ita = a; ita; ita=g_slist_next(ita)) {
    j = 0;
    for (itb = b; itb; itb=g_slist_next(itb)) {
      double cboth, c;
        cboth = complearn_compressor_driver_compress_pair(dr, j,i+boff);
        if (complearn_ncd_get_just_size(complearn_ncd_top())) {
          c = cboth;
        } else {
          if (ncd->_priv->zero_diagonal && complearn_compressor_driver_is_same_block(dr, j, i+boff))
            c = 0.0;
          else
            c = complearn_ncd_mymndf(cboth, gsl_vector_get(singlesizes,j),
                          gsl_vector_get(singlesizes,i+boff));
          }
        gsl_matrix_set(result->mat, i, j, c);
        j += 1;
    }
    i += 1;
  }
  g_object_unref(dr);
  gsl_vector_free(singlesizes);
  if (complearn_ncd_get_svd_project(complearn_ncd_top())) {
    gsl_matrix *oldmat = result->mat;
    result->mat = complearn_svd_project(result->mat);
    gsl_matrix_free(oldmat);
  }
  if (ncd->_priv->average_matrix && result->mat->size1 == result->mat->size2) {
    gsl_matrix *oldmat = result->mat;
    result->mat = complearn_average_matrix(result->mat);
    gsl_matrix_free(oldmat);
  }
  return result;
}}
#line 1522 "complearn-ncd.c"
#undef __GOB_FUNCTION__

#line 461 "complearn-ncd.gob"
CompLearnRealCompressor * 
complearn_ncd_load_compressor (const char * name)
#line 1528 "complearn-ncd.c"
{
#define __GOB_FUNCTION__ "CompLearn:Ncd::load_compressor"
{
#line 462 "complearn-ncd.gob"
	
  CompLearnNcd *clb = COMPLEARN_NCD(complearn_ncd_top());
  CompLearnRealCompressor *rc = complearn_environment_load_compressor_named( name );
  if (rc == NULL)
    g_error(_("Cannot load compressor %s"),
                   complearn_ncd_get_compressor(clb));
  return rc;
}}
#line 1541 "complearn-ncd.c"
#undef __GOB_FUNCTION__

#line 470 "complearn-ncd.gob"
static CompLearnRealCompressor * 
complearn_ncd_get_real_compressor (void)
#line 1547 "complearn-ncd.c"
{
#define __GOB_FUNCTION__ "CompLearn:Ncd::get_real_compressor"
{
#line 471 "complearn-ncd.gob"
	
  return complearn_ncd_load_compressor(complearn_ncd_get_compressor(complearn_ncd_top()));
}}
#line 1555 "complearn-ncd.c"
#undef __GOB_FUNCTION__
