/*
* Copyright (c) 2006 Rudi Cilibrasi, Rulers of the RHouse
* All rights reserved.     cilibrar@cilibrar.com
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions are met:
*
*     * Redistributions of source code must retain the above copyright
*       notice, this list of conditions and the following disclaimer.
*     * Redistributions in binary form must reproduce the above copyright
*       notice, this list of conditions and the following disclaimer in the
*       documentation and/or other materials provided with the distribution.
*     * Neither the name of the RHouse nor the
*       names of its contributors may be used to endorse or promote products
*       derived from this software without specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE RULERS AND CONTRIBUTORS "AS IS" AND ANY
* EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
* DISCLAIMED. IN NO EVENT SHALL THE RULERS AND CONTRIBUTORS BE LIABLE FOR ANY
* DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
* LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
* ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
* (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
* SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#ifndef __DMLABELS_H
#define __DMLABELS_H

/*! \file labelmaker.h */

/** \brief Returns StringStack of distance matrix labels from CompLearn binary
 *
 *  clbLabels() is a high level function which reads a CompLearn
 *  binary(clb) file, generated by the ncd -b command and returns a StringStack
 *  of labels for the distance matrix saved in the clb file.
 *  \param db contents of a CompLearn binary file
 *  \return StringStack of distance matrix labels
 */
struct StringStack *clbDBLabels(struct DataBlock *db);

struct DataBlock *clbLabelsDataBlock(char *fname);

/** \brief Returns StringStack of distance matrix labels from a ASCII text file
 *
 *  clTxtLabels() is a high level function which reads a text file,
 *  formatted in the same way as output from the ncd command, and returns a
 *  StringStack of labels for the distance matrix.
 *  \param fname path to text file
 *  \return StringStack of distance matrix labels
 */
struct StringStack *clTxtLabels(char *fname);

#endif
