#include "node.h"
#include <glib.h>
#include "cm-marshal.h"

G_DEFINE_TYPE (CmNode, cm_node, G_TYPE_OBJECT);

enum
{
    NEED_REPAINT,
    N_SIGNALS
};

static guint signals[N_SIGNALS];

static void
cm_node_finalize (GObject *object)
{
    G_OBJECT_CLASS (cm_node_parent_class)->finalize (object);
}

static void
cm_node_class_init (CmNodeClass *class)
{
    GObjectClass *object_class = G_OBJECT_CLASS (class);
    object_class->finalize = cm_node_finalize;

    signals[NEED_REPAINT] = g_signal_new ("need_repaint",
					  G_OBJECT_CLASS_TYPE (object_class),
					  G_SIGNAL_RUN_LAST,
					  0,
					  NULL, NULL,
					  cm_marshal_VOID__VOID,
					  G_TYPE_NONE, 0);
}

static void
cm_node_init (CmNode *node)
{

}

void
cm_node_queue_repaint (CmNode *node)
{
    CmNode *toplevel;

    toplevel = node;
    while (toplevel->parent)
	toplevel = toplevel->parent;

    g_signal_emit (node, signals[NEED_REPAINT], 0);
}

gdouble
cm_node_get_time (CmNode *node)
{
    static GTimer *timer;

    if (!timer)
	timer = g_timer_new ();

    return g_timer_elapsed (timer, NULL);
}

void
cm_node_render (CmNode *node)
{
    g_return_if_fail (CM_IS_NODE (node));

    CM_NODE_GET_CLASS (node)->render (node);
}

static void
cm_node_set_parent (CmNode *node,
		    CmNode *parent)
{
    if (node->parent)
    {
	g_object_remove_weak_pointer (G_OBJECT (node->parent),
				      (gpointer *)&(node->parent));
    }

    node->parent = parent;

    if (node->parent)
    {
	g_object_add_weak_pointer (G_OBJECT (node->parent),
				   (gpointer *)&(node->parent));
    }
}

void
cm_node_disown_child (CmNode *node,
		      CmNode **child_location)
{
    g_return_if_fail (CM_IS_NODE (node));
    g_return_if_fail (child_location != NULL);
    g_return_if_fail (*child_location == NULL || CM_IS_NODE (*child_location));
    
    if (*child_location)
    {
	cm_node_set_parent (*child_location, NULL);
	g_object_unref (*child_location);
    }

    cm_node_queue_repaint (node);
}

void
cm_node_own_child (CmNode *node,
		   CmNode **child_location,
		   CmNode *child)
{
    g_return_if_fail (CM_IS_NODE (node));
    g_return_if_fail (child == NULL || CM_IS_NODE (child));
    g_return_if_fail (child_location != NULL);
    g_return_if_fail (child->parent == NULL);

    if (*child_location == child)
	return;

    cm_node_disown_child (node, child_location);
    
    *child_location = child;

    if (*child_location)
    {
	cm_node_set_parent (*child_location, node);
	g_object_ref (*child_location);
    }

    cm_node_queue_repaint (node);
}
