#include <math.h>
#include "drawable-node.h"

void
cm_identity_deform (int u, int v,
		    int x, int y, int width, int height,
		    int *deformed_x, int *deformed_y,
		    void *p)
{
    *deformed_x = x + u;
    *deformed_y = y + v;
}

void
cm_user_geometry_deform (int u, int v,
			 int x, int y, int width, int height,
			 int *deformed_x, int *deformed_y,
			 void *p)
{
    CmDrawableNode *node = p;
    
    *deformed_x = node->user_x + node->user_width * u / width;
    *deformed_y = node->user_y + node->user_height * v / height;
}

void
cm_wavy_deform (int u, int v,
		int x, int y, int width, int height,
		int *deformed_x, int *deformed_y,
		void *p)
{
    *deformed_x = x + u + cos((x * 4 + u + y * 4 + v) / 64.0) * 8;
    *deformed_y = y + v + sin((x * 4 + u + y * 4 + v) / 64.0) * 8;
}

void
cm_patch_deform (int u_in, int v_in,
		 int x, int y, int w, int h,
		 int *deformed_x, int *deformed_y,
		 void *p)
{
    CmDrawableNode *node = p;
    double coeffs_u[4], coeffs_v[4];
    double patch_x, patch_y;
    double u, v;
    int i, j;
    
    u = (double) u_in / w;
    v = (double) v_in / h;
    
    coeffs_u[0] = (1 - u) * (1 - u) * (1 - u);
    coeffs_u[1] = 3 * u * (1 - u) * (1 - u);
    coeffs_u[2] = 3 * u * u * (1 - u);
    coeffs_u[3] = u * u * u;
    
    coeffs_v[0] = (1 - v) * (1 - v) * (1 - v);
    coeffs_v[1] = 3 * v * (1 - v) * (1 - v);
    coeffs_v[2] = 3 * v * v * (1 - v);
    coeffs_v[3] = v * v * v;
    
    patch_x = 0;
    patch_y = 0;
    
    for (i = 0; i < 4; i++)
    {
	for (j = 0; j < 4; j++)
	{
	    patch_x += coeffs_u[i] * coeffs_v[j] * node->patch_points[j][i].x;
	    patch_y += coeffs_u[i] * coeffs_v[j] * node->patch_points[j][i].y;
	}
    }
    
    *deformed_x = patch_x + 0.5;
    *deformed_y = patch_y + 0.5;
}
