/*
 * Test TDBDiskIndex
 *
 * Copyright (C) 2005  Enrico Zini <enrico@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <test-utils.h>
#include <buffy/Config.h>
#include <buffy/stringf.h>
#include <buffy/MailboxMailFolder.h>
#include <unistd.h>

namespace tut {
	struct config_test {
		config_test() {
			//fprintf(stderr, "Start\n");
			//unlink("test.tdb");
		}
		~config_test() {
			//fprintf(stderr, "End\n");
			//unlink("test.tdb");
		}
	};
	typedef test_group<config_test> tg;
	typedef tg::object to;
	tg config_tg ("Config");

	template<> template<>
	void to::test<1> ()
	{
		try {
			// An empty database should return empty sets, but not fail
			Config conf("test-config.txt");
			gen_ensure(!conf.get_view_read());
			gen_ensure(!conf.get_view_empty());
			gen_ensure(conf.get_view_important());
			gen_ensure(conf.get_update_interval() == 600);

			vector<string> locations = conf.get_folder_locations();
			gen_ensure(locations.size() == 4);
			/*
			gen_ensure(locations.find("/var/mail/enrico") != locations.end());
			gen_ensure(locations.find("/home/enrico/Maildir") != locations.end());
			gen_ensure(locations.find("/home/enrico/Mail") != locations.end());
			gen_ensure(locations.find("/home/enrico/mail") != locations.end());
			*/

			vector<MailProgram> programs = conf.get_mail_programs();
			gen_ensure(programs.size() == 2);

			string test = fmt(getpid());
			conf.set_application_data("test", "pid", test);
			gen_ensure(conf.get_application_data("test", "pid") == test);
			gen_ensure(conf.get_application_data("pippo", "pluto") == "");

			MailFolder empty(new MailboxMailFolder("mbox/empty.mbox"));
			conf.set_folder_data(empty, "cippo", "lippo");

			conf.save("test-config-saved.txt");
		} catch (Exception& e) {
			fprintf(stderr, "%s: %.*s\n", e.type(), PFSTR(e.desc()));
			throw;
		}
	}

	template<> template<>
	void to::test<2> ()
	{
		try {
			// An empty database should return empty sets, but not fail
			Config conf("test-config-saved.txt");

			string test = fmt(getpid());
			gen_ensure(conf.get_application_data("test", "pid") == test);
			gen_ensure(conf.get_application_data("pippo", "pluto") == "");

			MailFolder empty(new MailboxMailFolder("mbox/empty.mbox"));
			gen_ensure(conf.get_folder_data(empty, "cippo") == "lippo");
		} catch (Exception& e) {
			fprintf(stderr, "%s: %.*s\n", e.type(), PFSTR(e.desc()));
			throw;
		}
	}
}

// vim:set ts=4 sw=4:
