// -*- c++ -*-
// Generated by assa-genesis
//------------------------------------------------------------------------------
// $Id: LogServer.cpp,v 1.6 2005/10/08 02:42:01 vlg Exp $
//------------------------------------------------------------------------------
//                            LogServer.cpp
//------------------------------------------------------------------------------
//  Copyright (c) 2003 by Vladislav Grinchenko
//
//  This program is free software; you can redistribute it and/or 
//  modify it under the terms of the GNU General Public License   
//  as published by the Free Software Foundation; either version  
//  2 of the License, or (at your option) any later version.      
//------------------------------------------------------------------------------
//
// Date   : Thu Apr 17 17:31:20 2003
//
//------------------------------------------------------------------------------

#include <assa/INETAddress.h>

#include "LogServer-main.h"
using ASSA::ERROR;

#include "LogServer.h"
#include "Conn.h"
#include "MonitorConn.h"


// Static declarations mandated by Singleton class
ASSA_DECL_SINGLETON(LogServer);

LogServer::
LogServer () : 
	m_acceptor (NULL),
	m_monitor_acceptor (NULL),
	m_recycle (false)
{
	rm_opt ('c', "log-level");
	rm_opt ('s', "with-log-server");
	rm_opt ('S', "log-server");

	if (!add_opt (0, "log-dir", &m_log_dir)) {
		std::cerr << "Error : \"" << get_opt_error () << "\"\n";
		exit (1);
	}
	add_flag_opt (0, "recycle", &m_recycle);

    /*---
     * By defauil disable all debugging
     *---*/
    m_mask = ASSA::APP | ASSA::ERROR;
    m_log_file = "LogServer.log";
}

void
LogServer::
init_service ()
{
    trace("LogServer::init_service");

	m_acceptor = new ASSA::Acceptor<Conn, ASSA::IPv4Socket> (get_reactor ());

	ASSA::INETAddress lport ("assalogd");
	Assure_exit (!lport.bad ());
	Assure_exit (m_acceptor->open (lport) == 0);

	m_monitor_acceptor = 
		new ASSA::Acceptor<MonitorConn, ASSA::IPv4Socket> (get_reactor ());
	
	ASSA::INETAddress lmport ("assalmon");
	Assure_exit (!lmport.bad ());
	Assure_exit (m_monitor_acceptor->open (lmport) == 0);
	
    DL((ASSA::APP,"Service has been initialized\n"));
}

void
LogServer::
process_events ()
{
    trace("LogServer::process_events");

    while (service_is_active ()) {
        m_reactor.waitForEvents ();
    }

    // Shut the service down
    m_reactor.stopReactor ();
    DL((ASSA::APP,"Service stopped!\n"));
}


