/***************************************************************************
 $RCSfile: pintan_p.h,v $
                             -------------------
    cvs         : $Id: pintan_p.h,v 1.2 2005/01/30 13:04:31 aquamaniac Exp $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/

#ifndef AH_MEDIUM_PINTAN_P_H
#define AH_MEDIUM_PINTAN_P_H


#include "pintan.h"
#include <gwenhywfar/misc.h>
#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>


#define AH_MEDIUM_PINTAN_VMAJOR 1
#define AH_MEDIUM_PINTAN_VMINOR 0

#define AH_MEDIUM_PINTAN_NAME "PinTan"
#define AH_MEDIUM_PINTAN_PINMINLENGTH 4



typedef struct AH_MEDIUM_PINTAN AH_MEDIUM_PINTAN;
struct AH_MEDIUM_PINTAN {
  int country;
  char *bankId;
  char *userId;
  char *systemId;

  unsigned int localSignSeq;
  unsigned int remoteSignSeq;

  int selected;
};


void AH_Medium_PinTan_FreeData(void *bp, void *p);

int AH_Medium_PinTan_Mount(AH_MEDIUM *m);
int AH_Medium_PinTan_Create(AH_MEDIUM *m);
int AH_Medium_PinTan_Unmount(AH_MEDIUM *m, int force);
AH_MEDIUM_RESULT AH_Medium_PinTan_Sign(AH_MEDIUM *m,
                                      GWEN_BUFFER *msgbuf,
                                      GWEN_BUFFER *signbuf);
int AH_Medium_PinTan_GetNextSignSeq(AH_MEDIUM *m);
int AH_Medium_PinTan_SetLocalSignSeq(AH_MEDIUM *m, int i);
AH_MEDIUM_RESULT AH_Medium_PinTan_Verify(AH_MEDIUM *m,
                                        GWEN_BUFFER *msgbuf,
                                        GWEN_BUFFER *signbuf,
                                        int signseq);
AH_MEDIUM_RESULT AH_Medium_PinTan_EncryptKey(AH_MEDIUM *m,
                                            GWEN_BUFFER *srckey,
                                            GWEN_BUFFER *encKey);
AH_MEDIUM_RESULT AH_Medium_PinTan_DecryptKey(AH_MEDIUM *m,
                                            GWEN_BUFFER *srckey,
                                            GWEN_BUFFER *deckey);
int AH_Medium_PinTan_ChangePin(AH_MEDIUM *m);
int AH_Medium_PinTan_SelectContext(AH_MEDIUM *m, int idx);
int AH_Medium_PinTan_CreateContext(AH_MEDIUM *m,
                                   int country,
                                   const char *bankId,
                                   const char *userId);

int AH_Medium_PinTan_RemoveContext(AH_MEDIUM *m, int idx);

int AH_Medium_PinTan_ReadContext(AH_MEDIUM *m,
                                 int idx,
                                 int *country,
                                 GWEN_BUFFER *bankId,
                                 GWEN_BUFFER *userId,
                                 GWEN_BUFFER *server,
                                 int *port);

int AH_Medium_PinTan_WriteContext(AH_MEDIUM *m,
                                  int idx,
                                  int country,
                                  const char *bankId,
                                  const char *userId,
                                  const char *server,
                                  int port);



GWEN_BUFFER *AH_Medium_PinTan_GenerateMsgKey(AH_MEDIUM *m);


int AH_Medium_PinTan_GetPin(AH_MEDIUM *m,
                           char *buffer,
                           int minsize,
                           int maxSize,
                           int crea);
int AH_Medium_PinTan_GetTan(AH_MEDIUM *m,
                           char *buffer,
                           int minsize,
                           int maxSize);

int AH_Medium_PinTan_SetTanStatus(AH_MEDIUM *m,
                                  const char *buffer,
                                  AH_MEDIUMPINTAN_TANSTATUS tst);

int AH_Medium_PinTan_toDb(const AH_MEDIUM *m, GWEN_DB_NODE *db);
int AH_Medium_PinTan_fromDb(AH_MEDIUM *m, GWEN_DB_NODE *db);





AH_MEDIUM *AH_Medium_PinTanProvider_Factory(AH_MEDIUMPROVIDER *mp,
                                           AH_HBCI *hbci,
                                           const char *mediumName);
AH_MEDIUM_CHECKRESULT
  AH_Medium_PinTanProvider_Check(AH_MEDIUMPROVIDER *mp,
                                AH_HBCI *hbci,
                                GWEN_BUFFER *mediumName);

















#endif /* AH_MEDIUM_PINTAN_P_H */


