/***************************************************************************
 $RCSfile: ohbci_p.h,v $
                             -------------------
    cvs         : $Id: ohbci_p.h,v 1.8 2005/03/28 20:21:31 aquamaniac Exp $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/



#ifndef AH_MEDIUM_OHBCI_P_H
#define AH_MEDIUM_OHBCI_P_H


#define AH_MEDIUM_OHBCI_NAME         "OHBCI"
#define AH_MEDIUM_OHBCI_VMAJOR       1
#define AH_MEDIUM_OHBCI_VMINOR       5

#define AH_MEDIUM_OHBCI_KEYLEN       768
#define AH_MEDIUM_OHBCI_PINMINLENGTH 4 /* temporary, should be 5 or more */

#define AH_MEDIUM_OHBCI_MAX_PIN_TRY 10

#define AH_MEDIUM_OHBCI_TAG_CRYPT_OLD          (unsigned char)0xc1
#define AH_MEDIUM_OHBCI_TAG_CRYPT              (unsigned char)0xc2


#define AH_MEDIUM_OHBCI_TAG_VERSION_MAJOR      (unsigned char)0x02
#define AH_MEDIUM_OHBCI_TAG_VERSION_MINOR      (unsigned char)0x03
#define AH_MEDIUM_OHBCI_TAG_SEQ                (unsigned char)0x04

#define AH_MEDIUM_OHBCI_TAG_USER_PUBSIGNKEY    (unsigned char)0xc5
#define AH_MEDIUM_OHBCI_TAG_USER_PRIVSIGNKEY   (unsigned char)0xc6
#define AH_MEDIUM_OHBCI_TAG_USER_PUBCRYPTKEY   (unsigned char)0xc7
#define AH_MEDIUM_OHBCI_TAG_USER_PRIVCRYPTKEY  (unsigned char)0xc8
#define AH_MEDIUM_OHBCI_TAG_USER_ID            (unsigned char)0x09

#define AH_MEDIUM_OHBCI_TAG_INST_PUBSIGNKEY    (unsigned char)0xca
#define AH_MEDIUM_OHBCI_TAG_INST_PUBCRYPTKEY   (unsigned char)0xcb
#define AH_MEDIUM_OHBCI_TAG_INST_COUNTRY       (unsigned char)0x0c
#define AH_MEDIUM_OHBCI_TAG_INST_CODE          (unsigned char)0x0d
#define AH_MEDIUM_OHBCI_TAG_INST_SYSTEMID      (unsigned char)0x0e

/* temporary keys (new in version 1.1) */
#define AH_MEDIUM_OHBCI_TAG_TEMP_PUBSIGNKEY    (unsigned char)0xcf
#define AH_MEDIUM_OHBCI_TAG_TEMP_PRIVSIGNKEY   (unsigned char)0xd0
#define AH_MEDIUM_OHBCI_TAG_TEMP_PUBCRYPTKEY   (unsigned char)0xd1
#define AH_MEDIUM_OHBCI_TAG_TEMP_PRIVCRYPTKEY  (unsigned char)0xd2

/* new in version 1.4 */
#define AH_MEDIUM_OHBCI_TAG_SERVER_ADDR        (unsigned char)0xd3
#define AH_MEDIUM_OHBCI_TAG_SERVER_PORT        (unsigned char)0xd4
#define AH_MEDIUM_OHBCI_TAG_REMOTE_SEQ         (unsigned char)0xd5

/* keydata */
#define AH_MEDIUM_OHBCI_TAG_KEY_ISPUBLIC      (unsigned char) 0x01
#define AH_MEDIUM_OHBCI_TAG_KEY_ISCRYPT       (unsigned char) 0x02
/* fixed in 1.5: fixes a bug in old OpenHBCI which included escape chars */
#define AH_MEDIUM_OHBCI_TAG_KEY_OWNER         (unsigned char) 0x03
#define AH_MEDIUM_OHBCI_TAG_KEY_VERSION       (unsigned char) 0x04
#define AH_MEDIUM_OHBCI_TAG_KEY_NUMBER        (unsigned char) 0x05
#define AH_MEDIUM_OHBCI_TAG_KEY_MODULUS       (unsigned char) 0x06
#define AH_MEDIUM_OHBCI_TAG_KEY_EXP_OLD       (unsigned char) 0x07
#define AH_MEDIUM_OHBCI_TAG_KEY_N             (unsigned char) 0x08
#define AH_MEDIUM_OHBCI_TAG_KEY_P             (unsigned char) 0x09
#define AH_MEDIUM_OHBCI_TAG_KEY_Q             (unsigned char) 0x0a
#define AH_MEDIUM_OHBCI_TAG_KEY_DMP1          (unsigned char) 0x0b
#define AH_MEDIUM_OHBCI_TAG_KEY_DMQ1          (unsigned char) 0x0c
#define AH_MEDIUM_OHBCI_TAG_KEY_IQMP          (unsigned char) 0x0d
#define AH_MEDIUM_OHBCI_TAG_KEY_D             (unsigned char) 0x0e
/* new in version 1.3 */
#define AH_MEDIUM_OHBCI_TAG_KEY_EXP           (unsigned char) 0x0f




#include "ohbci.h"
#include "tlv.h"
#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>


typedef struct AH_MEDIUM_OHBCI AH_MEDIUM_OHBCI;
struct AH_MEDIUM_OHBCI {
  unsigned int cryptoTag;

  char password[16];
  int passWordIsSet;

  int country;
  char *userId;
  char *bankId;
  char *systemId;

  int selected;

  unsigned int localSignSeq;
  unsigned int remoteSignSeq;

  GWEN_CRYPTKEY *localSignKey;
  GWEN_CRYPTKEY *localCryptKey;

  GWEN_CRYPTKEY *remoteSignKey;
  GWEN_CRYPTKEY *remoteCryptKey;

  GWEN_CRYPTKEY *localSignKeyBak;
  GWEN_CRYPTKEY *localCryptKeyBak;

  time_t ctime;
  time_t mtime;

  /* Remember and restore the access permissions to the key file. */
  mode_t keyfile_mode;

};


int AH_MediumOHBCI__ReloadIfNeeded(AH_MEDIUM *m, int fd);





int AH_MediumOHBCI_GetNextSignSeq(AH_MEDIUM *m);
int AH_MediumOHBCI_SetLocalSignSeq(AH_MEDIUM *m, int i);

int AH_MediumOHBCI_Mount(AH_MEDIUM *m);
int AH_MediumOHBCI_Create(AH_MEDIUM *m);
int AH_MediumOHBCI_Unmount(AH_MEDIUM *m, int force);

AH_MEDIUM_RESULT AH_MediumOHBCI_Sign(AH_MEDIUM *m,
                                     GWEN_BUFFER *msgbuf,
                                     GWEN_BUFFER *signbuf);
int AH_MediumOHBCI_GetNextSignSeq(AH_MEDIUM *m);
AH_MEDIUM_RESULT AH_MediumOHBCI_Decrypt(AH_MEDIUM *m,
                                        GWEN_BUFFER *msgbuf,
                                        GWEN_BUFFER *decryptbuf,
                                        GWEN_BUFFER *msgKeyBuffer);
AH_MEDIUM_RESULT AH_MediumOHBCI_Verify(AH_MEDIUM *m,
                                       GWEN_BUFFER *msgbuf,
                                       GWEN_BUFFER *signbuf,
                                       int signseq);
AH_MEDIUM_RESULT AH_MediumOHBCI_Encrypt(AH_MEDIUM *m,
                                        GWEN_BUFFER *msgbuf,
                                        GWEN_BUFFER *encryptbuf,
                                        GWEN_BUFFER *msgKeyBuffer);

int AH_MediumOHBCI_SelectContext(AH_MEDIUM *m, int idx);

int AH_MediumOHBCI_CreateContext(AH_MEDIUM *m,
                                 int country,
                                 const char *bankId,
                                 const char *userId);

int AH_MediumOHBCI_RemoveContext(AH_MEDIUM *m, int idx);

int AH_MediumOHBCI_ReadContext(AH_MEDIUM *m,
                               int idx,
                               int *country,
                               GWEN_BUFFER *bankId,
                               GWEN_BUFFER *userId,
                               GWEN_BUFFER *server,
                               int *port);

int AH_MediumOHBCI_WriteContext(AH_MEDIUM *m,
                                int idx,
                                int country,
                                const char *bankId,
                                const char *userId,
                                const char *server,
                                int port);



void AH_MediumOHBCI_FreeData(void *bp, void *p);


GWEN_BUFFER *AH_MediumOHBCI_GenerateMsgKey(AH_MEDIUM *m);
AH_MEDIUM_RESULT AH_MediumOHBCI_EncryptKey(AH_MEDIUM *m,
                                           GWEN_BUFFER *srckey,
                                           GWEN_BUFFER *encKey);
AH_MEDIUM_RESULT AH_MediumOHBCI_DecryptKey(AH_MEDIUM *m,
                                           GWEN_BUFFER *srckey,
                                           GWEN_BUFFER *encKey);



GWEN_CRYPTKEY *AH_MediumOHBCI_GetLocalPubSignKey(AH_MEDIUM *m);
GWEN_CRYPTKEY *AH_MediumOHBCI_GetLocalPubCryptKey(AH_MEDIUM *m);

GWEN_CRYPTKEY *AH_MediumOHBCI_GetPubSignKey(AH_MEDIUM *m);
int AH_MediumOHBCI_SetPubSignKey(AH_MEDIUM *m,
                                 const GWEN_CRYPTKEY *key);
GWEN_CRYPTKEY *AH_MediumOHBCI_GetPubCryptKey(AH_MEDIUM *m);
int AH_MediumOHBCI_SetPubCryptKey(AH_MEDIUM *m,
                                  const GWEN_CRYPTKEY *key);
int AH_MediumOHBCI_CreateKeys(AH_MEDIUM *m);
int AH_MediumOHBCI_ActivateKeys(AH_MEDIUM *m);

GWEN_CRYPTKEY *AH_MediumOHBCI_GetLocalTmpSignKey(AH_MEDIUM *m);
GWEN_CRYPTKEY *AH_MediumOHBCI_GetLocalTmpCryptKey(AH_MEDIUM *m);



int AH_MediumOHBCI__Decode(AH_MEDIUM *m, GWEN_BUFFER *dbuf);
void AH_MediumOHBCI__DecodeKey(AH_MEDIUM *m,
                               OHBCI_TLV *keyTlv,
                               GWEN_DB_NODE *dbKeys,
                               const char *keyName);


int AH_MediumOHBCI__OpenFile(AH_MEDIUM *m, int wr);
int AH_MediumOHBCI__ReadFile(AH_MEDIUM *m, int fd);
int AH_MediumOHBCI__WriteFile(AH_MEDIUM *m, int fd);
int AH_MediumOHBCI__CloseFile(AH_MEDIUM *m, int fd);


int AH_MediumOHBCI__EncodeKey(const GWEN_CRYPTKEY *key,
                              unsigned int tagType,
                              int wantPublic,
                              int isCrypt,
                              GWEN_BUFFER *dbuf);
int AH_MediumOHBCI_Encode(AH_MEDIUM *m, GWEN_BUFFER *dbuf);


int AH_MediumOHBCI__DecryptFile(AH_MEDIUM *m, GWEN_BUFFER *fbuf, int trynum);



AH_MEDIUMPROVIDER *ohbci_MediumProvider_new(AH_HBCI *hbci);
AH_MEDIUM *AH_MediumOHBCIProvider_Factory(AH_MEDIUMPROVIDER *mp,
                                          AH_HBCI *hbci,
                                          const char *mediumName);
AH_MEDIUM_CHECKRESULT AH_MediumOHBCIProvider_Check(AH_MEDIUMPROVIDER *mp,
                                                   AH_HBCI *hbci,
                                                   GWEN_BUFFER *mediumName);




#endif /* AH_MEDIUM_OHBCI_P_H */



