/***************************************************************************
 $RCSfile: mediumpintan.h,v $
                             -------------------
    cvs         : $Id: mediumpintan.h,v 1.4 2004/09/09 04:20:19 aquamaniac Exp $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/


#ifndef AH_MEDIUMPINTAN_H
#define AH_MEDIUMPINTAN_H

#include <aqhbci/medium.h>
#include <gwenhywfar/buffer.h>
#include <gwenhywfar/crypt.h>
#include <gwenhywfar/keyspec.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef enum {
  AH_MediumPINTAN_StatusUnknown=0,
  AH_MediumPINTAN_StatusUsed,
  AH_MediumPINTAN_StatusUnused,
  AH_MediumPINTAN_StatusDel,
  AH_MediumPINTAN_StatusAdd
} AH_MEDIUMPINTAN_TANSTATUS;


/** @defgroup AQHBCI_MOD_HBCI_MEDIUM_PINTAN HBCI PIN/TAN Medium
 * @ingroup AQHBCI_MOD_HBCI_MEDIUM
 * @short Security Medium For HBCI in PIN/TAN Mode
 * @author Martin Preuss<martin@libchipcard.de>
 *
 */
/*@{*/

/** @name Prototypes For Virtual Functions
 *
 */
/*@{*/

typedef int (*AH_MEDIUMPINTAN_GETPINFN)(AH_MEDIUM *m,
                                        char *buffer,
                                        int minsize,
                                        int maxSize,
                                        int crea);
typedef int (*AH_MEDIUMPINTAN_GETTANFN)(AH_MEDIUM *m,
                                        char *buffer,
                                        int minsize,
                                        int maxSize);
typedef int (*AH_MEDIUMPINTAN_SETTANSTATUSFN)(AH_MEDIUM *m,
                                              const char *buffer,
                                              AH_MEDIUMPINTAN_TANSTATUS tst);

/*@}*/




/** @name Constructor And Destructor
 *
 */
/*@{*/
AH_MEDIUM *AH_MediumPINTAN_new(AH_HBCI *hbci,
                               const char *mtn,
                               const char *mediumName);

/*@}*/


/** @name Virtual Functions
 *
 */
/*@{*/

int AH_MediumPINTAN_GetPin(AH_MEDIUM *m,
                           char *buffer,
                           int minsize,
                           int maxSize,
                           int crea);
int AH_MediumPINTAN_GetTan(AH_MEDIUM *m,
                           char *buffer,
                           int minsize,
                           int maxSize);

int AH_MediumPINTAN_SetTanStatus(AH_MEDIUM *m,
                                 const char *buffer,
                                 AH_MEDIUMPINTAN_TANSTATUS tst);

/*@}*/



/** @name Setters For Virtual Functions
 *
 */
/*@{*/

void AH_MediumPINTAN_SetGetPinFn(AH_MEDIUM *m, AH_MEDIUMPINTAN_GETPINFN f);
void AH_MediumPINTAN_SetGetTanFn(AH_MEDIUM *m, AH_MEDIUMPINTAN_GETTANFN f);
void AH_MediumPINTAN_SetSetTanStatusFn(AH_MEDIUM *m,
                                       AH_MEDIUMPINTAN_SETTANSTATUSFN f);

/*@}*/

/*@}*/ /* defgroup */

#ifdef __cplusplus
}
#endif


#endif /* AH_MEDIUMPINTAN_H */


