with Ada.Numerics.Discrete_Random,
     Search,
     Ada.Text_Io;
use  Ada.Text_Io;
procedure TestSearch is

   subtype Test_Character is Character range 'A' .. 'Z';

   package Rand is new Ada.Numerics.Discrete_Random (Test_Character);

   Text_Length : constant := 100000;
   Text : String (1 .. Text_Length);

   Pattern : String (1 .. 1024);
   Pattern_L : Natural;

   Gen       : Rand.Generator;

begin
   Put_Line ("Generate Random Text");
   Rand.Reset (Gen);
   for I in Text'Range loop
      Text (I) := Rand.Random (Gen);
   end loop;
   Put ("What Text should be looked for (only capital letters)? ");
   Get_Line (Pattern, Pattern_L);
   Put_Line ("Searching for """ & Pattern (1 .. Pattern_L) & """ in random Text");

--   Put_Line ("----->");
--   Put_Line (Text);
--   Put_Line ("<-----");
   declare
      Data  : Search.Search_Data := Search.Init_Search (Pattern (1 .. Pattern_L));
      Found : Natural;
      Start : Natural := Text'First;
   begin
      loop
         Found := Search.Quick_Search (Data, Text, Start);
         Put_Line ("found at Pos. " & Integer'Image (Found) & ": """ &
                   Text (Found .. Found + Pattern_L - 1) & """");
         Start := Found + Pattern_L;
      end loop;
   exception
      when Search.Not_Found_Error =>
         Put_Line ("not more occurences of """ & Pattern (1 .. Pattern_L) &
                   """ found");
   end;
   
end TestSearch;
