/***************************************************************************
 *   Copyright (C) 1998-2008 by authors (see AUTHORS.txt )                 *
 *                                                                         *
 *   This file is part of LuxRender.                                       *
 *                                                                         *
 *   Lux Renderer is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   Lux Renderer is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>. *
 *                                                                         *
 *   This project is based on PBRT ; see http://www.pbrt.org               *
 *   Lux Renderer website : http://www.luxrender.net                       *
 ***************************************************************************/

static unsigned char lux_icon_bitmap[]={
255,255,255,255,
255,255,255,255,
255,159,255,255,
255,15,255,255,
255,15,255,255,
255,159,255,255,
255,255,255,255,
255,255,195,255,
255,255,129,255,
63,254,129,255,
63,254,129,255,
63,255,1,240,
255,255,3,224,
255,255,31,192,
255,159,31,128,
249,15,31,128,
249,15,31,128,
255,159,31,128,
255,255,31,192,
255,255,3,224,
63,255,1,240,
63,254,129,255,
63,254,129,255,
255,255,129,255,
255,255,195,255,
255,255,255,255,
255,159,255,255,
255,15,255,255,
255,15,255,255,
255,159,255,255,
255,255,255,255,
255,255,255,255};

static unsigned char lux_icon_mask[]={
0,0,0,0,
0,0,0,0,
0,96,0,0,
0,240,0,0,
0,240,0,0,
0,96,0,0,
0,0,0,0,
0,0,60,0,
0,0,126,0,
192,1,126,0,
192,1,126,0,
192,0,254,15,
0,0,252,31,
0,0,224,63,
0,96,224,127,
6,240,224,127,
6,240,224,127,
0,96,224,127,
0,0,224,63,
0,0,252,31,
192,0,254,15,
192,1,126,0,
192,1,126,0,
0,0,126,0,
0,0,60,0,
0,0,0,0,
0,96,0,0,
0,240,0,0,
0,240,0,0,
0,96,0,0,
0,0,0,0,
0,0,0,0};

static unsigned char idata_test[] =
{212,208,200,212,208,200,212,208,200,199,195,187,103,101,97,54,53,51,15,15,
14,16,16,15,57,56,54,105,103,99,200,197,189,212,208,200,212,208,200,212,208,
200,212,208,200,212,208,200,153,150,144,25,25,24,149,149,149,212,212,212,235,
235,235,229,229,229,192,192,192,126,126,126,27,26,26,157,154,148,212,208,200,
212,208,200,212,208,200,151,148,143,49,49,48,226,226,226,224,224,224,191,191,
191,220,220,220,223,223,223,198,198,198,216,216,216,189,189,189,32,32,32,157,
154,148,212,208,200,197,193,186,23,23,22,224,224,224,203,203,203,165,165,165,
210,210,210,79,79,79,82,82,82,218,218,218,196,196,196,213,213,213,180,180,180,
27,26,26,200,197,189,102,101,97,145,145,145,226,226,226,166,166,166,172,172,
172,197,197,197,162,162,162,157,157,157,216,216,216,203,203,203,209,209,209,223,
223,223,98,98,97,110,108,104,51,50,49,207,207,207,187,187,187,172,172,172,178,
178,178,192,192,192,231,231,231,232,232,232,207,207,207,210,210,210,216,216,216,
223,223,223,164,164,164,64,63,61,11,11,11,231,231,231,178,178,178,179,179,179,
185,185,185,221,221,221,76,76,76,79,79,79,229,229,229,217,217,217,223,223,223,
229,229,229,206,206,206,18,18,18,11,11,11,226,226,226,184,184,184,185,185,185,
192,192,192,226,226,226,63,63,63,63,63,63,236,236,236,223,223,223,230,230,230,
236,236,236,212,212,212,18,18,18,52,51,50,191,191,191,198,198,198,192,192,192,
199,199,199,230,230,230,63,63,63,63,63,63,239,239,239,230,230,230,236,236,236,
243,243,243,171,171,171,64,63,61,101,99,96,124,124,124,218,218,218,199,199,199,
205,205,205,233,233,233,63,63,63,63,63,63,242,242,242,237,237,237,243,243,243,
249,249,249,100,100,100,109,107,103,197,193,186,23,22,22,190,190,190,215,215,
215,212,212,212,233,233,233,85,85,85,81,81,81,245,245,245,243,243,243,250,250,
250,193,193,193,27,26,26,200,197,189,212,208,200,148,145,140,36,36,35,187,187,
187,225,225,225,227,227,227,239,239,239,239,239,239,244,244,244,250,250,250,195,
195,195,29,29,28,154,151,145,212,208,200,212,208,200,212,208,200,146,144,138,21,
21,20,107,107,107,172,172,172,216,216,216,221,221,221,179,179,179,104,104,104,
24,24,23,151,148,143,212,208,200,212,208,200,212,208,200,212,208,200,212,208,
200,195,192,184,101,99,96,54,54,52,11,11,11,13,13,13,58,57,55,105,103,99,197,
193,186,212,208,200,212,208,200,212,208,200};
static Fl_RGB_Image image_test(idata_test, 14, 14, 3, 0);

static unsigned char idata_clock[] =
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,4,4,4,134,11,11,11,200,6,6,6,244,6,6,6,
243,13,13,13,198,4,4,4,131,0,0,0,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,71,11,11,11,236,151,151,151,251,214,214,214,255,237,237,237,255,231,231,231,
255,196,196,196,255,126,126,126,249,11,11,11,234,0,0,0,66,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,73,43,43,43,245,230,230,230,255,228,228,228,255,194,194,194,255,186,
186,186,255,191,191,191,255,204,204,204,255,222,222,222,255,193,193,193,255,26,
26,26,245,0,0,0,66,0,0,0,0,0,0,0,18,10,10,10,237,229,229,229,255,109,109,109,
255,158,158,158,255,186,186,186,255,188,188,188,255,194,194,194,255,199,199,199,
255,205,205,205,255,219,219,219,255,185,185,185,255,10,10,10,234,0,0,0,14,6,6,6,
135,147,147,147,252,231,231,231,255,141,141,141,255,6,6,6,255,176,176,176,255,
194,194,194,255,202,202,202,255,213,167,130,255,217,179,148,255,216,216,216,255,
227,227,227,255,96,96,96,249,6,6,6,126,12,12,12,204,210,210,210,255,197,197,197,
255,193,193,193,255,111,111,111,255,17,17,17,255,195,195,195,255,216,179,150,
255,180,80,0,255,212,162,122,255,222,222,222,255,228,228,228,255,166,166,166,
255,18,18,18,195,4,4,4,246,234,234,234,255,189,189,189,255,189,189,189,255,206,
206,206,255,81,81,81,255,31,28,26,255,166,77,7,255,198,122,62,255,225,223,222,
255,227,227,227,255,233,233,233,255,209,209,209,255,8,8,8,242,4,4,4,246,229,229,
229,255,194,194,194,255,195,195,195,255,201,201,201,255,213,213,213,255,46,32,
21,255,97,51,14,255,226,218,211,255,228,228,228,255,233,233,233,255,239,239,
239,255,214,214,214,255,8,8,8,242,14,14,14,205,195,195,195,255,206,206,206,255,
201,201,201,255,206,206,206,255,212,212,212,255,222,216,211,255,224,217,211,255,
228,228,228,255,233,233,233,255,239,239,239,255,244,244,244,255,172,172,172,255,
19,19,19,196,7,7,7,137,126,126,126,251,222,222,222,255,207,207,207,255,212,212,
212,255,218,218,218,255,223,223,223,255,228,228,228,255,234,234,234,255,239,239,
239,255,245,245,245,255,250,250,250,255,97,97,97,248,7,7,7,128,0,0,0,18,9,9,9,
238,195,195,195,255,220,220,220,255,218,218,218,255,223,223,223,255,229,229,229,
255,234,234,234,255,240,240,240,255,245,245,245,255,250,250,250,255,193,193,193,
255,11,11,11,235,0,0,0,14,0,0,0,0,0,0,0,77,29,29,29,244,190,190,190,255,229,229,
229,255,230,230,230,255,235,235,235,255,240,240,240,255,245,245,245,255,251,251,
251,255,195,195,195,255,20,20,20,243,0,0,0,70,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,79,
9,9,9,239,105,105,105,248,174,174,174,255,218,218,218,255,222,222,222,255,180,
180,180,255,101,101,101,248,10,10,10,237,0,0,0,73,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,20,6,6,6,137,17,17,17,205,6,6,6,247,6,6,6,246,17,17,17,202,6,
6,6,133,0,0,0,18,0,0,0,0,0,0,0,0,0,0,0,0};
static Fl_RGB_Image image_clock(idata_clock, 14, 14, 4, 0);

static unsigned char idata_clock1[] =
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,4,4,4,40,11,11,11,60,6,6,6,74,6,6,6,73,13,
13,13,60,4,4,4,40,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,11,
11,11,71,151,151,151,76,214,214,214,77,237,237,237,77,231,231,231,77,196,196,
196,77,126,126,126,75,11,11,11,71,0,0,0,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,43,
43,43,74,230,230,230,77,228,228,228,77,194,194,194,77,186,186,186,77,191,191,
191,77,204,204,204,77,222,222,222,77,193,193,193,77,26,26,26,74,0,0,0,20,0,0,0,
0,0,0,0,5,10,10,10,72,229,229,229,77,109,109,109,77,158,158,158,77,186,186,
186,77,188,188,188,77,194,194,194,77,199,199,199,77,205,205,205,77,219,219,219,
77,185,185,185,77,10,10,10,71,0,0,0,4,6,6,6,41,147,147,147,76,231,231,231,77,
141,141,141,77,6,6,6,77,176,176,176,77,194,194,194,77,202,202,202,77,171,171,
171,77,182,182,182,77,216,216,216,77,227,227,227,77,96,96,96,75,6,6,6,38,12,12,
12,62,210,210,210,77,197,197,197,77,193,193,193,77,111,111,111,77,17,17,17,77,
195,195,195,77,183,183,183,77,90,90,90,77,167,167,167,77,222,222,222,77,228,228,
228,77,166,166,166,77,18,18,18,59,4,4,4,74,234,234,234,77,189,189,189,77,189,
189,189,77,206,206,206,77,81,81,81,77,28,28,28,77,86,86,86,77,130,130,130,77,
223,223,223,77,227,227,227,77,233,233,233,77,209,209,209,77,8,8,8,73,4,4,4,74,
229,229,229,77,194,194,194,77,195,195,195,77,201,201,201,77,213,213,213,77,33,
33,33,77,55,55,55,77,218,218,218,77,228,228,228,77,233,233,233,77,239,239,239,
77,214,214,214,77,8,8,8,73,14,14,14,62,195,195,195,77,206,206,206,77,201,201,
201,77,206,206,206,77,212,212,212,77,216,216,216,77,217,217,217,77,228,228,228,
77,233,233,233,77,239,239,239,77,244,244,244,77,172,172,172,77,19,19,19,59,7,7,
7,41,126,126,126,76,222,222,222,77,207,207,207,77,212,212,212,77,218,218,218,
77,223,223,223,77,228,228,228,77,234,234,234,77,239,239,239,77,245,245,245,77,
250,250,250,77,97,97,97,75,7,7,7,39,0,0,0,5,9,9,9,72,195,195,195,77,220,220,220,
77,218,218,218,77,223,223,223,77,229,229,229,77,234,234,234,77,240,240,240,77,
245,245,245,77,250,250,250,77,193,193,193,77,11,11,11,71,0,0,0,4,0,0,0,0,0,0,0,
23,29,29,29,74,190,190,190,77,229,229,229,77,230,230,230,77,235,235,235,77,240,
240,240,77,245,245,245,77,251,251,251,77,195,195,195,77,20,20,20,73,0,0,0,21,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,9,9,9,72,105,105,105,75,174,174,174,77,218,218,
218,77,222,222,222,77,180,180,180,77,101,101,101,75,10,10,10,72,0,0,0,22,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,41,17,17,17,62,6,6,6,75,6,6,6,
74,17,17,17,61,6,6,6,40,0,0,0,5,0,0,0,0,0,0,0,0,0,0,0,0};
static Fl_RGB_Image image_clock1(idata_clock1, 14, 14, 4, 0);

static unsigned char idata_geom[] =
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,0,0,0,
138,0,0,0,209,0,0,0,245,0,0,0,215,0,0,0,143,0,0,0,39,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,100,0,0,0,233,33,33,33,165,34,34,34,191,166,166,
166,106,39,39,39,185,32,32,32,159,0,0,0,231,0,0,0,115,0,0,0,1,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,104,4,4,4,213,168,168,168,109,103,103,103,145,156,156,156,119,255,
255,255,89,186,186,186,108,86,86,86,156,185,185,185,99,5,5,5,201,0,0,0,120,0,0,
0,0,0,0,0,0,0,0,0,32,0,0,0,236,159,159,159,109,255,255,255,89,71,71,71,168,
230,230,230,95,255,255,255,89,255,255,255,89,64,64,64,173,244,244,244,89,165,
165,165,102,0,0,0,233,0,0,0,43,0,0,0,0,0,0,0,131,34,34,34,157,243,243,243,92,
233,233,233,94,60,60,60,177,220,220,220,97,216,216,216,99,220,220,220,97,57,57,
57,177,202,202,202,94,187,187,187,92,31,31,31,147,0,0,0,154,0,0,0,0,0,0,0,187,
74,74,74,150,162,162,162,116,186,186,186,108,58,58,58,178,230,230,230,95,246,
246,246,91,235,235,235,90,52,52,52,175,159,159,159,102,126,126,126,110,54,54,54,
136,0,0,0,210,0,0,0,0,0,0,0,234,129,129,129,122,255,255,255,89,255,255,255,89,
65,65,65,172,255,255,255,89,238,238,238,89,218,218,218,89,50,50,50,172,175,175,
175,89,155,155,155,89,89,89,89,105,0,0,0,250,0,0,0,0,0,0,0,197,31,31,31,196,171,
171,171,113,255,255,255,89,65,65,65,172,238,238,238,89,218,218,218,89,195,195,
195,89,44,44,44,173,152,152,152,89,93,93,93,110,16,16,16,189,0,0,0,220,0,0,0,0,
0,0,0,134,36,36,36,158,91,91,91,153,64,64,64,173,23,23,23,215,55,55,55,172,50,
50,50,172,44,44,44,172,15,15,15,214,34,34,34,171,39,39,39,152,14,14,14,146,0,0,
0,158,0,0,0,0,0,0,0,39,0,0,0,236,172,172,172,108,235,235,235,89,58,58,58,169,
175,175,175,94,172,172,172,89,152,152,152,89,32,32,32,174,109,109,109,89,68,68,
68,95,0,0,0,231,0,0,0,51,0,0,0,0,0,0,0,0,0,0,0,115,4,4,4,204,157,157,157,99,76,
76,76,146,108,108,108,117,149,149,149,89,100,100,100,104,33,33,33,161,70,70,70,
98,1,1,1,190,0,0,0,131,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,116,0,0,0,233,23,
23,23,152,24,24,24,182,101,101,101,96,17,17,17,180,12,12,12,153,0,0,0,228,0,0,
0,131,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,43,0,0,0,154,0,0,
0,222,0,0,0,251,0,0,0,228,0,0,0,159,0,0,0,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static Fl_RGB_Image image_geom(idata_geom, 14, 14, 4, 0);

static unsigned char idata_geom1[] =
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,
42,0,0,0,63,0,0,0,74,0,0,0,65,0,0,0,43,0,0,0,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,30,0,0,0,70,33,33,33,50,34,34,34,58,166,166,166,32,39,
39,39,56,32,32,32,48,0,0,0,70,0,0,0,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
31,4,4,4,64,168,168,168,33,103,103,103,44,156,156,156,36,255,255,255,27,186,
186,186,33,86,86,86,47,185,185,185,30,5,5,5,61,0,0,0,36,0,0,0,0,0,0,0,0,0,0,0,
10,0,0,0,71,159,159,159,33,255,255,255,27,71,71,71,51,230,230,230,29,255,255,
255,27,255,255,255,27,64,64,64,52,244,244,244,27,165,165,165,31,0,0,0,70,0,0,0,
13,0,0,0,0,0,0,0,40,34,34,34,47,243,243,243,28,233,233,233,28,60,60,60,53,220,
220,220,29,216,216,216,30,220,220,220,29,57,57,57,53,202,202,202,28,187,187,187,
28,31,31,31,44,0,0,0,47,0,0,0,0,0,0,0,56,74,74,74,45,162,162,162,35,186,186,
186,33,58,58,58,54,230,230,230,29,246,246,246,27,235,235,235,27,52,52,52,53,159,
159,159,31,126,126,126,33,54,54,54,41,0,0,0,63,0,0,0,0,0,0,0,71,129,129,129,37,
255,255,255,27,255,255,255,27,65,65,65,52,255,255,255,27,238,238,238,27,218,218,
218,27,50,50,50,52,175,175,175,27,155,155,155,27,89,89,89,32,0,0,0,75,0,0,0,0,0,
0,0,59,31,31,31,59,171,171,171,34,255,255,255,27,65,65,65,52,238,238,238,27,
218,218,218,27,195,195,195,27,44,44,44,52,152,152,152,27,93,93,93,33,16,16,16,
57,0,0,0,66,0,0,0,0,0,0,0,40,36,36,36,48,91,91,91,46,64,64,64,52,23,23,23,65,
55,55,55,52,50,50,50,52,44,44,44,52,15,15,15,65,34,34,34,52,39,39,39,46,14,14,
14,44,0,0,0,48,0,0,0,0,0,0,0,12,0,0,0,71,172,172,172,33,235,235,235,27,58,58,
58,51,175,175,175,28,172,172,172,27,152,152,152,27,32,32,32,53,109,109,109,27,
68,68,68,29,0,0,0,70,0,0,0,15,0,0,0,0,0,0,0,0,0,0,0,35,4,4,4,62,157,157,157,30,
76,76,76,44,108,108,108,35,149,149,149,27,100,100,100,31,33,33,33,49,70,70,70,
30,1,1,1,57,0,0,0,40,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,35,0,0,0,70,23,23,
23,46,24,24,24,55,101,101,101,29,17,17,17,54,12,12,12,46,0,0,0,69,0,0,0,40,0,0,
0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,0,0,0,47,0,0,0,67,0,0,0,
76,0,0,0,69,0,0,0,48,0,0,0,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static Fl_RGB_Image image_geom1(idata_geom1, 14, 14, 4, 0);

static unsigned char idata_render[] =
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,4,2,2,122,20,16,4,191,12,10,3,238,12,10,3,
238,20,16,7,191,4,4,2,122,0,0,0,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,65,13,11,3,232,157,145,114,249,232,223,195,255,250,245,228,255,247,239,212,
255,217,203,164,255,133,122,93,248,13,11,7,232,0,0,0,65,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,66,40,38,30,246,236,227,200,255,245,235,206,255,148,136,100,255,57,52,
38,255,55,50,36,255,133,121,86,255,229,211,157,255,206,189,140,255,24,22,17,
245,0,0,0,66,0,0,0,0,0,0,0,14,12,10,3,234,238,228,201,255,255,233,167,255,239,
197,75,255,24,20,8,255,0,0,0,255,0,0,0,255,24,21,11,255,239,207,116,255,255,228,
153,255,199,182,129,255,11,10,7,234,0,0,0,14,8,6,2,126,157,146,114,251,255,243,
209,255,255,210,82,255,255,212,89,255,168,142,65,255,0,0,0,255,0,0,0,255,168,
146,82,255,255,224,134,255,255,226,143,255,255,230,160,255,94,84,59,248,8,6,6,
126,20,16,5,195,231,222,194,255,255,224,134,255,255,213,91,255,255,215,100,255,
255,217,109,255,232,200,107,255,232,202,116,255,255,224,136,255,255,227,145,255,
255,229,154,255,255,231,163,255,175,160,118,255,20,18,14,195,9,7,3,242,249,241,
219,255,255,217,110,255,255,216,102,255,255,218,110,255,255,220,119,255,0,0,0,
255,0,0,0,255,255,227,146,255,255,229,155,255,255,231,164,255,255,234,173,255,
223,206,159,255,9,8,7,242,9,7,3,242,245,234,203,255,54,49,36,255,0,0,0,255,0,0,
0,255,213,186,109,255,0,0,0,255,0,0,0,255,213,192,131,255,0,0,0,255,0,0,0,255,
34,31,25,255,223,209,169,255,9,8,7,242,20,17,8,195,212,198,157,255,132,119,85,
255,0,0,0,255,0,0,0,255,110,97,60,255,239,214,140,255,239,216,148,255,110,100,
72,255,0,0,0,255,0,0,0,255,103,97,78,255,175,165,139,255,20,20,17,195,8,6,4,
126,129,118,88,249,207,191,144,255,1,1,1,255,0,0,0,255,168,150,99,255,255,230,
160,255,255,233,169,255,168,155,117,255,0,0,0,255,1,1,1,255,184,175,148,255,94,
89,78,248,8,8,6,126,0,0,0,14,11,10,5,234,205,188,138,255,174,157,112,255,43,38,
26,255,253,229,160,255,255,233,170,255,255,235,179,255,253,236,187,255,43,40,
33,255,163,155,132,255,189,181,159,255,11,11,10,234,0,0,0,14,0,0,0,0,0,0,0,66,
24,22,16,244,195,177,126,255,243,221,157,255,255,233,172,255,255,236,181,255,
255,238,190,255,255,240,199,255,243,232,198,255,189,182,161,255,18,17,16,244,0,
0,0,66,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,66,11,10,8,234,94,85,63,248,175,162,125,
255,223,208,167,255,223,211,175,255,175,167,143,255,94,89,80,248,11,11,10,234,0,
0,0,66,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,8,6,6,126,20,18,14,
195,9,8,7,242,9,8,7,242,20,20,17,195,8,8,6,126,0,0,0,14,0,0,0,0,0,0,0,0,0,0,0,0};
static Fl_RGB_Image image_render(idata_render, 14, 14, 4, 0);

static unsigned char idata_render1[] =
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,3,3,3,37,12,12,12,58,7,7,7,72,7,7,7,72,13,
13,13,58,3,3,3,37,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,8,8,
8,70,135,135,135,75,213,213,213,77,239,239,239,77,229,229,229,77,190,190,190,
77,113,113,113,75,10,10,10,70,0,0,0,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,35,35,
35,74,218,218,218,77,225,225,225,77,124,124,124,77,47,47,47,77,45,45,45,77,109,
109,109,77,193,193,193,77,173,173,173,77,20,20,20,74,0,0,0,20,0,0,0,0,0,0,0,4,7,
7,7,71,219,219,219,77,211,211,211,77,157,157,157,77,16,16,16,77,0,0,0,77,0,0,
0,77,17,17,17,77,177,177,177,77,204,204,204,77,164,164,164,77,9,9,9,71,0,0,0,
4,5,5,5,38,135,135,135,76,232,232,232,77,168,168,168,77,172,172,172,77,116,
116,116,77,0,0,0,77,0,0,0,77,125,125,125,77,194,194,194,77,199,199,199,77,207,
207,207,77,76,76,76,75,7,7,7,38,12,12,12,59,212,212,212,77,194,194,194,77,173,
173,173,77,177,177,177,77,182,182,182,77,169,169,169,77,174,174,174,77,195,195,
195,77,200,200,200,77,204,204,204,77,209,209,209,77,146,146,146,77,17,17,17,59,
6,6,6,73,234,234,234,77,182,182,182,77,178,178,178,77,182,182,182,77,187,187,
187,77,0,0,0,77,0,0,0,77,200,200,200,77,205,205,205,77,209,209,209,77,214,214,
214,77,191,191,191,77,8,8,8,73,6,6,6,73,224,224,224,77,45,45,45,77,0,0,0,77,0,0,
0,77,161,161,161,77,0,0,0,77,0,0,0,77,172,172,172,77,0,0,0,77,0,0,0,77,29,29,
29,77,196,196,196,77,8,8,8,73,14,14,14,59,184,184,184,77,108,108,108,77,0,0,0,
77,0,0,0,77,85,85,85,77,189,189,189,77,193,193,193,77,91,91,91,77,0,0,0,77,0,0,
0,77,90,90,90,77,157,157,157,77,18,18,18,59,6,6,6,38,108,108,108,75,175,175,
175,77,1,1,1,77,0,0,0,77,133,133,133,77,207,207,207,77,212,212,212,77,142,142,
142,77,0,0,0,77,1,1,1,77,166,166,166,77,86,86,86,75,7,7,7,38,0,0,0,4,8,8,8,71,
171,171,171,77,143,143,143,77,34,34,34,77,206,206,206,77,212,212,212,77,217,217,
217,77,220,220,220,77,38,38,38,77,147,147,147,77,174,174,174,77,10,10,10,71,0,0,
0,4,0,0,0,0,0,0,0,20,20,20,20,74,160,160,160,77,200,200,200,77,213,213,213,77,
218,218,218,77,222,222,222,77,227,227,227,77,220,220,220,77,175,175,175,77,17,
17,17,74,0,0,0,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,9,9,9,71,78,78,78,75,150,
150,150,77,195,195,195,77,199,199,199,77,159,159,159,77,87,87,87,75,10,10,10,71,
0,0,0,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,7,7,7,38,17,17,17,59,
8,8,8,73,8,8,8,73,18,18,18,59,7,7,7,38,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0};
static Fl_RGB_Image image_render1(idata_render1, 14, 14, 4, 0);

static unsigned char idata_tonemap[] =
{8,3,0,241,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,
0,255,5,2,0,251,12,6,1,246,19,10,3,231,25,15,7,220,28,18,10,227,23,15,9,203,0,
0,0,255,254,237,223,255,254,251,248,255,254,238,225,255,254,226,203,255,254,
213,180,255,254,200,158,255,254,193,145,249,245,183,134,246,241,177,126,238,253,
184,129,213,254,182,125,194,209,143,90,202,41,29,20,211,0,0,0,255,254,251,249,
255,254,113,0,255,254,113,0,255,254,113,0,255,254,113,0,255,248,119,15,247,172,
89,23,243,97,55,20,236,117,70,34,224,180,116,65,216,208,143,91,201,254,185,131,
150,53,41,31,166,0,0,0,255,254,239,228,255,254,113,0,255,154,68,0,255,158,70,0,
255,254,123,18,240,228,119,33,238,89,50,19,244,104,63,30,226,115,74,42,214,128,
88,56,218,197,144,102,191,254,196,151,134,58,46,37,150,0,0,0,255,254,228,207,
255,252,112,0,255,62,27,0,255,72,34,5,252,235,123,35,236,238,136,53,210,113,69,
34,223,107,70,40,229,113,78,51,222,174,128,91,171,254,197,153,133,174,139,114,
173,46,38,32,181,0,0,0,255,254,216,186,255,254,114,2,253,176,86,14,242,169,90,
26,240,232,132,53,226,254,156,78,192,220,144,84,184,156,108,71,209,160,118,85,
199,249,193,151,132,255,206,168,116,158,131,111,163,45,39,34,171,0,0,0,255,254,
206,166,254,246,121,21,244,239,128,38,235,254,146,61,206,254,157,80,191,215,141,
83,208,205,144,95,199,254,188,137,145,254,199,156,130,171,138,113,171,157,131,
111,162,255,219,191,85,72,64,57,95,1,0,0,253,254,201,159,246,238,128,40,234,219,
126,53,226,246,153,78,192,254,168,100,174,204,144,95,197,194,144,105,188,254,
200,157,129,255,207,170,114,156,130,111,161,140,120,105,152,255,226,203,69,77,
70,64,76,9,4,0,248,246,192,149,244,173,101,43,218,108,67,35,221,112,74,44,227,
160,114,76,207,254,190,140,143,254,201,159,128,171,139,114,168,155,130,110,161,
236,204,179,88,255,226,204,68,101,91,85,134,32,29,28,134,16,8,2,242,236,184,141,
236,108,68,36,221,116,77,47,209,112,80,53,218,120,90,66,208,249,197,157,129,255,
208,172,111,155,130,111,158,135,116,102,152,246,219,198,68,255,233,216,51,74,69,
66,124,20,20,20,120,23,14,6,223,254,197,151,208,132,88,54,221,113,80,54,218,
139,105,78,177,170,134,107,150,166,136,112,168,152,128,109,159,255,221,195,80,
255,227,206,65,96,88,82,132,72,68,64,123,255,246,239,20,94,93,92,8,30,19,10,211,
254,196,149,188,196,141,96,195,158,120,89,194,206,164,131,137,245,201,166,111,
151,127,109,158,134,116,103,149,255,228,207,64,255,234,218,49,70,66,63,122,42,
41,40,113,255,253,251,4,0,0,0,0,32,21,13,220,200,144,100,194,254,193,146,138,
255,203,163,123,165,135,112,167,150,127,109,158,255,222,196,78,255,228,208,63,
95,87,81,128,69,65,62,122,220,213,208,21,255,253,252,3,0,0,0,102,0,0,0,102,23,
17,11,193,39,29,22,204,52,41,33,155,57,46,39,139,42,36,31,175,41,36,32,164,70,
62,57,85,74,69,64,67,27,26,24,127,17,17,17,117,42,41,41,6,0,0,0,0,0,0,0,102,0,
0,0,102};
static Fl_RGB_Image image_tonemap(idata_tonemap, 14, 14, 4, 0);

static unsigned char idata_tonemap1[] =
{4,4,4,73,0,0,0,77,0,0,0,77,0,0,0,77,0,0,0,77,0,0,0,77,0,0,0,77,0,0,0,77,2,
2,2,76,6,6,6,74,11,11,11,70,16,16,16,66,19,19,19,69,16,16,16,61,0,0,0,77,238,
238,238,77,251,251,251,77,239,239,239,77,228,228,228,77,217,217,217,77,206,206,
206,77,199,199,199,75,189,189,189,74,183,183,183,72,191,191,191,64,189,189,189,
59,149,149,149,61,30,30,30,64,0,0,0,77,251,251,251,77,127,127,127,77,127,127,
127,77,127,127,127,77,127,127,127,77,131,131,131,75,97,97,97,73,58,58,58,71,75,
75,75,68,122,122,122,65,149,149,149,61,192,192,192,45,42,42,42,50,0,0,0,77,241,
241,241,77,127,127,127,77,77,77,77,77,79,79,79,77,136,136,136,72,130,130,130,72,
54,54,54,74,67,67,67,68,78,78,78,65,92,92,92,66,149,149,149,58,202,202,202,40,
47,47,47,45,0,0,0,77,230,230,230,77,126,126,126,77,31,31,31,77,38,38,38,76,135,
135,135,71,145,145,145,63,73,73,73,67,73,73,73,69,82,82,82,67,132,132,132,52,
203,203,203,40,144,144,144,52,39,39,39,55,0,0,0,77,220,220,220,77,128,128,128,
76,95,95,95,73,97,97,97,72,142,142,142,68,166,166,166,58,152,152,152,56,113,
113,113,63,122,122,122,60,200,200,200,40,211,211,211,35,134,134,134,49,39,39,39,
52,0,0,0,77,210,210,210,77,133,133,133,74,138,138,138,71,157,157,157,62,167,
167,167,58,149,149,149,63,150,150,150,60,195,195,195,44,205,205,205,39,142,142,
142,52,134,134,134,49,223,223,223,26,64,64,64,29,0,0,0,76,206,206,206,74,139,
139,139,71,136,136,136,68,162,162,162,58,177,177,177,53,149,149,149,59,149,149,
149,57,205,205,205,39,212,212,212,34,133,133,133,49,122,122,122,46,229,229,229,
21,70,70,70,23,4,4,4,75,197,197,197,74,108,108,108,66,71,71,71,67,78,78,78,69,
118,118,118,63,197,197,197,43,206,206,206,39,142,142,142,51,132,132,132,49,207,
207,207,27,229,229,229,21,93,93,93,40,30,30,30,40,9,9,9,73,188,188,188,71,72,72,
72,67,81,81,81,63,82,82,82,66,93,93,93,63,203,203,203,39,213,213,213,34,133,
133,133,48,118,118,118,46,222,222,222,21,235,235,235,15,70,70,70,37,20,20,20,36,
14,14,14,67,202,202,202,63,93,93,93,67,83,83,83,66,108,108,108,53,138,138,138,
45,139,139,139,51,130,130,130,48,225,225,225,24,230,230,230,20,89,89,89,40,68,
68,68,37,247,247,247,6,93,93,93,2,20,20,20,64,201,201,201,57,146,146,146,59,
123,123,123,59,168,168,168,41,205,205,205,34,130,130,130,48,118,118,118,45,231,
231,231,19,236,236,236,15,66,66,66,37,41,41,41,34,253,253,253,1,0,0,0,0,22,22,
22,66,150,150,150,59,200,200,200,42,209,209,209,37,138,138,138,50,129,129,129,
48,225,225,225,24,231,231,231,19,88,88,88,39,65,65,65,37,214,214,214,6,253,253,
253,1,0,0,0,31,0,0,0,31,17,17,17,58,30,30,30,62,42,42,42,47,48,48,48,42,36,36,
36,53,36,36,36,50,63,63,63,26,69,69,69,20,25,25,25,38,17,17,17,35,41,41,41,2,0,
0,0,0,0,0,0,31,0,0,0,31};
static Fl_RGB_Image image_tonemap1(idata_tonemap1, 14, 14, 4, 0);

static unsigned char idata_stop[] =
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,232,0,0,0,255,0,0,
0,255,5,5,5,232,0,0,0,0,0,0,0,0,4,4,4,232,0,0,0,255,0,0,0,255,5,5,5,232,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,242,242,242,255,240,240,240,255,0,0,0,255,
0,0,0,0,0,0,0,0,0,0,0,255,242,242,242,255,240,240,240,255,0,0,0,255,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,172,172,172,255,0,0,0,255,0,0,
0,0,0,0,0,0,0,0,0,255,255,255,255,255,172,172,172,255,0,0,0,255,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,255,247,247,247,255,182,182,182,255,0,0,0,255,0,0,0,0,
0,0,0,0,0,0,0,255,247,247,247,255,182,182,182,255,0,0,0,255,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,255,239,239,239,255,193,193,193,255,0,0,0,255,0,0,0,0,0,0,
0,0,0,0,0,255,239,239,239,255,193,193,193,255,0,0,0,255,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,255,233,233,233,255,203,203,203,255,0,0,0,255,0,0,0,0,0,0,0,0,
0,0,0,255,233,233,233,255,203,203,203,255,0,0,0,255,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,255,230,230,230,255,214,214,214,255,0,0,0,255,0,0,0,0,0,0,0,0,0,0,
0,255,230,230,230,255,214,214,214,255,0,0,0,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,255,229,229,229,255,224,224,224,255,0,0,0,255,0,0,0,0,0,0,0,0,0,0,0,
255,229,229,229,255,224,224,224,255,0,0,0,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,255,231,231,231,255,235,235,235,255,0,0,0,255,0,0,0,0,0,0,0,0,0,0,0,255,
231,231,231,255,235,235,235,255,0,0,0,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
255,235,235,235,255,245,245,245,255,0,0,0,255,0,0,0,0,0,0,0,0,0,0,0,255,235,235,
235,255,245,245,245,255,0,0,0,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,243,
243,243,255,254,254,254,255,0,0,0,255,0,0,0,0,0,0,0,0,0,0,0,255,243,243,243,255,
254,254,254,255,0,0,0,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,8,8,232,0,0,0,255,0,
0,0,255,8,8,8,232,0,0,0,0,0,0,0,0,8,8,8,232,0,0,0,255,0,0,0,255,8,8,8,232,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static Fl_RGB_Image image_stop(idata_stop, 14, 14, 4, 0);

static unsigned char idata_stop1[] =
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,70,0,0,0,77,0,0,0,
77,5,5,5,70,0,0,0,0,0,0,0,0,4,4,4,70,0,0,0,77,0,0,0,77,5,5,5,70,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,77,242,242,242,77,240,240,240,77,0,0,0,77,0,0,0,0,0,0,
0,0,0,0,0,77,242,242,242,77,240,240,240,77,0,0,0,77,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,77,255,255,255,77,172,172,172,77,0,0,0,77,0,0,0,0,0,0,0,0,0,0,0,
77,255,255,255,77,172,172,172,77,0,0,0,77,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,77,247,247,247,77,182,182,182,77,0,0,0,77,0,0,0,0,0,0,0,0,0,0,0,77,247,247,
247,77,182,182,182,77,0,0,0,77,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,77,239,239,
239,77,193,193,193,77,0,0,0,77,0,0,0,0,0,0,0,0,0,0,0,77,239,239,239,77,193,193,
193,77,0,0,0,77,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,77,233,233,233,77,203,203,
203,77,0,0,0,77,0,0,0,0,0,0,0,0,0,0,0,77,233,233,233,77,203,203,203,77,0,0,0,77,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,77,230,230,230,77,214,214,214,77,0,0,0,
77,0,0,0,0,0,0,0,0,0,0,0,77,230,230,230,77,214,214,214,77,0,0,0,77,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,77,229,229,229,77,224,224,224,77,0,0,0,77,0,0,0,0,0,
0,0,0,0,0,0,77,229,229,229,77,224,224,224,77,0,0,0,77,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,77,231,231,231,77,235,235,235,77,0,0,0,77,0,0,0,0,0,0,0,0,0,0,0,
77,231,231,231,77,235,235,235,77,0,0,0,77,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,77,235,235,235,77,245,245,245,77,0,0,0,77,0,0,0,0,0,0,0,0,0,0,0,77,235,235,
235,77,245,245,245,77,0,0,0,77,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,77,243,243,
243,77,254,254,254,77,0,0,0,77,0,0,0,0,0,0,0,0,0,0,0,77,243,243,243,77,254,254,
254,77,0,0,0,77,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,8,8,70,0,0,0,77,0,0,0,77,8,8,
8,70,0,0,0,0,0,0,0,0,8,8,8,70,0,0,0,77,0,0,0,77,8,8,8,70,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static Fl_RGB_Image image_stop1(idata_stop1, 14, 14, 4, 0);

static unsigned char idata_rewind[] =
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,
232,0,0,0,255,3,3,3,232,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,111,6,6,6,199,0,0,0,0,0,0,
0,0,0,0,0,0,2,2,2,110,6,6,6,205,0,0,0,0,0,0,0,255,176,176,176,255,0,0,0,255,0,
0,0,0,0,0,0,15,7,7,7,183,19,19,19,246,2,2,2,251,0,0,0,0,0,0,0,15,8,8,8,181,22,
22,22,244,0,0,0,255,0,0,0,0,0,0,0,255,203,203,203,255,0,0,0,255,0,0,0,53,7,7,7,
232,142,142,142,251,197,197,197,255,2,2,2,251,0,0,0,52,8,8,8,231,145,145,145,
251,204,204,204,255,0,0,0,255,0,0,0,0,0,0,0,255,214,214,214,255,0,0,0,255,22,22,
22,246,208,208,208,255,241,241,241,255,187,187,187,255,0,0,0,254,23,23,23,246,
210,210,210,255,243,243,243,255,200,200,200,255,0,0,0,255,0,0,0,0,0,0,0,255,225,
225,225,255,107,107,107,251,221,221,221,255,233,233,233,255,203,203,203,255,202,
202,202,255,110,110,110,251,224,224,224,255,237,237,237,255,212,212,212,255,213,
213,213,255,0,0,0,255,0,0,0,0,0,0,0,255,235,235,235,255,118,118,118,251,190,190,
190,255,221,221,221,255,223,223,223,255,223,223,223,255,114,114,114,250,193,193,
193,255,231,231,231,255,232,232,232,255,234,234,234,255,0,0,0,255,0,0,0,0,0,0,0,
255,246,246,246,255,0,0,0,255,11,11,11,245,160,160,160,254,245,245,245,255,239,
239,239,255,0,0,0,254,10,10,10,246,159,159,159,254,254,254,254,255,254,254,254,
255,0,0,0,255,0,0,0,0,0,0,0,255,255,255,255,255,0,0,0,255,0,0,0,47,12,12,12,228,
98,98,98,247,238,238,238,255,3,3,3,251,0,0,0,46,12,12,12,227,90,90,90,247,244,
244,244,255,0,0,0,255,0,0,0,0,0,0,0,255,254,254,254,255,0,0,0,255,0,0,0,0,0,0,0,
12,15,15,15,175,33,33,33,245,3,3,3,251,0,0,0,0,0,0,0,12,13,13,13,173,32,32,32,
244,0,0,0,255,0,0,0,0,9,9,9,232,0,0,0,255,9,9,9,232,0,0,0,0,0,0,0,0,0,0,0,0,5,5,
5,102,15,15,15,191,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,101,14,14,14,197,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static Fl_RGB_Image image_rewind(idata_rewind, 14, 14, 4, 0);

static unsigned char idata_rewind1[] =
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,
70,0,0,0,77,3,3,3,70,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,34,6,6,6,60,0,0,0,0,0,0,0,0,
0,0,0,0,2,2,2,33,6,6,6,62,0,0,0,0,0,0,0,77,176,176,176,77,0,0,0,77,0,0,0,0,0,
0,0,5,7,7,7,55,19,19,19,74,2,2,2,76,0,0,0,0,0,0,0,5,8,8,8,55,22,22,22,74,0,0,
0,77,0,0,0,0,0,0,0,77,203,203,203,77,0,0,0,77,0,0,0,16,7,7,7,70,142,142,142,
76,197,197,197,77,2,2,2,76,0,0,0,16,8,8,8,70,145,145,145,76,204,204,204,77,0,0,
0,77,0,0,0,0,0,0,0,77,214,214,214,77,0,0,0,77,22,22,22,74,208,208,208,77,241,
241,241,77,187,187,187,77,0,0,0,77,23,23,23,74,210,210,210,77,243,243,243,77,
200,200,200,77,0,0,0,77,0,0,0,0,0,0,0,77,225,225,225,77,107,107,107,76,221,221,
221,77,233,233,233,77,203,203,203,77,202,202,202,77,110,110,110,76,224,224,224,
77,237,237,237,77,212,212,212,77,213,213,213,77,0,0,0,77,0,0,0,0,0,0,0,77,235,
235,235,77,118,118,118,76,190,190,190,77,221,221,221,77,223,223,223,77,223,223,
223,77,114,114,114,75,193,193,193,77,231,231,231,77,232,232,232,77,234,234,234,
77,0,0,0,77,0,0,0,0,0,0,0,77,246,246,246,77,0,0,0,77,11,11,11,74,160,160,160,
77,245,245,245,77,239,239,239,77,0,0,0,77,10,10,10,74,159,159,159,77,254,254,
254,77,254,254,254,77,0,0,0,77,0,0,0,0,0,0,0,77,255,255,255,77,0,0,0,77,0,0,0,
14,12,12,12,69,98,98,98,75,238,238,238,77,3,3,3,76,0,0,0,14,12,12,12,69,90,90,
90,75,244,244,244,77,0,0,0,77,0,0,0,0,0,0,0,77,254,254,254,77,0,0,0,77,0,0,0,0,
0,0,0,4,15,15,15,53,33,33,33,74,3,3,3,76,0,0,0,0,0,0,0,4,13,13,13,52,32,32,32,
74,0,0,0,77,0,0,0,0,9,9,9,70,0,0,0,77,9,9,9,70,0,0,0,0,0,0,0,0,0,0,0,0,5,5,5,
31,15,15,15,58,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,30,14,14,14,59,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static Fl_RGB_Image image_rewind1(idata_rewind1, 14, 14, 4, 0);

static unsigned char idata_play[] =
{0,0,0,0,5,5,5,221,6,6,6,153,0,0,0,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,54,54,54,247,5,5,
5,240,0,0,0,96,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,255,227,227,227,255,139,139,139,255,28,28,28,243,9,9,
9,209,0,0,0,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,255,236,236,236,255,178,178,178,255,165,165,165,255,104,104,104,254,9,
9,9,246,8,8,8,156,0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,255,238,238,238,255,186,186,186,255,176,176,176,255,180,180,180,255,171,
171,171,255,73,73,73,247,7,7,7,241,2,2,2,98,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,255,240,240,240,255,194,194,194,255,185,185,185,255,190,190,190,255,
195,195,195,255,200,200,200,255,162,162,162,255,36,36,36,244,11,11,11,211,0,0,0,
50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,242,242,242,255,202,202,202,255,195,195,
195,255,200,200,200,255,205,205,205,255,209,209,209,255,214,214,214,255,217,217,
217,255,134,134,134,254,12,12,12,246,16,16,16,137,0,0,0,0,0,0,0,0,0,0,0,255,243,
243,243,255,210,210,210,255,205,205,205,255,210,210,210,255,214,214,214,255,219,
219,219,255,224,224,224,255,227,227,227,255,140,140,140,254,12,12,12,246,16,16,
16,137,0,0,0,0,0,0,0,0,0,0,0,255,245,245,245,255,218,218,218,255,215,215,215,
255,220,220,220,255,224,224,224,255,229,229,229,255,186,186,186,255,41,41,41,
244,13,13,13,211,0,0,0,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,247,247,247,255,226,
226,226,255,225,225,225,255,229,229,229,255,217,217,217,255,93,93,93,247,9,9,9,
241,3,3,3,98,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,249,249,249,255,
234,234,234,255,233,233,233,255,145,145,145,254,13,13,13,246,12,12,12,156,0,0,0,
16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,244,244,244,255,
197,197,197,255,44,44,44,243,14,14,14,209,0,0,0,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,96,96,96,247,10,10,10,240,1,1,1,
96,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,10,10,10,221,12,12,12,153,0,0,0,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static Fl_RGB_Image image_play(idata_play, 14, 14, 4, 0);

static unsigned char idata_play1[] =
{0,0,0,0,5,5,5,67,6,6,6,46,0,0,0,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,77,54,54,54,75,5,5,5,72,
0,0,0,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,77,227,227,227,77,139,139,139,77,28,28,28,73,9,9,9,63,0,0,0,
14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,77,
236,236,236,77,178,178,178,77,165,165,165,77,104,104,104,77,9,9,9,74,8,8,8,47,0,
0,0,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,77,238,238,238,77,
186,186,186,77,176,176,176,77,180,180,180,77,171,171,171,77,73,73,73,75,7,7,7,
73,2,2,2,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,77,240,240,240,77,
194,194,194,77,185,185,185,77,190,190,190,77,195,195,195,77,200,200,200,77,162,
162,162,77,36,36,36,74,11,11,11,64,0,0,0,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,77,
242,242,242,77,202,202,202,77,195,195,195,77,200,200,200,77,205,205,205,77,209,
209,209,77,214,214,214,77,217,217,217,77,134,134,134,77,12,12,12,74,16,16,16,41,
0,0,0,0,0,0,0,0,0,0,0,77,243,243,243,77,210,210,210,77,205,205,205,77,210,210,
210,77,214,214,214,77,219,219,219,77,224,224,224,77,227,227,227,77,140,140,140,
77,12,12,12,74,16,16,16,41,0,0,0,0,0,0,0,0,0,0,0,77,245,245,245,77,218,218,218,
77,215,215,215,77,220,220,220,77,224,224,224,77,229,229,229,77,186,186,186,77,
41,41,41,74,13,13,13,64,0,0,0,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,77,247,247,247,
77,226,226,226,77,225,225,225,77,229,229,229,77,217,217,217,77,93,93,93,75,9,9,
9,73,3,3,3,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,77,249,249,249,77,
234,234,234,77,233,233,233,77,145,145,145,77,13,13,13,74,12,12,12,47,0,0,0,5,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,77,244,244,244,77,197,197,
197,77,44,44,44,73,14,14,14,63,0,0,0,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,77,96,96,96,75,10,10,10,72,1,1,1,29,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,10,10,
67,12,12,12,46,0,0,0,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0};
static Fl_RGB_Image image_play1(idata_play1, 14, 14, 4, 0);


