#!/bin/bash

load_llog_test() {
    grep -q llog_test /proc/modules && return
    # Module should have been placed with other lustre modules...
    modprobe llog_test
    grep -q llog_test /proc/modules && return
    # But maybe we're running from a developer tree...
    insmod ../obdclass/llog_test.ko
    grep -q llog_test /proc/modules && return
    # This is for 2.4 kernels (deprecated!)
    insmod ../obdclass/llog_test.o
    grep -q llog_test /proc/modules && return
    echo "Unable to load llog_test module!"
    false
    return
}

PATH=`dirname $0`:`dirname $0`/../utils:$PATH
TMP=${TMP:-/tmp}

MDS=`ls $LPROC/mds | grep -v num_refs | head -n 1`
[ -z "$MDS" ] && echo "no MDS available, skipping llog test" && exit 0

load_llog_test || exit 0
lctl modules > $TMP/ogdb-`hostname`
echo "NOW reload debugging syms.."

RC=0
lctl <<EOT || RC=2
attach llog_test llt_name llt_uuid
setup $MDS
EOT

# Using ignore_errors will allow lctl to cleanup even if the test fails.
lctl <<EOC
device llt_name
ignore_errors
cleanup
detach
EOC
rmmod llog_test || RC2=3
[ $RC -eq 0 -a "$RC2" ] && RC=$RC2

exit $RC
