/* ---------------------------------- manage.h ---------------------------------------------------------------------------
 header file used by manage.cpp

===============================================================================================================================
===============================================================================================================================
     This file is part of "luckyBackup" project
     Copyright 2008-2009, Loukas Avgeriou
     luckyBackup is distributed under the terms of the GNU General Public License
     luckyBackup is free software: you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation, either version 3 of the License, or
     (at your option) any later version.
 
     luckyBackup is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.
 
     You should have received a copy of the GNU General Public License
     along with luckyBackup.  If not, see <http://www.gnu.org/licenses/>.


 project version	: Please see "main.cpp" for project version

 developer 		: Loukas Avgeriou 
 last modified 		: 20 Oct 2009
===============================================================================================================================
===============================================================================================================================
*/

#ifndef MANAGE_H
#define MANAGE_H

#include "ui_manage.h"
#include <QCheckBox>
#include <QFileSystemModel>
#include <QTreeWidgetItem>
//==============================================================================================================
//Declaration of manageDialog class (this is the dialog that manmages existing backups of a task)

namespace BrowseFolder { class modelo; }

class manageDialog : public QDialog
{
	Q_OBJECT
	
	friend class BrowseFolder::modelo;
	
	public:
		manageDialog (QDialog *parent=0);
		
		QStringList dirs() const { return m_dirs; }

	private slots:
		void cancel();
		void logView();		// view the log file

	private:
		Ui::manageDialog uiG;
		BrowseFolder::modelo *m_model;
		QStringList m_dirs;
}; 

namespace BrowseFolder
{
	class modelo : public QFileSystemModel
	{
		public:
		modelo();

		virtual Qt::ItemFlags flags( const QModelIndex &index ) const;
		QVariant data( const QModelIndex& index, int role = Qt::DisplayRole ) const;
		bool setData( const QModelIndex& index, const QVariant& value, int role = Qt::EditRole );

		void setDirectories( QStringList &dirs );
		QStringList directories() const;

		virtual int columnCount( const QModelIndex& ) const { return 4; }

		private:
		bool ancestorChecked( const QString &path ) const;
		bool descendantChecked( const QString &path ) const;
		QSet<QString> m_checked;
	};

} // end namespace BrowseFolder

#endif

// end of manage.h ---------------------------------------------------------------------------
