/* ---------------------------------- execute.cpp ---------------------------------------------------------------------------
 do everything that deals with commands (rsync & others) execution

===============================================================================================================================
===============================================================================================================================
     This file is part of "luckyBackup" project
     Copyright 2008-2009, Loukas Avgeriou
     luckyBackup is distributed under the terms of the GNU General Public License
     luckyBackup is free software: you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation, either version 3 of the License, or
     (at your option) any later version.
 
     luckyBackup is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.
 
     You should have received a copy of the GNU General Public License
     along with luckyBackup.  If not, see <http://www.gnu.org/licenses/>.


 project version	: Please see "main.cpp" for project version

 developer 		: luckyb 
 last modified 		: 11 Dec 2009
===============================================================================================================================
===============================================================================================================================
 ********************************** DO NOT FORGET TO CHANGE "commandline.cpp:rsyncIT()" ********************************************************
*/

QProcess *syncProcess;
QTime StartTime(0,0,0,0);	//find out elapsed time from these;

// executeNOW=================================================================================================
// executes rsync (& other commands )and displays progress.
void luckyBackupWindow::executeNOW ()
{
	NOWexecuting = TRUE;		//this is mainly used if the window close button (or alt+F4) is pressed
	//change gui to execute mode !!
	swapGUI("execution");
	ui.AbortButton -> setText (tr("Abort NOW","push-button text"));
	ui.AbortButton -> setIcon(QIcon(":/luckyPrefix/abort.png"));
	ui.rsyncOutput -> setText("");
	
	outputString = "";
	outputError = "";
	calculating = FALSE;		//these 3 bools are used to diplay progress of rsync at the info window
	transfering = FALSE;
	deleting = FALSE;
	ExecuteBefore=FALSE;
	ExecuteAfter=FALSE;
	writeToLog=FALSE;
	errorsFound = 0;		//total error founds during profile execution
	count = 0;
	currentAfter = 0;
	currentBefore = 0;
	errorCount = 0;			//errors found during task execution

	//initiate tray icon
	if (QSystemTrayIcon::isSystemTrayAvailable ())
	{
		createTrayIcon();	//create the tray icon
		LBtray -> show();	// show the tray icon
	}
	//display a popup baloon
	trayMessage = 	tr("execution of profile:","tray message - execution of profile: <PROFILENAME> in progress...") + " " + 
			profileName + " " + tr("in progress...","tray message - execution of profile: <PROFILENAME> in progress...");
	if (DryRun)
		trayMessage.append("\n(" + tr("simulation mode") + ")");
	if ( (QSystemTrayIcon::isSystemTrayAvailable ()) && (QSystemTrayIcon::supportsMessages ()) )
		LBtray -> showMessage (appName, trayMessage, QSystemTrayIcon::Information,3000);
	
	connect ( ui.AbortButton, SIGNAL( clicked() ), this, SLOT( buttonPressed() ) );	//connect abort pushButton SLOT ----------------

	syncProcess = new QProcess(this);	//create a new qprocess (for rsync) & connect signals
	connect(syncProcess, SIGNAL(readyReadStandardError()), this, SLOT(appendRsyncOutput()));
	connect(syncProcess, SIGNAL(readyReadStandardOutput()), this, SLOT(appendRsyncOutput()));
	connect(syncProcess, SIGNAL (finished(int, QProcess::ExitStatus)), this, SLOT(procFinished()));

	if (silentMode)
		minimizeTray();
		
	//rsync command & arguments initiation
	command = "rsync";
	rsyncArguments.clear();
	syncAB = TRUE;

	StartTime.start();	//start the timer to measure elapsed time

	currentOperation = 0;

	//increase currentOperation until first operation to be executed (execute tasks with a "by-pass WARNING option too)
	while ( (currentOperation < TotalOperations) && (!Operation[currentOperation] -> GetPerform()) )
			currentOperation++;

	executeBeforeTask();				//execute pre-task commands if any
}

// swapGUI=====================================================================================================
//swaps the gui mode from normal to execute
void luckyBackupWindow::swapGUI(QString GUImode)
{
	if (GUImode == "execution")	//change gui to normal mode
	{
		ui.pushButton_start	-> setVisible (FALSE);
		ui.listWidget_operations -> setVisible (FALSE);
		ui.textBrowser_info	-> setVisible (FALSE);
		ui.label_TaskList -> setText(tr("commands output","output window label"));
		ui.frame_operations -> setToolTip(tr("rsync and pre/post task commands output is displayed here","tooltip"));
		
		ui.pushButton_up		-> setVisible (FALSE);
		ui.pushButton_down		-> setVisible (FALSE);
		ui.label_include	-> setVisible (FALSE);
		ui.menuFile		-> setEnabled (FALSE);
		languageMenu		-> setEnabled (FALSE);
		settingsMenu		-> setEnabled (FALSE);
		helpMenu		-> setEnabled (FALSE);
		profileToolbar		-> setEnabled (FALSE);
		profileComboToolbar	-> setEnabled (FALSE);
		ui.comboBox_profile	-> setEnabled (FALSE);
		ui.groupBox_task	-> setEnabled (FALSE);
		ui.checkBox_DryRun	-> setEnabled (FALSE);
		ui.pushButton_exit	-> setVisible (FALSE);
		ui.label		-> setVisible (FALSE);
	
		ui.AbortButton 	-> setVisible (TRUE);
		ui.rsyncOutput 	-> setVisible (TRUE);
		ui.nowDoing	-> setVisible (TRUE);
		ui.OperationProgress -> setVisible (TRUE);
		ui.pushButton_minimizeToTray	-> setVisible (TRUE);
		ui.pushButton_nextError	-> setVisible (TRUE);
		ui.pushButton_previousError	-> setVisible (TRUE);
		ui.pushButton_nextError	-> setEnabled (FALSE);
		ui.pushButton_previousError	-> setEnabled (FALSE);
	}
	else		//change gui to normal mode !!
	{
		ui.AbortButton 	-> setVisible (FALSE);
		ui.rsyncOutput 	-> setVisible (FALSE);
		ui.nowDoing	-> setVisible (FALSE);
		ui.OperationProgress -> setVisible (FALSE);
		ui.pushButton_minimizeToTray	-> setVisible (FALSE);
		ui.pushButton_nextError	-> setVisible (FALSE);
		ui.pushButton_previousError	-> setVisible (FALSE);
		
		ui.pushButton_start	-> setVisible (TRUE);
		ui.listWidget_operations -> setVisible (TRUE);
		ui.textBrowser_info	-> setVisible (TRUE);
		ui.label_TaskList -> setText(tr("Task list","task list label"));
		ui.frame_operations -> setToolTip(tr("List of all the available tasks","task list tooltip - line1")+"\n"+
				tr("Use the 'include checkboxes' to include or not a selected task","task list tooltip - line2"));
		
		ui.pushButton_up		-> setVisible (TRUE);
		ui.pushButton_down		-> setVisible (TRUE);
		ui.label_include	-> setVisible (TRUE);
		ui.menuFile		-> setEnabled (TRUE);
		languageMenu		-> setEnabled (TRUE);
		settingsMenu		-> setEnabled (TRUE);
		helpMenu		-> setEnabled (TRUE);
		profileToolbar		-> setEnabled (TRUE);
		profileComboToolbar	-> setEnabled (TRUE);
		ui.comboBox_profile	-> setEnabled (TRUE);
		ui.groupBox_task	-> setEnabled (TRUE);
		ui.checkBox_DryRun	-> setEnabled (TRUE);
		ui.pushButton_exit	-> setVisible (TRUE);
		ui.label		-> setVisible (TRUE);
	}
}

// start-abort-done button pressed=====================================================================================================
void luckyBackupWindow::buttonPressed()
{
	if (syncProcess->state() == QProcess::NotRunning)	//if syncProcess is not Running
	{
		ui.rsyncOutput -> setText("");
		swapGUI("normal");
		LBtray -> hide();	// hide the tray icon
		
		refreshList(); //refresh the listWidget_operations
		
		InfoData = QDateTime::currentDateTime().toString(Qt::DefaultLocaleLongDate) + "<br>" +
			tr("Execution of profile","full phrase: 'Execution of profile <PROFILENAME> finished'") +
			" <b>" + profileName + "</b> " + tr("finished","full phrase: 'Execution of profile <PROFILENAME> finished'")+" !!<br>";
		if (DryRun)
			InfoData.append("(" + tr("simulation mode") +")");
		else
		{
			if (!savedProfile)
				InfoData.append(tr("Could not update last execution time of tasks") + "<br>" + profile.errorString());
			else
				InfoData.append(tr("Last execution time of tasks updated"));
		}
		ui.textBrowser_info -> setText(InfoData);
	}
	else
	{
		currentOperation = TotalOperations + 2;		//this means the abort button is pressed to other functions
		syncProcess -> kill();	//kill rsyncProcess
		syncProcess -> waitForFinished();
		currentOperation = TotalOperations + 2;		//this means the abort button is pressed to other functions
		ExecuteBefore = FALSE;
		ExecuteAfter = FALSE;
		setNowDoing ();		//update Nowdoing textBrowser
	}
}

// createTrayIcon =============================================================================================================================
// create the tray icon
void luckyBackupWindow::createTrayIcon()
{
	//actions----------------------------------
	LBtrayMenu = new QMenu(this);
	actionAbort = new QAction(QIcon(":/luckyPrefix/abort.png"), tr("&Abort"), this);
	minimizeToTray = new QAction(QIcon(":/luckyPrefix/window_minimize.png"), tr("&Minimize to tray","tray menu action"), this);
	restoreFromTray = new QAction(QIcon(":/luckyPrefix/window_restore.png"), tr("&Restore","tray menu action"), this);
	
	connect( actionAbort, SIGNAL(triggered()), this, SLOT(buttonPressed()));		//tray icon action ABORT
	connect( minimizeToTray, SIGNAL(triggered()), this, SLOT(minimizeTray()));			//tray icon action minimize to Tray
	connect( restoreFromTray, SIGNAL(triggered()), this, SLOT(restoreTray()));		//tray icon action restore from tray
	
	//context menu----------------------------
	LBtrayMenu	-> addAction(minimizeToTray);
	LBtrayMenu	-> addAction(minimizeToTray);
	LBtrayMenu	-> addSeparator();
	LBtrayMenu	-> addAction(actionAbort);

	//tray icon--------------------------------
	LBtray = new QSystemTrayIcon(QIcon(":/luckyPrefix/luckybackup_96.png"),this);
	LBtray -> setContextMenu(LBtrayMenu);
	if (isMinimizedToTray == TRUE)
	{
		minimizeToTray 	-> setVisible(FALSE);
		restoreFromTray	-> setVisible(TRUE);
	}
	else
	{
		minimizeToTray 	-> setVisible(TRUE);
		restoreFromTray	-> setVisible(FALSE);
	}
	
	//connect(trayIcon, SIGNAL(messageClicked()), this, SLOT(messageClicked()));
	connect(LBtray, SIGNAL(activated(QSystemTrayIcon::ActivationReason)),
		this, SLOT(LBtrayActivated(QSystemTrayIcon::ActivationReason)));
}

// minimizeTray =============================================================================================================================
// minimizes the gui to the tray
void luckyBackupWindow::minimizeTray()
{
	isMinimizedToTray = TRUE;
	minimizeToTray 	-> setVisible(FALSE);
	restoreFromTray	-> setVisible(TRUE);
	this -> hide();
}
// restoreTray =============================================================================================================================
// restores the gui from the tray
void luckyBackupWindow::restoreTray()
{
	isMinimizedToTray = FALSE;
	minimizeToTray 	-> setVisible(TRUE);
	restoreFromTray	-> setVisible(FALSE);
	this -> showNormal();
}
// LBtrayActivated============================================================================================================
// LB tray icon activated SLOT
void luckyBackupWindow::LBtrayActivated(QSystemTrayIcon::ActivationReason reason)
{
	switch (reason)
	{
		case QSystemTrayIcon::Context:
			break;
		case QSystemTrayIcon::Trigger:
			if (isMinimizedToTray == TRUE)
				restoreTray();
			else
				minimizeTray();
			break;
		default:
			;
	}
	
	if (isMinimizedToTray == TRUE)
	{
		minimizeToTray 	-> setVisible(FALSE);
		restoreFromTray	-> setVisible(TRUE);
	}
	else
	{
		minimizeToTray 	-> setVisible(TRUE);
		restoreFromTray	-> setVisible(FALSE);
	}
}
 //executes pre-task commands ===============================================================================================
void luckyBackupWindow::executeBeforeTask()
{
	// logfile actions if real run is performed
	if ( (!DryRun) && (currentBefore == 0) )
	{
				//first remove the older logfiles THIS WILL BE TAKEN OUT WHEN SNAPSHOTS ARE INTRODUCED
				logfilename = logDir + profileName + "-" + Operation[currentOperation] -> GetName() + "-" +
					(( Operation[currentOperation] -> GetLastExecutionTime() ).toString("yyyyMMddhhmmss")) + ".log";
				logfile.setFileName(logfilename); // this is the old logfile
				logfile.remove();
				
		//set the current date and time as the operation's last execution date-time
		Operation[currentOperation] -> SetLastExecutionTime (QDateTime::currentDateTime());
		errorCount = 0;		// task starts, so set this to 0

		logfilename = logDir + profileName + "-" + Operation[currentOperation] -> GetName() + "-" +
			(( Operation[currentOperation] -> GetLastExecutionTime() ).toString("yyyyMMddhhmmss")) + ".log";
		logfile.setFileName(logfilename); // this is the logfile
		if (logfile.open(QIODevice::WriteOnly | QIODevice::Text))	//create a new log file
			writeToLog = TRUE;				//& if it's ok set this to TRUE
		else
			writeToLog = FALSE;
	}

	// execute commands before task -----------------------------------------------------------------------------------------------------
	//if there are no (more) pre-task commands to be executed
	if (Operation[currentOperation] -> GetExecuteBeforeListSize() == currentBefore) 	
	{
		currentBefore = 0;
		ExecuteBefore=FALSE;

		executeRsync();
	}
	else
	{
		ExecuteBefore=TRUE;
		outputInsert = logFileUpdate("pre-starting","",currentBefore);

		ui.rsyncOutput->append(outputInsert);

		syncProcess -> start (Operation[currentOperation] -> GetExecuteBeforeListItem(currentBefore));
//		syncProcess -> waitForFinished();
	}
}

 //executes post-task commands ===============================================================================================
void luckyBackupWindow::executeAfterTask()
{
	// execute commands after task -----------------------------------------------------------------------------------------------------
	//if there are no (more) post-task commands to be executed
	if (Operation[currentOperation] -> GetExecuteAfterListSize() == currentAfter) 	
	{
		if (!DryRun)
			logfile.close();	//close the logfile first (will create a new one for the next task)

		currentAfter = 0;
		ExecuteAfter=FALSE;

		Operation[currentOperation] -> SetLastExecutionErrors (errorCount);
		errorCount = 0;

		currentOperation++;
		//increase currentOperation until next operation to be executed or end of operations
		while ( (currentOperation < TotalOperations) && (!Operation[currentOperation] -> GetPerform()) )
			currentOperation++;
		if (currentOperation < TotalOperations)
			executeBeforeTask();
		else
			setNowDoing();
	}
	else
	{
		ExecuteAfter=TRUE;
		outputInsert = logFileUpdate("post-starting", "", currentAfter);
		ui.rsyncOutput->append(outputInsert);

		syncProcess -> start (Operation[currentOperation] -> GetExecuteAfterListItem(currentAfter));
	}
}

//executes rsync  ===============================================================================================
void luckyBackupWindow::executeRsync()
{
	sync = Operation[currentOperation] -> GetTypeSync();		//set sync variable according to checkstate of radiobutton operation type
	rsyncArguments = AppendArguments(Operation[currentOperation]);	//set rsync arguments

	if (DryRun)
		rsyncArguments.insert(rsyncArguments.size()-2,"--dry-run");

	dirA = rsyncArguments[rsyncArguments.size()-2];
	dirB = rsyncArguments[rsyncArguments.size()-1];
	
	if (sync)	//execute rsync for syncing 2 dirs
	{
		if (syncAB)	//execute rsync A -> B
			syncAB = FALSE;

		else		//execute rsync B -> A
		{
			rsyncArguments.removeLast();
			rsyncArguments.removeLast();
			rsyncArguments.append(dirB);	// set SyncDirA & SyncDirB as Arguments
			rsyncArguments.append(dirA);
			syncAB = TRUE;
		}
	}

	//display a couple of lines to inticate start of task
	if ((sync) && (!syncAB))
		outputInsert = logFileUpdate("rsync-starting-syncAB", "", 0);

	if ((sync) && (syncAB))
		outputInsert = logFileUpdate("rsync-starting-syncBA", "", 0);

	if (!sync)
		outputInsert = logFileUpdate("rsync-starting-backup", "", 0);

	ui.rsyncOutput->append(outputInsert);
	//set the progressbar to 0
	ui.OperationProgress -> setRange(0,100);
	ui.OperationProgress -> setValue (0);

	syncProcess -> start (command,rsyncArguments);	// execute rsync command with rsyncArguments
}

//when rsyncProcess emits finished signal execute another RsyncProcess if any left====================================================================
void luckyBackupWindow::procFinished()
{
	if (!(currentOperation < TotalOperations)) //this is to prevent segmentation fault when abort button pressed (currentOperation=totalOperaions+2)
		return;

	if (ExecuteBefore)		// if the pre-task execution command (process) finished
	{
		outputInsert = logFileUpdate("pre-finished", "", currentBefore);
		ui.rsyncOutput->append(outputInsert);
		currentBefore++; 	//go to the next pre-task execution command 

		executeBeforeTask();	//and executeBeforeTask again
		return;
	}

	if (ExecuteAfter)		// if the post-task execution command (process) finished
	{
		outputInsert = logFileUpdate("post-finished", "", currentAfter);
		ui.rsyncOutput->append(outputInsert);
		currentAfter++; 		//go to the next post-task execution command 

		executeAfterTask();		//and executeAfterTask again
		return;
	}

	//display a couple of lines to indicate end of task
	if ((!sync) || ((sync) && (syncAB)) )
		outputInsert = logFileUpdate("rsync-finished", "", 0);

	else
		outputInsert = logFileUpdate("rsync-finished-sync1", "", 0);
	
	ui.rsyncOutput->append(outputInsert);

	if ( (sync) && (!syncAB) )	//sync A->B is finished. Do the opposite now before proceeding to next included operation or post-task commands
		executeRsync();
	else
		executeAfterTask();	//execute post-task commands (if any)
}

//update dialog with new data (text - progressbar) - also update logfile =======================================================================
void luckyBackupWindow::appendRsyncOutput()
{
	setNowDoing ();		//update Nowdoing textBrowser
	
	//update textBrowser ------------------------------------------------------------------------------------------------------
	QTextCodec *codec = QTextCodec::codecForName("UTF-8");
	outputString = codec->toUnicode(syncProcess -> readAllStandardOutput());
	outputError = codec->toUnicode(syncProcess -> readAllStandardError());

	ui.rsyncOutput->append(outputString);
	logFileUpdate("rsync-standard", outputString, 0);
	
	if (outputError !="")
	{
		errorsFound++;
		errorCount++;
		ui.rsyncOutput->append(logFileUpdate("rsync-error", outputError, 0));
	}
	
	//update progressbar--------------------------------------------------------------------------------------------------------
	bool ok;
	if (outputString.contains("to-check"))	//we will calculate how many files have been proccessed so far
	{
		//DoneToTotal_Ref & DoneToTotal_String hold a e.g. "17/84"
		QStringRef DoneToTotal_Ref = outputString.midRef(outputString.indexOf("check=")+6,outputString.indexOf(")")-outputString.indexOf("check=")-6);
		QString DoneToTotal_String = DoneToTotal_Ref.toString();

		//Total no files
		QStringRef ref_temp = DoneToTotal_String.rightRef(DoneToTotal_String.size() - DoneToTotal_String.indexOf("/") -1);
		QString string_temp = ref_temp.toString();
		progress_total = string_temp.toInt(&ok,10);
		ui.OperationProgress -> setRange(0,progress_total);	//set the range of the progressbar to the no of files to consider

		//No of files processed so far
		ref_temp = DoneToTotal_String.leftRef(DoneToTotal_String.indexOf("/"));
		string_temp = ref_temp.toString();
		progress_done = string_temp.toInt(&ok,10);
		progress_done = progress_total - progress_done;
		ui.OperationProgress -> setValue (progress_done);	//set the current progressbar value 
	}
	if (outputString.contains("speedup is"))	//the process has finished, so if we're back fill it to 100%
	{
		ui.OperationProgress -> setRange(0,100);
		ui.OperationProgress -> setValue (100);
	}
	if (outputString.contains("building file list"))
	{
		calculating = TRUE;
		transfering = FALSE;
		deleting = FALSE;
	}
	if (outputString.contains("files to consider"))
	{
		calculating = FALSE;
		transfering = TRUE;
		deleting = FALSE;
	}
	if (outputString.contains("deleting"))
	{
		calculating = FALSE;
		transfering = FALSE;
		deleting = TRUE;
	}
}

//updates Now Doing textBrowser ===============================================================================================================
void luckyBackupWindow::setNowDoing()
 {
	//calculate elapsed time since all operations start
	QTime DifTime(0,0,0,0);
	int elapsedMsec = StartTime.elapsed();
	DifTime = DifTime.addMSecs(elapsedMsec);
	
	if ( (ExecuteBefore) && (currentOperation < TotalOperations) )
		nowDoingText = 	"<p align=\"center\">"+tr("Elapsed time")+" : <b><font color=red>" + DifTime.toString("hh:mm:ss") +
				"</font></b><br>"+tr("pre-task execution of command")+"	: <b>" +
				Operation[currentOperation] -> GetExecuteBeforeListItem(currentBefore) + "</b>";

	if ( (ExecuteAfter) && (currentOperation < TotalOperations) )
		nowDoingText = 	"<p align=\"center\">"+tr("Elapsed time")+" : <b><font color=red>" + DifTime.toString("hh:mm:ss") +
				"</font></b><br>"+tr("post-task execution of command")+"	: <b>" +
				Operation[currentOperation] -> GetExecuteAfterListItem(currentAfter) + "</b>";

	if ( (sync) && (currentOperation < TotalOperations) && (!ExecuteAfter) && (!ExecuteBefore) )	//if a sync operation is executed
	{
		nowDoingText = 	"<p align=\"center\">"+tr("Elapsed time")+" : <b><font color=red>" + DifTime.toString("hh:mm:ss") +
				"</font></b><br>"+tr("Now performing task")+"	: <b>" + Operation[currentOperation] -> GetName() +
				"</b>";

		if (DryRun)
			nowDoingText.append(" <b><font color=magenta>(" + tr("simulation mode") + ")</font>");

		nowDoingText.append("</p>");
		nowDoingText.append(tr("Directory")+" A	: <b><font color=blue>" + dirA +
				"</font></b><br>"+tr("Directory")+" B	: <b><font color=blue>" + dirB + "</font></b><br>");
		
		if (calculating)
			nowDoingText.append(tr("calculating")+": " + outputString);
		if (transfering)
			nowDoingText.append(tr("transfering files")+": " + outputString);
		if (deleting)
			nowDoingText.append(tr("deleting files")+": " + outputString);
	}

	if ( (!sync) && (currentOperation < TotalOperations) && (!ExecuteAfter) && (!ExecuteBefore) ) //if a backup operation is executed
	{
		nowDoingText = 	"<p align=\"center\">"+tr("Elapsed time")+" : <b><font color=red>" + DifTime.toString("hh:mm:ss") +
				"</font></b><br>"+tr("Now performing task")+"	: <b>" + Operation[currentOperation] -> GetName() +
				"</b>";

		if (DryRun)
			nowDoingText.append(" <b><font color=magenta>(" + tr("simulation mode") + ")</font>");

		nowDoingText.append("</p>");
		nowDoingText.append(tr("Source")+"	: <b><font color=blue>" + dirA +
				"</font></b><br>"+tr("Destination")+"	: <b><font color=blue>" + dirB + "</font></b><br>");

		if (calculating)
			nowDoingText.append(tr("calculating")+": " + outputString);
		if (transfering)
			nowDoingText.append(tr("transfering files")+": " + outputString);
		if (deleting)
			nowDoingText.append(tr("deleting files")+": " + outputString);
	}

	if (currentOperation == TotalOperations)	//if all operations finished
	{
		NOWexecuting = FALSE;		//this is mainly used if the window close button (or alt+F4) is pressed

		nowDoingText = 	"<p align=\"center\">"+tr("Elapsed time")+" : <b><font color=red>" + DifTime.toString("hh:mm:ss") +
				"</font></b><br>====================================================="
				"<b><br><font color=blue>"+tr("All tasks completed")+" </font></b>";
		trayMessage =	tr("All tasks completed");
		if (DryRun)
		{
			nowDoingText.append(" <b><font color=magenta>(" + tr("simulation mode") + ")</b></font>");
			trayMessage.append(" (" + tr("simulation mode") + ")");
		}
		if (errorsFound == 0)
		{
			nowDoingText.append("<br><font color=green>" + tr("No errors found") + "</font><br>");
			trayMessage.append("\n" + tr("No errors found"));
		}
		else
		{
			nowDoingText.append("<br><font color=green>" + tr("errors found") + ": " + countStr.setNum(errorsFound) +"</font><br>");
			trayMessage.append("\n" + tr("errors found"));

			// initialize jump to next error button 
			firstScroll=TRUE;
			errorCount = 0;
			ui.pushButton_nextError	-> setEnabled (TRUE);
		}
		if (!DryRun)
			nowDoingText.append(tr("logfile(s) have been created under directory: ")+ logDir +"<br>");
		nowDoingText.append("=====================================================</p>");
		ui.AbortButton -> setText (tr("Done"));
		ui.AbortButton -> setIcon(QIcon(":/luckyPrefix/okay.png"));
		
		//update tray baloon
		if ( (QSystemTrayIcon::isSystemTrayAvailable ()) && (QSystemTrayIcon::supportsMessages ()) )
		{
			LBtray -> showMessage (appName + " - " + tr("execution of profile:") + " " + profileName + " " + tr("finished") , trayMessage, 
													QSystemTrayIcon::Information,3000);
			actionAbort	-> setVisible(FALSE);
		}

		if (!DryRun)
		{
			//save the profile to update last execution times & no oferrors
			if (!saveProfile(currentProfile))
				savedProfile = FALSE;
			else
				savedProfile = TRUE;			//change profile status to "saved"
			
			logfile.close();			// close the logfile
		}
		
		if ( (silentMode) && (isMinimizedToTray == TRUE) )		// if --silent is given as argument and the gui is not shown exit the app
		{
			//delay the app exit for 3 seconds
			QTime StartSleep(0,0,0,0);
			StartSleep.start();
			int elapsedSleepMsec = 0;

			while (elapsedSleepMsec < 3000)
				elapsedSleepMsec = StartSleep.elapsed();
			
			exit(0);	//quit
		}
	}
	if (currentOperation == TotalOperations+2)	//if operations were terminated by user
	{
		NOWexecuting = FALSE;		//this is mainly used if the window close button (or alt+F4) is pressed
		nowDoingText = 	"<p align=\"center\">"+tr("Elapsed time")+" : <b><font color=red>" + DifTime.toString("hh:mm:ss") +
				"</font></b><br>====================================================="
				"<br><b><font color=blue>"+tr("Execution of tasks were terminated violently by user")+"</font></b><br>";
		trayMessage = 	tr("Execution of tasks were terminated violently by user");
		
		if (!DryRun)
			nowDoingText.append(tr("logfile(s) have been created under directory: ")+ logDir +"<br>");
		nowDoingText.append("=====================================================</p>");
		ui.AbortButton -> setText (tr("Done"));
		ui.AbortButton -> setIcon(QIcon(":/luckyPrefix/okay.png"));
		
		//update tray baloon
		if ( (QSystemTrayIcon::isSystemTrayAvailable ()) && (QSystemTrayIcon::supportsMessages ()) )
		{
			LBtray -> showMessage (appName + " - " + tr("execution of profile:") + " " + profileName + " " + tr("finished") , trayMessage, 
															QSystemTrayIcon::Information,3000);
			actionAbort	-> setVisible(FALSE);
		}

		if  (errorsFound > 0)// initialize jump to next error button 
		{
			firstScroll=TRUE;
			ui.pushButton_nextError	-> setEnabled (TRUE);
		}

		if (!DryRun)
		{
			//save the profile to update last execution times & no oferrors
			if (!saveProfile(currentProfile))
				savedProfile = FALSE;
			else
				savedProfile = TRUE;			//change profile status to "saved"
				
			logfile.close();			// close the logfile
		}
		
		if ( (silentMode) && (isMinimizedToTray == TRUE) )		// if --silent is given as argument and the gui is not shown, exit the app
			exit(0);	//quit
	}
	ui.nowDoing -> setText (nowDoingText);
 }

// previous error button pressed=====================================================================================================
void luckyBackupWindow::previousErrorJump()
{
	errorCount--;		//decrease the current error by one

	if (errorCount == 0 )		// if the current error is the first within the logfile disable the previous button
		ui.pushButton_previousError -> setEnabled(FALSE);
	
	if (errorCount < errorsFound-1)	//if the current error is less than the last one within the logfile enable the next button
		ui.pushButton_nextError -> setEnabled(TRUE);
	
	ui.rsyncOutput -> scrollToAnchor("error" + countStr.setNum(errorCount+1));
}

// next error button pressed=====================================================================================================
void luckyBackupWindow::nextErrorJump()
{
	if (!firstScroll)
		errorCount++;	// increase the current error by one
	firstScroll = FALSE;
	
	if (errorCount == errorsFound-1)		// If the current error is the last within the logfile disable the next button
		ui.pushButton_nextError -> setEnabled(FALSE);
	
	if (errorCount > 0)				// if the current error is greater than the first one within the logfile enable the previous button
		ui.pushButton_previousError -> setEnabled(TRUE);
	
	ui.rsyncOutput -> scrollToAnchor("error" + countStr.setNum(errorCount+1));
}
// end of executenow.cpp ---------------------------------------------------------------------------

