#!/bin/bash

DIR=$(dirname $0)

tests=( $DIR/test_kernel_data_trace $DIR/test_sessions $DIR/test_ust_data_trace \
		$DIR/streaming/runall $DIR/health/runall $DIR/filtering/runall)

exit_code=0

function start_tests ()
{
    for bin in ${tests[@]};
    do
		if [ ! -e $bin ]; then
			echo -e "$bin not found, passing"
			continue
		fi

        ./$bin
        # Test must return 0 to pass.
        if [ $? -ne 0 ]; then
            exit_code=1
            break
        fi
    done
}

start_tests

exit $exit_code
