#!/usr/bin/perl -w

#$Header: /home2/cvsroot/LogTrend/Visu/Zone/Graph.pm,v 1.52 2002/01/04 13:53:14 slhullier Exp $
##******************************************************************************
## Class Graph  isa Zone
##  Description  : class from which inherit (Bar|Line)Graph
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Christophe Najar c.najar@atrid.fr
##  Author       : Sylvain Lhullier s.lhullier@atrid.fr
##******************************************************************************
#$Log: Graph.pm,v $
#Revision 1.52  2002/01/04 13:53:14  slhullier
#Attribute Kilo of tag *Graph
#
#Revision 1.51  2001/12/07 09:16:34  slhullier
#TooBigGap attribute
#
#Revision 1.50  2001/11/19 12:55:50  slhullier
#Accent bug fixed at all ...
#
#Revision 1.49  2001/11/19 10:56:54  slhullier
#little bit stable, before big modification
#
#Revision 1.48  2001/11/16 16:45:01  slhullier
#Text color format
#
#Revision 1.47  2001/11/15 16:08:57  slhullier
#UserNode managing first version (still bugs)
#
#Revision 1.46  2001/11/14 15:59:45  slhullier
#No more global value for SystemsDeclaration
#
#Revision 1.45  2001/11/12 10:03:00  slhullier
#no more tab
#
#Revision 1.44  2001/11/09 13:42:42  slhullier
#Duration/Interval/StartStop modification
#
#Revision 1.43  2001/10/29 15:45:19  lsimonneau
#Add absolute date support for graph andReport/AlarmLog
#
#Revision 1.42  2001/10/29 12:54:32  lsimonneau
#Remove GD deps.
#
#Revision 1.41  2001/10/26 13:30:07  lsimonneau
#Minor bugfixes.
#
#Revision 1.40  2001/10/26 13:16:12  lsimonneau
#Add "last month" and "current month" to Duration possible values.
#Type is now deprecated for AlarmLog and AverageGraph.
#
#Revision 1.39  2001/10/23 12:18:37  lsimonneau
#Now, LogTrend::Visu::Zone contains generic classes for Report/Web Zone.
#
#Revision 1.38  2001/10/19 13:55:50  slhullier
#duration dug
#
#Revision 1.37  2001/10/05 11:11:09  slhullier
#Some french texts to english
#
#Revision 1.36  2001/10/02 08:29:22  lsimonneau
#*** empty log message ***
#
#Revision 1.35  2001/10/02 08:18:35  lsimonneau
#Minor Bugfixes.
#
#Revision 1.34  2001/09/25 08:07:22  slhullier
#Text changing
#
#Revision 1.33  2001/09/18 15:11:03  slhullier
#no link for save
#
#Revision 1.32  2001/09/18 08:09:17  slhullier
#Using GetDataInRelativeTimeInterval
#
#Revision 1.31  2001/09/17 13:19:53  slhullier
#
#values rounded
#
#Revision 1.30  2001/09/05 09:00:22  slhullier
#
#LabelsPerLine done
#
#Revision 1.29  2001/09/05 08:13:10  lsimonneau
#Addo margins to top and bottom of the LineGraph.
#
#Revision 1.28  2001/08/22 08:36:24  slhullier
#
#Zoom modifications
#
#Revision 1.27  2001/08/21 09:11:18  slhullier
#
#Correct negativ values printing
#
#Revision 1.26  2001/08/21 08:45:07  slhullier
#
#Colors personnalisable + dial mis en place
#
#Revision 1.25  2001/08/17 13:32:43  slhullier
#
#Correct accents for pictures/HTML Perl 5.005/5.6
#
#Revision 1.24  2001/08/17 09:29:35  slhullier
#
#Zoom navigation work for value-boundaries not set
#
#Revision 1.23  2001/08/14 15:13:10  slhullier
#
#Lovely pictures for zoom navigation.
#
#Revision 1.22  2001/08/14 14:25:22  slhullier
#
#Graph zoom : navigation is possible
#
#Revision 1.21  2001/07/31 07:34:51  slhullier
#
#new Image tested + delete toString
#
#Revision 1.20  2001/07/30 15:00:45  slhullier
#
#Arithmetic expressions are parsed.
#
#Revision 1.19  2001/07/26 14:50:21  slhullier
#
#Zoom on Graph works
#
#Revision 1.18  2001/06/29 13:18:50  slhullier
#
#Petite retouches avant premiere version 'stable'
#
#Revision 1.17  2001/06/28 15:12:24  slhullier
#
#Die->die
#
#Revision 1.16  2001/06/26 10:00:12  slhullier
#
#Heritage BarGraph LineGraph
#
#Revision 1.15  2001/06/26 08:58:54  slhullier
#
#BarGraph ok. Avant fusion Graph/BarGraph avec heritage
#
#Revision 1.14  2001/06/25 16:52:23  slhullier
#
#Multi process
#
#Revision 1.13  2001/06/25 11:14:40  slhullier
#
#Customisation ...
#
#Revision 1.12  2001/06/25 08:03:30  slhullier
#
#Utilisation de Graduation + affichage des dates bornes
#
#Revision 1.11  2001/06/22 15:24:49  slhullier
#
#Graph personalisable : le debut
#
#Revision 1.10  2001/06/21 16:57:14  slhullier
#
#Ajout de liens, capture d'ecran effectuee ...
#
#Revision 1.9  2001/06/20 14:22:10  slhullier
#*** empty log message ***
#
#Revision 1.8  2001/06/20 10:02:05  slhullier
#
#Bug, pour Laurent
#
#Revision 1.7  2001/06/19 16:23:53  slhullier
#
#Les graphs fonctionnent dans la visu (encore 1 petit pb de nom de variable)
#
#Revision 1.6  2001/06/18 16:12:44  slhullier
#
#Plein de choses fixees   A faire : Link, Led
#
#Revision 1.5  2001/06/15 07:17:16  slhullier
#
#Ajout de $ pour CVS
#

package LogTrend::Visu::Zone::Graph;

use strict;

use POSIX qw(strftime);
use Time::Local;

use LogTrend::Common::Duration;
use LogTrend::Visu::Utils;
use LogTrend::Visu::TimeUtils;
use LogTrend::Visu::Zone;
use LogTrend::Visu::Request;
use LogTrend::Visu::Response;
use LogTrend::Visu::Constants;

use vars qw( @ISA );
@ISA = ("LogTrend::Visu::Zone");

##******************************************************************************
## Constructor  public
##  Description  : creat a new Graph object
##  Parameters   : the Type XML node, the Zone XML node
##******************************************************************************
sub new
{
   my ($classname,$rootnode,$realrootnode,$systemsDeclaration) = @_;
   my $self = $classname->SUPER::new($rootnode,$realrootnode,$systemsDeclaration);
   bless($self, $classname);

   $self->parseXML($rootnode, $realrootnode);

   ##===========================================================================
   return $self;
}


##******************************************************************************
## parseXML  protected
##  Description  : parse bar graph specific xml entry
##  Parameters   :
##******************************************************************************
sub parseXML {
   my ($self, $rootnode,$realrootnode) = @_;
   my ($list,$node,$attributes,$attrnode);

   ##===========================================================================
   ## Graph tag
   ##===========================================================================
   $self->{PIXELHEIGHT} = 210;
   $attributes = $rootnode->getAttributes() || die("Error in \"Graph\".");
   $attrnode = $attributes->getNamedItem("PixelHeight");
   if( defined( $attrnode ) )
   {  $self->{PIXELHEIGHT} = AccentsXML2Text( $attrnode->getValue() ); }

   $attrnode = $attributes->getNamedItem("LabelsPerLine");
   if( defined( $attrnode ) )
   {  $self->{LABELSPERLINE} = AccentsXML2Text( $attrnode->getValue() ); }

   $self->{KILO} = 1024;
   $attrnode = $attributes->getNamedItem("Kilo");
   if( defined( $attrnode ) )
   {
      my $k = AccentsXML2Text( $attrnode->getValue() );
      if( $k == 1000 or $k == 1024 )
      {
         $self->{KILO} = $k;
      }
   }

   ##===========================================================================
   ## X tag
   ##===========================================================================
   $list = $rootnode->getElementsByTagName("X") || die("Graph: No \"X\" tag.");
   $node = $list->item(0) || die("Graph: No \"X\" tag.");
   $attributes = $node->getAttributes() || die("Error in \"X\" tag.");

   ##---------------------------------------------------------------------------
   if( defined( $attrnode = $attributes->getNamedItem("Duration") ) )
   {
      $self->{ORIGINAL_START} = Duration( $attrnode->getValue() );
      $self->{ORIGINAL_STOP}  = 0;
      $self->{USE_ABSOLUTE_DATE} = 0;
   }
   ##---------------------------------------------------------------------------
   elsif( defined( $attrnode = $attributes->getNamedItem("Interval") ) )
   {
      ($self->{ORIGINAL_START},$self->{ORIGINAL_STOP}) =
         TimeInterval( $attrnode->getValue() );
      $self->{USE_ABSOLUTE_DATE} = 1;
   }
   ##---------------------------------------------------------------------------
   else
   {
      $attrnode = $attributes->getNamedItem("Start") or
         die("No 'Start' field in \"X\" tag.");
      my $start_val = AccentsXML2Text( $attrnode->getValue() );

      $attrnode = $attributes->getNamedItem("Stop") or
         die("No 'Stop' field in \"X\" tag.");
      my $stop_val = AccentsXML2Text( $attrnode->getValue() );

      ($self->{ORIGINAL_START},$self->{ORIGINAL_STOP},$self->{USE_ABSOLUTE_DATE}) =
         StartStop( $start_val, $stop_val );
   }

   ##---------------------------------------------------------------------------
   $attrnode = $attributes->getNamedItem("Graduation");
   if( defined( $attrnode ) )
   { $self->{X_GRADUATION} = Duration( $attrnode->getValue() ); }

   ##---------------------------------------------------------------------------
   $attrnode = $attributes->getNamedItem("TooBigGap");
   if( defined( $attrnode ) )
   { $self->{X_TOOBIGGAP} = Duration( $attrnode->getValue() ); }
   else
   { $self->{X_TOOBIGGAP} = Duration("1h"); }

   ##===========================================================================
   ## Y tag
   ##===========================================================================
   $self->{Y_LOWERBOUNDARY} = 0;
   $list = $rootnode->getElementsByTagName("Y");
   $node = $list->item(0);
   if( defined($node) )
   {
      $attributes = $node->getAttributes() || die("Error in \"Y\".");

      ##------------------------------------------------------------------------
      $attrnode = $attributes->getNamedItem("Graduation");
      if( defined( $attrnode ) )
      {  $self->{Y_GRADUATION} = AccentsXML2Text( $attrnode->getValue() ); }

      ##------------------------------------------------------------------------
      $attrnode = $attributes->getNamedItem("LowerBoundary");
      if( defined( $attrnode ) )
      {  $self->{ORIGINAL_Y_LOWERBOUNDARY} = AccentsXML2Text( $attrnode->getValue() ); }
      # default = 0

      ##------------------------------------------------------------------------
      $attrnode = $attributes->getNamedItem("UpperBoundary");
      if( defined( $attrnode ) )
      {  $self->{ORIGINAL_Y_UPPERBOUNDARY} = AccentsXML2Text( $attrnode->getValue() ); }
   }

   ##===========================================================================
   ## Colors tag
   ##===========================================================================
   $list = $rootnode->getElementsByTagName("Colors");
   $node = $list->item(0);
   my @pictureBGColor = RGBtoInt( $self->{SYSTEMSDECLARATION}->getColor('BackGround') );
   my @graphBGColor   = (208,208,208);
   my @gridColor      = (128,128,128);
   my @textColor      = RGBtoInt( $self->{SYSTEMSDECLARATION}->getColor('Text') );

   if( defined($node) )
   {
      $attributes = $node->getAttributes() || die("Error in \"Colors\".");

      ##------------------------------------------------------------------------
      $attrnode = $attributes->getNamedItem("PictureBG");
      if( defined( $attrnode ) )
      { @pictureBGColor = RGBtoInt( TextToRGB( $attrnode->getValue() ) ); }

      ##------------------------------------------------------------------------
      $attrnode = $attributes->getNamedItem("GraphBG");
      if( defined( $attrnode ) )
      { @graphBGColor = RGBtoInt( TextToRGB( $attrnode->getValue() ) ); }

      ##------------------------------------------------------------------------
      $attrnode = $attributes->getNamedItem("Grid");
      if( defined( $attrnode ) )
      { @gridColor = RGBtoInt( TextToRGB( $attrnode->getValue() ) ); }

      ##------------------------------------------------------------------------
      $attrnode = $attributes->getNamedItem("Text");
      if( defined( $attrnode ) )
      { @textColor = RGBtoInt( TextToRGB( $attrnode->getValue() ) ); }

   }

   $self->{PICTUREBGCOLOR} = \@pictureBGColor;
   $self->{GRAPHBGCOLOR}   = \@graphBGColor;
   $self->{GRIDCOLOR}      = \@gridColor;
   $self->{TEXTCOLOR}      = \@textColor;
}

##******************************************************************************
## Method evalExpression protected
##  Description  : eval expression and return data
##  Parameters   : a Request
##  Return value : a Response
##******************************************************************************
sub evalExpression
{
    my ($self, $start, $stop) = @_;

    my $expressions = $self->{EXPRESSIONS};
    my $expressionsNb = @$expressions;

    my %data;

    for( my $e=0; $e<$expressionsNb; $e++ )
    {
        ##------------------------------------------------------------------------
        ## Getting data
        ##------------------------------------------------------------------------
        my $expr = $expressions->[$e];
        my $varName = $expr->label();
        if( $self->{USE_ABSOLUTE_DATE} == 0) {

            $data{$varName} = $expr->evalInTimeInterval( 100000,
                                                         $start, $stop );
        }
        else {
            $data{$varName} = $expr->evalInAbsoluteTimeInterval( 100000,
                                                                 $start, $stop );
        }

    }

    return \%data;
}

##******************************************************************************
## Method expressionColors protected
##  Description  : Return a hash of expression colors
##  Parameters   : a Request
##  Return value : a Response
##******************************************************************************
sub expressionColors
{
    my ($self) = @_;

    my $expressions = $self->{EXPRESSIONS};
    my $expressionsNb = @$expressions;

    my %colors;

    for( my $e=0; $e<$expressionsNb; $e++ )
    {
        ##------------------------------------------------------------------------
        ## Getting data
        ##------------------------------------------------------------------------
        my $expr = $expressions->[$e];
        my $varName = $expr->label();
        $colors{$varName} = $expr->color;

    }

    return \%colors;
}


##******************************************************************************
## Method treat public
##  Description  : execute request
##  Parameters   : a Request
##  Return value : a Response
##******************************************************************************
#  sub treat
#  {
#  }


##******************************************************************************
## Method generatePicture protected
##  Description  : create the picture, should be called by treat
##  Parameters   :
##  Return value :
##******************************************************************************
#  sub generatePicture
#  {
#  }


##******************************************************************************
1;
