#!/usr/bin/perl -w

#$Header: /home2/cvsroot/LogTrend/Visu/Web/Zone/TextArea.pm,v 1.6 2002/01/02 10:04:15 slhullier Exp $
##******************************************************************************
## Class TextArea  isa Zone
##  Description  : class for printing messages
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Sylvain Lhullier s.lhullier@atrid.fr
##******************************************************************************
#$Log: TextArea.pm,v $
#Revision 1.6  2002/01/02 10:04:15  slhullier
#PercentRound bug 2
#
#Revision 1.5  2002/01/02 09:50:31  slhullier
#PercentRound bug
#
#Revision 1.4  2001/11/19 12:55:50  slhullier
#Accent bug fixed at all ...
#
#Revision 1.3  2001/11/19 10:56:54  slhullier
#little bit stable, before big modification
#
#Revision 1.2  2001/11/14 15:59:45  slhullier
#No more global value for SystemsDeclaration
#
#Revision 1.1  2001/10/24 09:02:56  lsimonneau
#Remove Web or Report Prefix from Zone files.
#
#Revision 1.1  2001/10/23 12:19:39  lsimonneau
#Add Web Zone implementation.
#
#Revision 1.12  2001/09/18 09:02:31  slhullier
#Bug correction : percentage & 0 values
#
#Revision 1.11  2001/09/18 08:09:17  slhullier
#Using GetDataInRelativeTimeInterval
#
#Revision 1.10  2001/09/07 13:22:17  lsimonneau
#Add support of URL like http://myserver.com/LogTrendVisu/MyClientName/TheNetwork/
#
#Revision 1.9  2001/08/17 13:32:43  slhullier
#
#Correct accents for pictures/HTML Perl 5.005/5.6
#
#Revision 1.8  2001/08/09 12:48:54  slhullier
#
#TextArea : percentage
#
#Revision 1.7  2001/07/31 07:34:51  slhullier
#
#new Image tested + delete toString
#
#Revision 1.6  2001/07/30 15:00:45  slhullier
#
#Arithmetic expressions are parsed.
#
#Revision 1.5  2001/06/28 15:12:24  slhullier
#
#Die->die
#
#Revision 1.4  2001/06/18 16:12:44  slhullier
#
#Plein de choses fixees   A faire : Link, Led
#
#Revision 1.3  2001/06/15 15:13:23  slhullier
#
#Mise en page dans les tableaux
#
#Revision 1.2  2001/06/15 07:17:16  slhullier
#
#Ajout de $ pour CVS
#

package LogTrend::Visu::Web::Zone::TextArea;

use strict;

use LogTrend::Common::Duration;
use LogTrend::Visu::Zone;
use LogTrend::Visu::Request;
use LogTrend::Visu::Response;
use LogTrend::Visu::Utils;

use vars qw( @ISA );
@ISA = ("LogTrend::Visu::Zone");

##******************************************************************************
## Constructor  public
##  Description  : creat a new TextArea object
##  Parameters   : the Zone XML node
##******************************************************************************
sub new
{
   my ($classname,$rootnode,$realrootnode,$systemsDeclaration) = @_;
   my $self = $classname->SUPER::new($rootnode,$realrootnode,$systemsDeclaration);
   bless($self, $classname);

   my ($list,$node,$attributes,$attrnode);

   $self->{LINES} = 1;
   $attributes = $rootnode->getAttributes() || die("Error in \"TextArea\".");
   $attrnode = $attributes->getNamedItem("Lines");
   if( defined( $attrnode ) )
   {  $self->{LINES} = AccentsXML2Text( $attrnode->getValue() ); }

   $attributes = $rootnode->getAttributes() || die("Error in \"TextArea\".");
   $attrnode = $attributes->getNamedItem("PercentRound");
   if( defined( $attrnode ) )
   {
      my $val = AccentsXML2Text( $attrnode->getValue() );
      $self->{PERCENTROUND} = $val if( $val >= 0 );
   }

   return $self;
}

##******************************************************************************
## Method percent  private
##******************************************************************************
sub percent
{
   my ($self,$v) = @_;
   my $p;
   if( defined( $self->{PERCENTROUND} ) )
   {
       $p = $self->{PERCENTROUND} * int( 100 * $v / $self->{PERCENTROUND} );
       $p .= ' %';
   }
   else
   {
       $p = $v;
   }
   return $p;
}

##******************************************************************************
## Method treat  public >Zone
##  Description  : treat a request
##  Parameters   : a Request
##  Return value : a Response
##******************************************************************************
sub treat
{
   my ($self,$request) = @_;
   my $response = new LogTrend::Visu::Response();

   $response->contentType("text/html");
   $response->print("      $self->{TITLE}<BR>\n") if( $self->{TITLE} ne " " );

   ##===========================================================================
   ## For each expression
   ##===========================================================================
   my $expressions = $self->{EXPRESSIONS};
   foreach my $expr (@$expressions)
   {
      my $time = time();

      if($self->{LINES} == 1)
      {
          my $r = $expr->evalLast();
          if( !defined( $r ) )
          {
              $response->print( "      no data\n" );
          }
          else
          {
              my $p = $self->percent( $r );
              $response->print( "      $p<BR>\n" );
          }
      }
      else
      {
          my $r = $expr->evalInTimeInterval( $self->{LINES}, Duration("1w"), 0 );

          if( $r eq "0" )
          {
              $response->print( "      no data\n" );
          }
          else
          {
              foreach my $data (@$r)
              {
                  my $p = $self->percent( $$data[0] );
                  $response->print( "      $p<BR>\n" );
              }
          }
      }
  }

   return $response;
}

##******************************************************************************
1;
