#!/usr/bin/perl -w

#$Header: /home2/cvsroot/LogTrend/Visu/Web/Zone/GraphPlugin/CSV.pm,v 1.2 2001/12/28 16:32:48 slhullier Exp $
##******************************************************************************
## Class GraphPlugin  abstract
##  Description  : class from which inherit plugins to export data
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Sylvain Lhullier s.lhullier@atrid.fr
##******************************************************************************
#$Log: CSV.pm,v $
#Revision 1.2  2001/12/28 16:32:48  slhullier
#Graph extractor plugin engine works
#
#Revision 1.1  2001/12/27 17:10:25  slhullier
#Plugins 1st step
#

package LogTrend::Visu::Web::Zone::GraphPlugin::CSV;

use strict;
use POSIX qw(strftime);
use LogTrend::Visu::Response;
use LogTrend::Visu::Web::Zone::GraphPlugin;

use vars qw( @ISA );
@ISA = ("LogTrend::Visu::Web::Zone::GraphPlugin");

##******************************************************************************
## Constructor  public
##  Parameters   : none
##******************************************************************************
sub new
{
   my ($classname,$rootnode,$systemsDeclaration) = @_;
   my $self = $classname->SUPER::new( "CVS / Comma-Separated-Values",
                                      "cvs" );
   bless($self, $classname);
   return $self;
}

##******************************************************************************
## Method export  public  > GraphPlugin
##  Description  : treat a request
##  Parameters   : a reference to a hash table containing the data,
##                 a reference to the list containing the expressions name,
##                 the title of the graph
##  Return value : a Response object
##******************************************************************************
sub export
{
   my ($self,$data,$expressions,$title) = @_;
   my $response = new LogTrend::Visu::Response();
   $response->contentType("text/comma-separated-values");

   ## Order the values
   my @labels = map( {$_->label()} @$expressions );
   my $dates = $self->orderDataByDates( $data );

   ## Print the values
   use locale;  # For the time format

   $response->print( "Date1, Date2" );
   foreach my $e (@labels)
   {
      $response->print( ", $e" );
   }
   $response->print( "\n" );
   foreach my $d ( sort( {$a<=>$b} keys(%$dates) ) )
   {
      $response->print( "$d, " );
      $response->print( strftime('%c', localtime($d) ) );
      foreach my $e (@labels)
      {
         $response->print( ", " );
         if( exists($dates->{$d}->{$e}) )
         {
            $response->print( "$dates->{$d}->{$e}" );
         }

      }
      $response->print( "\n" );
   }

   ##===========================================================================
   $response->fileName( $self->getFileName( $title ) );
   return $response;
}

##******************************************************************************
1;
