#!/usr/bin/perl -w

#$Header: /home2/cvsroot/LogTrend/Visu/Web/Zone/GraphPlugin.pm,v 1.3 2002/01/02 09:50:31 slhullier Exp $
##******************************************************************************
## Class GraphPlugin  abstract
##  Description  : class from which inherit plugins to export data
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Sylvain Lhullier s.lhullier@atrid.fr
##******************************************************************************
#$Log: GraphPlugin.pm,v $
#Revision 1.3  2002/01/02 09:50:31  slhullier
#PercentRound bug
#
#Revision 1.2  2001/12/28 16:32:48  slhullier
#Graph extractor plugin engine works
#
#Revision 1.1  2001/12/27 17:10:25  slhullier
#Plugins 1st step
#

package LogTrend::Visu::Web::Zone::GraphPlugin;

use strict;
use Error qw(:try);
use UNIVERSAL qw(isa);
use LogTrend::Visu::Response;

##******************************************************************************
## Constructor  public
##  Parameters   : the name of the plugin,
##                 the most used extention for this format
##******************************************************************************
sub new
{
   my ($classname,$name,$extention) = @_;
   my $self = {};
   bless($self, $classname);
   $self->{NAME} = $name;
   $self->{EXTENTION} = $extention;
   return $self;
}

##******************************************************************************
## Method export  public   TO BE WRITEN IN REAL EXPORTERS
##  Description  : treat a request
##  Parameters   : a reference to a hash table containing the data,
##                 a reference to the list containing the expressions name,
##                 the title of the graph
##  Return value : a Response object
##******************************************************************************
#sub export
#{
#
#}

##******************************************************************************
## Methods get*  public
## Return value :
##  getName      : the name of the plugin
##  getExtention : the most used extention for this format
##******************************************************************************
sub getName      { return $_[0]->{NAME}; }
sub getExtention { return $_[0]->{EXTENTION}; }

##******************************************************************************
## Method orderDataByDates  protected
##  Description  : create hash table referencing data by dates
##  Parameters   : a reference to the data hash table
##  Return value : a reference to the new hash table
##******************************************************************************
sub orderDataByDates
{
   my ($self,$data) = @_;
   my %dates = ();
   foreach my $e (keys %$data)
   {
       next if( $data->{$e} eq "0" );
       foreach my $d (@{$data->{$e}})
       {
          if( ! exists( $dates{$d->[1]} ) )
          {
             $dates{$d->[1]} = {};
          }
          $dates{$d->[1]}->{$e} = $d->[0];
       }
   }
   return \%dates;
}

##******************************************************************************
## Method getFileName  protected
##  Description  : return the standard filename
##  Parameters   : the title of the graph
##******************************************************************************
sub getFileName
{
   my ($self,$title) = @_;
   $title =~ tr/A-Z/a-z/;
   $title =~ s/\W/_/g;
   $title .= ".".$self->getExtention();
   return $title;
}

##******************************************************************************
## Class-method availableExporters  public
##  Description  : returns the list of available exporters
##  Parameters   : none
##  Return value : a hash table
##******************************************************************************
sub availableExporters
{
   my ($class) = @_;
   my %hash = ();
   INC: foreach my $i (@INC)
   {
      my $dir = "$i/LogTrend/Visu/Web/Zone/GraphPlugin";
      next INC  if( ! -d $dir );
      GLOB: foreach my $e (glob("$dir/*.pm"))
      {
         $e =~ s:$i/(.*)\.pm$:$1:;
         $e =~ s|/|::|g;

         my $name;
         try
         {
            die( $! )  if( ! eval "require $e" );
            $e->import();
            my $exporter = $e->new();
            die("") if( !isa( $exporter, 'LogTrend::Visu::Web::Zone::GraphPlugin' ) );
            my $response = $exporter->export({},[]);
            die("") if( !isa( $response, 'LogTrend::Visu::Response' ) );
            $name = $exporter->getName() or die("");
         }
         otherwise
         {
            next GLOB; # Not a good exporter
         };  # ; very important

         $e =~ s/.*::(.*)/$1/;
         $hash{$e} = $name;
      }
   }
   return %hash;
}

##******************************************************************************
## Class-method getExporterFullName  public
##******************************************************************************
sub getExporterFullName
{
   my ($class,$module) = @_;
   return "LogTrend::Visu::Web::Zone::GraphPlugin::$module";
}

##******************************************************************************
1;
