#!/usr/bin/perl -w

#$Header: /home2/cvsroot/LogTrend/Visu/Web/Zone/AverageGraph.pm,v 1.5 2001/11/20 08:54:24 lsimonneau Exp $
##******************************************************************************
## Class WebGraph  isa Zone
##  Description  : class from which inherit Web(Bar|Line)Graph
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Laurent Simonneai l.simonneau@atrid.fr
##******************************************************************************
#$Log: AverageGraph.pm,v $
#Revision 1.5  2001/11/20 08:54:24  lsimonneau
#*** empty log message ***
#
#Revision 1.4  2001/11/19 12:55:50  slhullier
#Accent bug fixed at all ...
#
#Revision 1.3  2001/11/14 15:59:45  slhullier
#No more global value for SystemsDeclaration
#
#Revision 1.2  2001/10/26 09:29:01  lsimonneau
#Minor bugfixes with graph colors.
#
#Revision 1.1  2001/10/24 09:02:56  lsimonneau
#Remove Web or Report Prefix from Zone files.
#
#Revision 1.1  2001/10/23 12:19:39  lsimonneau
#Add Web Zone implementation.
#

package LogTrend::Visu::Web::Zone::AverageGraph;

use strict;

use POSIX qw(strftime tmpnam);

use LogTrend::Common::Duration;
use LogTrend::Visu::Utils;
use LogTrend::Visu::Request;
use LogTrend::Visu::Response;
use LogTrend::Visu::Constants;
use LogTrend::Visu::Web::Zone::LineGraph;
use LogTrend::Visu::Zone::AverageGraph;

use vars qw( @ISA );
@ISA = ("LogTrend::Visu::Zone::AverageGraph", "LogTrend::Visu::Web::Zone::LineGraph");

##******************************************************************************
## Constructor  public
##  Description  : creat a new Graph object
##  Parameters   : the Type XML node, the Zone XML node
##******************************************************************************
sub new
{
   my ($classname,$rootnode,$realrootnode,$systemsDeclaration) = @_;
   my $self = $classname->SUPER::new($rootnode,$realrootnode,$systemsDeclaration);

   bless($self, $classname);

   return $self;
}

##******************************************************************************
## Method colorDeclaration  protected >Graph
##  Description  : declare specific colors for picture
##  Parameters   : the image
##  Return value : a reference on an hash-table
##******************************************************************************
sub colorDeclaration
{
   my ($self,$image) = @_;

   my %colors;
   $colors{0} = $image->colorAllocate(255,  0,  0); #red
   $colors{1} = $image->colorAllocate(  0,192,  0); #green
   $colors{2} = $image->colorAllocate(  0,  0,255); #blue

   $colors{nb} = 3;

   return \%colors;

}

##******************************************************************************
1;
