#!/usr/bin/perl -w

#$Header: /home2/cvsroot/LogTrend/Visu/Web/UserNode.pm,v 1.3 2001/11/26 15:52:31 slhullier Exp $
##******************************************************************************
## Class UserNode  isa ArchitectureNode
##  Description  : class for a user network.xml file
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Sylvain Lhullier s.lhullier@atrid.fr
##******************************************************************************
#$Log: UserNode.pm,v $
#Revision 1.3  2001/11/26 15:52:31  slhullier
#User inclusion for admin user seems to be ok
#
#Revision 1.2  2001/11/16 16:45:01  slhullier
#Text color format
#
#Revision 1.1  2001/11/15 16:08:57  slhullier
#UserNode managing first version (still bugs)
#

package LogTrend::Visu::Web::UserNode;

use strict;

use LogTrend::Visu::ArchitectureNode;
use LogTrend::Visu::Utils;
use LogTrend::Visu::Web::MessageNode;
use LogTrend::Visu::Web::NetworkNode;
use LogTrend::Visu::Web::SystemsDeclaration;

use vars qw( @ISA );
@ISA = ("LogTrend::Visu::Web::NetworkNode", "LogTrend::Visu::Web::SystemsDeclaration" );

##******************************************************************************
## Constructor  public
##  Parameters   : the root node, an optional VisuClass
##******************************************************************************
sub new
{
   my ($classname,$node,$systemsDeclaration) = @_;

   my $attributes = $node->getAttributes();
   my $attrnode = $attributes->getNamedItem("Name");
   my $user = "";
   if( defined( $attrnode ) )
   {
      $user = AccentsXML2Text( $attrnode->getValue() );
   }
   else
   {
      die("UserNode: No such user $user");
   }

   ##===========================================================================
   if( $systemsDeclaration->getUser() !~ /^admin/ )
   {
      return new LogTrend::Visu::Web::MessageNode( "For user <I>$user</I>",
         "<H2>You are not allowed to include file from other users</H2>\n".
         "Only an <I>admin...</I> user can do that at the root of his/her file.",
         $systemsDeclaration);
   }

   ##===========================================================================
   my $self2 = LogTrend::Visu::ArchitectureNode->new();
   my $self = LogTrend::Visu::Web::SystemsDeclaration->new($user);

   ##===========================================================================
   foreach my $k (keys %$self2)
   {
      $self->{$k} = $self2->{$k};
   }
   $self2 = undef;

   ##===========================================================================
   $self->{NAME}        = "User $self->{USER}";
   $self->{DESCRIPTION} = "Supervision for user $self->{USER}";

   bless($self, $classname);
   return $self;

}

# Used method ... comes from ... :
#
# newNetworkNode -> Web::NetworkNode
# newSystemLeaf  -> Web::NetworkNode
# treat          -> Web::NetworkNode
# buildTree      -> Web::NetworkNode -> NetworkNode
# getDataBase    -> Web::SystemsDeclaration -> SystemsDeclaration
# get<WIDGET>    -> Web::SystemsDeclaration -> SystemsDeclaration

##******************************************************************************
1;
