#!/usr/bin/perl -w

#$Header: /home2/cvsroot/LogTrend/Visu/Web/ReportGenerator.pm,v 1.14 2002/01/03 12:24:17 slhullier Exp $
##******************************************************************************
## Class ReportGenarator  isa ArchitectureNode
##  Description  : a class for generate the report via the web
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Sylvain Lhullier s.lhullier@atrid.fr
##******************************************************************************
#$Log: ReportGenerator.pm,v $
#Revision 1.14  2002/01/03 12:24:17  slhullier
#bin prefix is /usr/bin
#
#Revision 1.13  2001/12/28 16:32:48  slhullier
#Graph extractor plugin engine works
#
#Revision 1.12  2001/12/05 16:32:36  slhullier
#Error management with try/otherwise ...
#
#Revision 1.11  2001/12/05 10:29:02  slhullier
#Little correction
#
#Revision 1.10  2001/11/19 09:12:38  slhullier
#uninitialized value warning fixed
#
#Revision 1.9  2001/11/16 16:45:01  slhullier
#Text color format
#
#Revision 1.8  2001/11/15 16:08:57  slhullier
#UserNode managing first version (still bugs)
#
#Revision 1.7  2001/11/14 15:59:45  slhullier
#No more global value for SystemsDeclaration
#
#Revision 1.6  2001/11/13 10:37:41  slhullier
#Accents bug for on-line reports fixed
#
#Revision 1.5  2001/11/12 15:26:02  slhullier
#*** empty log message ***
#
#Revision 1.4  2001/11/12 10:03:00  slhullier
#no more tab
#
#Revision 1.3  2001/11/09 16:12:53  slhullier
#Form for report generation
#
#Revision 1.2  2001/10/30 09:42:34  slhullier
#Report via the web: minimalist
#
#Revision 1.1  2001/10/29 14:06:03  slhullier
#Stable but non-realy working report via the web
#

package LogTrend::Visu::Web::ReportGenerator;

use strict;
use POSIX qw(strftime);
use Time::Local;
use Error qw(:try);

@Error::AMoi::ISA = qw(Error);

use LogTrend::Visu::ArchitectureNode;
use LogTrend::Visu::Report::ReportGenerator;
use LogTrend::Visu::Constants;
use LogTrend::Visu::SystemsDeclaration;
use LogTrend::Visu::Utils;

use vars qw( @ISA );
@ISA = ("LogTrend::Visu::ArchitectureNode");

##******************************************************************************
## Constructor  public >ArchitectureNode
##  Parameters   : the XML node
##******************************************************************************
sub new
{
   my ($classname,$user,$systemsDeclaration) = @_;
   my $self = $classname->SUPER::new();
   bless($self, $classname);

   $self->{USER} = $user;
   $self->{SYSTEMSDECLARATION} = $systemsDeclaration;
   $self->{NAME} = "Report Generation";

   return $self;
}

##******************************************************************************
## Method newIdent  protected >ArchitectureNode
##  Description  : return an uniq identificator for an ArchitectureNode
##  Parameters   : none
##  Return value : the identificator ("report")
##******************************************************************************
sub newIdent
{
   return "report";
}

##******************************************************************************
## Method buildTree  public
##  Description  : put this object in an HTML/docbook tree
##  Parameters   : none
##  Return value : the string
##******************************************************************************
sub buildTree
{
   my ($self,$dir) = @_;

   my $here;
   if( $dir ne "" ) { $here = $dir."/".$self->ident(); }
   else             { $here = $self->ident(); }

   return "<LI><A HREF=\"$here/\" TARGET=\"right\">$self->{NAME}</A>\n";
}

##******************************************************************************
## Method treat  public
##  Description  : treat a request
##  Parameters   : a Request
##  Return value : a Response
##******************************************************************************
sub treat
{
   my ($self,$request) = @_;

   ##===========================================================================
   ## Form page
   ##===========================================================================
   if( ! $request->firstNodeExists() )
   {
      return $self->generateForm();
   }

   ##===========================================================================
   ## Report generation
   ##===========================================================================
   my $asking = $request->firstNode();
   if( $asking eq "report.tar.gz" )
   {
      return $self->reportGeneration( $request );
   }

   ##===========================================================================
   my $response = new LogTrend::Visu::Response("text/html");
   $response->print( "Erreur (asking=$asking)" );
   return $response;

}

##******************************************************************************
## Method reportGeneration  private
##  Description  : reading form and call for report generation
##  Parameters   : the request
##  Return value : a Response
##******************************************************************************
sub reportGeneration
{
   my ($self,$request) = @_;
   my $response = new LogTrend::Visu::Response();

   ##===========================================================================
   ## Reading parameters
   ##===========================================================================
   my %param = ();

   $param{TITLE} = $request->param("title");
   $param{REFERENCE} = $request->param("reference");

   ##---------------------------------------------------------------------------
   $param{DATE} = $request->param("date");

   ##---------------------------------------------------------------------------
   my $date_day = $request->param("date1_day");
   my $date_month = $request->param("date1_month") - 1;
   my $date_year = $request->param("date1_year") - 1900;
   my $date = timelocal( 0, 0, 0, $date_day, $date_month, $date_year );
   $param{START} = $date;

   ##---------------------------------------------------------------------------
   $date_day = $request->param("date2_day");
   $date_month = $request->param("date2_month") - 1;
   $date_year = $request->param("date2_year") - 1900;
   $date = timelocal( 0, 0, 0, $date_day, $date_month, $date_year ) - 1;
   $param{STOP} = $date;

   ##---------------------------------------------------------------------------
   my @contact = ();
   for( my $contactNbr=1;
        defined( $request->param("fristname$contactNbr") );
        $contactNbr++ )
   {
      my $fristname = $request->param("fristname$contactNbr");
      my $surname   = $request->param("surname$contactNbr");
      my $email     = $request->param("email$contactNbr");
      if( $fristname ne ""  or  $surname ne ""  or  $email ne "\@" )
      {
         $email = "" if( $email eq "\@" );
         my %c = ( FIRSTNAME => $fristname,
                   SURNAME   => $surname,
                   EMAIL     => $email );
         push @contact, \%c;
      }
   }
   $param{CONTACT} = \@contact;

   ##---------------------------------------------------------------------------
   $param{VISUCLASS} = $request->param("visuclass");
   $param{VISUCLASS} = undef if( $param{VISUCLASS} eq "-- default --" );

   ##===========================================================================
   ## Generate report
   ##===========================================================================
   my $confFilename = "/etc/LogTrend/Visu/report.conf";  ######
   my $rg;
   try
   {
      $rg = new LogTrend::Visu::Report::ReportGenerator( $self->{USER},
                                                   $confFilename, \%param );
      $response->contentType("application/x-gtar");
      $response->print( $rg->run() );
   }
   otherwise
   {
      $response->contentType("text/html");
      $response->print( "<HTML>\n" );
      $response->print( "<HEAD><TITLE>Error</TITLE></HEAD>\n" );
      $response->print( "<META HTTP-EQUIV=\"pragma\" CONTENT=\"no-cache\">\n" );
      $response->print( "<BODY BGCOLOR=\"".$self->{SYSTEMSDECLARATION}->getColor('BackGround')."\"".
                                " TEXT=\"".$self->{SYSTEMSDECLARATION}->getColor('Text')."\"".
                                " LINK=\"".$self->{SYSTEMSDECLARATION}->getColor('Links')."\"".
                               " VLINK=\"".$self->{SYSTEMSDECLARATION}->getColor('VisitedLinks')."\">\n" );
      $response->print( "<CENTER>\n" );
      $response->print( "<BR><HR WIDTH=\"50%\">\n" );
      $response->print( "File $Utils_CurrentFile<BR>\n" );
      $response->print( "$_[0]<BR>\n" );
      $response->print( "$Utils_WarningMessage<BR>\n" );
      $response->print( "<HR WIDTH=\"50%\"><BR>\n" );
      $response->print( "<A HREF=\"javascript:history.back()\">Return to the previous page</A>\n" );
      $response->print( "</CENTER>\n" );
      $response->print( "</BODY>\n" );
      $response->print( "</HTML>\n" );
   }
   finally
   {
      $rg = undef;
   };  # ; very important


   $response->fileName("report.tar.gz");
   return $response;

}

##******************************************************************************
## Method generateForm  private
##  Description  : generate the form page
##  Parameters   : none
##  Return value : a Response
##******************************************************************************
sub generateForm
{
   my ($self) = @_;
   my $response = new LogTrend::Visu::Response();

   my ($actualDay, $actualMonth, $actualYear)= (localtime(time()))[3, 4, 5];
   $actualYear  += 1900;
   $actualMonth += 1;
   my $lastYear  = $actualYear;
   my $lastMonth = $actualMonth - 1;
   if( $lastMonth == 0 )
   {
      $lastYear -= 1;
      $lastMonth = 12;
   }

   $response->contentType("text/html");
   $response->print( "<HTML>\n" );
   $response->print( "<BODY BGCOLOR=\"".$self->{SYSTEMSDECLARATION}->getColor('BackGround')."\"".
                             " TEXT=\"".$self->{SYSTEMSDECLARATION}->getColor('Text')."\"".
                             " LINK=\"".$self->{SYSTEMSDECLARATION}->getColor('Links')."\"".
                            " VLINK=\"".$self->{SYSTEMSDECLARATION}->getColor('VisitedLinks')."\">\n" );
   $response->print( "<BR><BR>\n" );
   $response->print( "<CENTER>\n" );
   $response->print( "<H2>Report generation for user $self->{USER}</H2>\n" );
   $response->print( "<FORM METHOD=\"get\" ACTION=\"report.tar.gz\" NAME=\"formulaire\">\n" );
   $response->print( "<TABLE BORDER=\"0\">\n" );
   $response->print( "<TR>\n" );
   $response->print( "   <TD ALIGN=\"right\"><B>Title&nbsp;:</B></TD>\n" );
   $response->print( "   <TD COLSPAN=\"3\"><INPUT TYPE=\"text\" SIZE=\"50\" NAME=\"title\" VALUE=\"".
                     $self->{SYSTEMSDECLARATION}->getName() ."\"></TD>\n" );
   $response->print( "</TR>\n" );
   $response->print( "<TR>\n" );
   $response->print( "<TR>\n" );
   $response->print( "   <TD ALIGN=\"right\"><B>Reference&nbsp;:</B></TD>\n" );

   $response->print( "   <TD COLSPAN=\"3\"><INPUT TYPE=\"text\" SIZE=\"50\" NAME=\"reference\" VALUE=\"" );
   my $ref = $self->{SYSTEMSDECLARATION}->getReference();
   $response->print( $ref ) if( defined($ref) );
   $response->print( "\"></TD>\n" );

   $response->print( "</TR>\n" );
   $response->print( "<TR>\n" );
   $response->print( "   <TD ALIGN=\"right\"><B>Date&nbsp;:</B></TD>\n" );
   {
      use locale;
      $response->print( "   <TD COLSPAN=\"3\"><INPUT TYPE=\"text\" SIZE=\"50\" NAME=\"date\" VALUE=\"".
                        strftime('%c', localtime( time() ) ) ."\"></TD>\n" );
   }
   $response->print( "</TR>\n" );
   $response->print( "<TR>\n" );
   $response->print( "   <TD ALIGN=\"right\"><B>Period&nbsp;:</B></TD>\n" );
   $response->print( "   <TD COLSPAN=\"3\"><SELECT NAME=\"date1_day\">\n" );
   foreach my $day (1..31)
   {
      $response->print( "      <OPTION VALUE=\"$day\"" );
      $response->print( " SELECTED") if( $day == 1 );
      $response->print( ">$day</OPTION>\n" );
   }
   $response->print( "      </SELECT><SELECT NAME=\"date1_month\">\n" );
   foreach my $month (1..12)
   {
      $response->print( "      <OPTION VALUE=\"$month\"" );
      $response->print( " SELECTED") if( $month == $lastMonth );
      $response->print( ">$month</OPTION>\n" );
   }
   $response->print( "      </SELECT><SELECT NAME=\"date1_year\">\n" );
   foreach my $year ( ($actualYear-10) .. ($actualYear+1) )
   {
      $response->print( "      <OPTION VALUE=\"$year\"" );
      $response->print( " SELECTED") if( $year == $lastYear );
      $response->print( ">$year</OPTION>\n" );
   }
   $response->print( "      </SELECT><FONT SIZE=\"-1\">(included)</FONT>\n" );
   $response->print( "      to\n" );
   $response->print( "      <SELECT NAME=\"date2_day\">\n" );
   foreach my $day (1..31)
   {
      $response->print( "      <OPTION VALUE=\"$day\"" );
      $response->print( " SELECTED") if( $day == 1 );
      $response->print( ">$day</OPTION>\n" );
   }
   $response->print( "      </SELECT><SELECT NAME=\"date2_month\">\n" );
   foreach my $month (1..12)
   {
      $response->print( "      <OPTION VALUE=\"$month\"" );
      $response->print( " SELECTED") if( $month == $actualMonth );
      $response->print( ">$month</OPTION>\n" );
   }
   $response->print( "      </SELECT><SELECT NAME=\"date2_year\">\n" );
   foreach my $year ( ($actualYear-10) .. ($actualYear+1) )
   {
      $response->print( "      <OPTION VALUE=\"$year\"" );
      $response->print( " SELECTED") if( $year == $actualYear );
      $response->print( ">$year</OPTION>\n" );
   }
   $response->print( "      </SELECT><FONT SIZE=\"-1\">(excluded)</FONT>\n" );
   $response->print( "   </TD>\n" );
   $response->print( "</TR>\n" );
   $response->print( "<TR><TD COLSPAN=\"4\">&nbsp;</TD></TR>\n" );
   $response->print( "<TR>\n" );
   $response->print( "   <TD ALIGN=\"left\"><B>Contacts&nbsp;:</B></TD>\n" );
   $response->print( "   <TD ALIGN=\"left\">Firstname</TD>\n" );
   $response->print( "   <TD ALIGN=\"left\">Surname</TD>\n" );
   $response->print( "   <TD ALIGN=\"left\">E-mail</TD>\n" );
   $response->print( "</TR>\n" );

   my $contactNbr = 1;
   foreach my $contact (@{$self->{SYSTEMSDECLARATION}->getContacts()})
   {
      $response->print( "<TR>\n" );
      $response->print( "   <TD ALIGN=\"right\">$contactNbr&nbsp;</TD>\n" );
      $response->print( "   <TD><INPUT TYPE=\"text\" SIZE=\"10\" NAME=\"fristname$contactNbr\" VALUE=\"$contact->{FIRSTNAME}\"></TD>\n" );
      $response->print( "   <TD><INPUT TYPE=\"text\" SIZE=\"15\" NAME=\"surname$contactNbr\" VALUE=\"$contact->{SURNAME}\"></TD>\n" );
      $response->print( "   <TD><INPUT TYPE=\"text\" SIZE=\"20\" NAME=\"email$contactNbr\" VALUE=\"$contact->{EMAIL}\"></TD>\n" );
      $response->print( "</TR>\n" );
      $contactNbr++;
   }
   for( my $n=$contactNbr; $n<$contactNbr+2; $n++ )
   {
      $response->print( "<TR>\n" );
      $response->print( "   <TD ALIGN=\"right\">$n&nbsp;</TD>\n" );
      $response->print( "   <TD><INPUT TYPE=\"text\" SIZE=\"10\" NAME=\"fristname$n\" VALUE=\"\"></TD>\n" );
      $response->print( "   <TD><INPUT TYPE=\"text\" SIZE=\"15\" NAME=\"surname$n\" VALUE=\"\"></TD>\n" );
      $response->print( "   <TD><INPUT TYPE=\"text\" SIZE=\"20\" NAME=\"email$n\" VALUE=\"\@\"></TD>\n" );
      $response->print( "</TR>\n" );
   }
   $response->print( "<TR><TD COLSPAN=\"4\">&nbsp;</TD></TR>\n" );
   $response->print( "<TR>\n" );
   $response->print( "   <TD ALIGN=\"right\"><B>VisuClass&nbsp;:</B></TD>\n" );
   $response->print( "   <TD COLSPAN=\"3\"><INPUT TYPE=\"text\" SIZE=\"15\" NAME=\"visuclass\" VALUE=\"\-- default --\">\n" );
   $response->print( "      <FONT SIZE=\"-1\">If you don't know what it means,\n" );
   $response->print( "      you'd better to let <CODE>default</CODE></FONT></TD>\n" );
   $response->print( "</TR>\n" );
   $response->print( "<TR><TD COLSPAN=\"4\">&nbsp;</TD></TR>\n" );
   $response->print( "<TR>\n" );
   $response->print( "   <TD COLSPAN=\"4\"><INPUT TYPE=\"submit\" VALUE=\"Go!\"></TD>\n" );
   $response->print( "</TR>\n" );
   $response->print( "</TABLE>\n" );
   $response->print( "</FORM>\n" );
   $response->print( "</CENTER>\n" );
   $response->print( "<BR>\n" );
   $response->print( LogTrend::Visu::Utils::dateHTMLString() );
   $response->print( "<BR>\n" );
   $response->print( "</BODY>\n" );
   $response->print( "</HTML>\n" );
   return $response;

}

##******************************************************************************
1;
