#!/usr/bin/perl -w

#$Header: /home2/cvsroot/LogTrend/Visu/Report/Zone/BarGraph.pm,v 1.5 2001/11/19 12:55:50 slhullier Exp $
##******************************************************************************
## Class Report::Zone::BarGraph  isa Zone
##  Description  : class from which inherit (Bar|Line)Graph
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Laurent Simonneau l.simonneau@atrid.fr
##******************************************************************************
#$Log: BarGraph.pm,v $
#Revision 1.5  2001/11/19 12:55:50  slhullier
#Accent bug fixed at all ...
#
#Revision 1.4  2001/11/14 15:59:45  slhullier
#No more global value for SystemsDeclaration
#
#Revision 1.3  2001/11/12 10:03:00  slhullier
#no more tab
#
#Revision 1.2  2001/10/29 12:54:32  lsimonneau
#Remove GD deps.
#
#Revision 1.1  2001/10/24 09:02:56  lsimonneau
#Remove Web or Report Prefix from Zone files.
#
#Revision 1.2  2001/10/23 14:29:41  lsimonneau
#Update Header.
#
#Revision 1.1  2001/10/23 12:06:24  lsimonneau
#First release of Report Zone.
#

package LogTrend::Visu::Report::Zone::BarGraph;

use strict;

use LogTrend::Common::Duration;
use LogTrend::Visu::Utils;
use LogTrend::Visu::Report::Zone::Graph;
use LogTrend::Visu::Zone::BarGraph;
use LogTrend::Visu::Request;
use LogTrend::Visu::Response;
use LogTrend::Visu::Constants;

use vars qw( @ISA );
@ISA = ("LogTrend::Visu::Report::Zone::Graph", "LogTrend::Visu::Zone::BarGraph");

##******************************************************************************
## Constructor  public
##  Description  : creat a new Graph object
##  Parameters   : the Type XML node, the Zone XML node
##******************************************************************************
sub new
{
   my ($classname,$rootnode,$realrootnode,$systemsDeclaration) = @_;
   my $self = $classname->SUPER::new($rootnode,$realrootnode,$systemsDeclaration);

   bless($self, $classname);

   return $self;
}



##******************************************************************************
## parseXML  protected (>Graph)
##  Description  : parse bar graph specific xml entry
##  Parameters   :
##******************************************************************************
sub parseXML {
    my ($self,$rootnode,$realrootnode) = @_;

    $self->LogTrend::Visu::Zone::BarGraph::parseXML($rootnode, $realrootnode);
}


##******************************************************************************
## Method setDataStyle  protected
##  Description  : generate children specificthe configuration line(s) for gnuplot
##  Parameters   :
##  Return value :
##******************************************************************************
sub setDataStyle {
    return  "set data style boxes\n";
}

##******************************************************************************
1;
