#!/usr/bin/perl -w

#$Header:
##******************************************************************************
## Class DataAlarmsBag
##  Description  : class to stock DataAlarmsSet to a file waiting for sending
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Sylvain Lhullier s.lhullier@atrid.fr
##******************************************************************************
#$Log: DataAlarmsBag.pm,v $
#Revision 1.11  2002/02/06 13:06:39  lsimonneau
#Minor bugfixes.
#
#Revision 1.10  2001/10/22 14:53:32  fdubuy
#buggy mkdir
#
#Revision 1.9  2001/10/15 14:41:24  lsimonneau
#Implementation of a not sent data queue.
#When StorageServer is down or smtp server not respond, data is queued.
#The queue is emptied when connection can be established.
#If the agent is stopped (term int die ...) data is sent.
#If data can't be sent, a mail with queue file is sent to agent admin.
#
#Revision 1.8  2001/09/28 16:15:53  lsimonneau
#Minor bugfixes.
#
#Revision 1.7  2001/08/31 16:00:59  lsimonneau
#Appel de termSignal sur SIGINT (Ctrl-C).
#
#Revision 1.6  2001/07/10 12:54:28  slhullier
#
#Correction bug fichier tmp
#
#Revision 1.5  2001/07/09 11:44:45  slhullier
#*** empty log message ***
#
#Revision 1.4  2001/07/09 11:39:37  slhullier
#
#Deletion of glog calls -> readdir
#
#Revision 1.3  2001/06/07 14:08:54  slhullier
#
#Passage de  unshift @INC,'..';  aux packages Logtrend::....
#
#Revision 1.2  2001/05/31 14:21:12  slhullier
#
#Bug ADAT
#
#Revision 1.1  2001/04/20 07:13:31  slhullier
#
#Premier essais (concluant) de stockage des messages sur disque
#

package LogTrend::Agent::DataAlarmsBag;

use IO::Handle;
use Fcntl;
use strict;
use LogTrend::Agent::DataAlarmsSet;
use LogTrend::Common::LogDie;

##******************************************************************************
## Constructor  public
##  Parameters   : a collection date, an agent's source, an agent's number,
##                 an agent's version, an agent's activation date,
##                 a DataDescriptionSet object, an AlarmDescriptionSet object
##******************************************************************************
sub new
{
   my ($classname) = @_;
   my $self = {};
   bless($self, $classname);
   $self->{NUMBER} = "00000000001";

   if(! -d "/var/cache/logtrend") {
       mkdir ("/var/cache/logtrend",0700) or die "/var/cache/logtrend : $!";
   }   

   $self->{DIRNAME} = $self->DirCreate("/var/cache/logtrend/logtrend-agent-bag-");
   
   return $self;
}

##******************************************************************************
## Method termSignal  protected
##  Description  : manage the reception of a SIGTERM
##  Parameters   : none
##  Return value : none
##******************************************************************************
sub termSignal
{
   my ($self) = @_;

   opendir(REP, "$self->{DIRNAME}") or return;
   my @filelist = grep !/^\.\.?$/, readdir REP;
   if( @filelist == 0)
   {
       rmdir("$self->{DIRNAME}");
   }
   closedir REP;
}

##******************************************************************************
## Method DirCreate
##  Description  : create a directory in /var/cache/logtrend
##  Parameters   : none
##  Return value : none
##******************************************************************************
sub DirCreate
{
   my ($self,$tmpFilePrefix) = @_;
   my $i=0;
   my $dir = $tmpFilePrefix.$$."-".$i;
   $! = 0;
   while( !mkdir( $dir, 0700 ) && $!{EEXIST} )   # file exists
   {
      $i ++;
      $dir = $tmpFilePrefix.$$."-".$i;
      $! = 0;
   }
   Die("mkdir $dir : $!") if( $! != 0 );

   return $dir;
}

##******************************************************************************
## Method AddAlarm  public
##  Description  : adds an DataAlarmsSet to the bag
##  Parameters   : the DataAlarmsSet
##  Return value : none
##******************************************************************************
sub AddDataAlarmsSet
{
   my ($self, $set) = @_;
   my $result = 0;

   open( STOCK, ">$self->{DIRNAME}/$self->{NUMBER}" )
                         || Die(" open $self->{DIRNAME}/$self->{NUMBER} : $!" );
   print STOCK ($set->ConvertToXml());
   close STOCK;
   $self->{NUMBER} ++;
}

##******************************************************************************
## Method ConvertToXml  public
##  Description  : formats the data/alarms set in xml
##  Parameters   : none
##  Return value : an xml string representation of the data/alarms set
##******************************************************************************
sub ConvertToXml
{
   my $self = shift;
   my $result = "";

   #foreach my $name (glob "$self->{DIRNAME}/*")
   #--> glob failed (child exited with status -1, core dumped)

   opendir(REP, "$self->{DIRNAME}") or Die("$self->{DIRNAME}: $!");

   foreach my $n (grep !/^\.\.?$/, readdir REP)
   {
      my $name = "$self->{DIRNAME}/$n";
      open( STOCK, "$name" ) || Die("open $name : $!");
      $result.=$_ while(<STOCK>);
      close(STOCK);
      unlink( $name ) || Die("unlink $name : $!");
   }

   closedir REP;

   $self->{NUMBER} = "00000000001";
   
   if($result ne "") {
       return "<ADAT>".$result."</ADAT>";
   }
   else {
       return "";
   }
}

##******************************************************************************
1;
