#!/usr/bin/perl -w

#$Header: /home2/cvsroot/LogTrend/Action/Mail.pm,v 1.3.2.2 2002/02/20 14:25:34 lsimonneau Exp $
##*****************************************************************************
##  Class Mail 
##  Description  : Send a mail to specified address
##
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Laurent Simonneau l.simonneau@atrid.fr
##*****************************************************************************
#$Log: Mail.pm,v $
#Revision 1.3.2.2  2002/02/20 14:25:34  lsimonneau
#*** empty log message ***
#
#Revision 1.5  2002/02/20 13:51:27  lsimonneau
#Change Reply to instead of Return-Path in agents and MailBridge.pl.
#Major bugfixes in StorageServer GPG Key rings management.
#
#Revision 1.4  2002/02/14 15:45:00  lsimonneau
#Minor features enhancement
#Add a Sender attribut in the Mail tag of agents config file.
#Use SMTP Server when available or /usr/lib/sendmail otherwise.
#Add the -s <smtp_server> option to MailBridge.pl.
#
#Revision 1.3  2002/01/30 12:44:09  lsimonneau
#Major bugfixe.
#
#Revision 1.2  2001/11/02 13:55:42  lsimonneau
#Add Action support for agents' alarms.
#Add action support for LinuxAgent Process alarms.
#
#Revision 1.1  2001/10/31 16:44:53  lsimonneau
#Move Action from ComplexAlarm to LogTrend root.
#
#Revision 1.3  2001/06/21 16:07:13  lsimonneau
#Dplacement de la clause 'package' avant les 'use'
#
#Revision 1.2  2001/06/07 14:41:04  lsimonneau
#Passage du unshift @INC, '..' au LogTrend::
#
#Revision 1.1  2001/05/30 09:36:57  lsimonneau
#Premire version du module d'alarmes complexes dans le CVS.
#Toutes les fonctionnalits ont t testes et correctement.
#

package LogTrend::Action::Mail;

use strict;
use MIME::Entity;
use Net::SMTP;
use LogTrend::Action;

@LogTrend::Action::Mail::ISA = ("LogTrend::Action");

##*****************************************************************************
## Constructor  public
##  Description  : creat a new SyslogAction
##  Parameters   : The XML node.
##*****************************************************************************
sub new 
{
    my ($classname, $xml_node) = @_;
    my $self = $classname->SUPER::new();          
    
    bless($self, $classname);
    
    $self->ParseXMLAction($xml_node);

    return $self;
}


##*****************************************************************************
## Method ParseXMLAction private
##  Description  : Run the action
##  Parameters   : none
##*****************************************************************************
sub ParseXMLAction
{
    my ($self, $node) = @_;
    my ($list, $attributes, $attrnode);
    
    $attributes = $node->getAttributes() || die("Error in \"Mail\" tag.");

    $attrnode = $attributes->getNamedItem("Address") ||
	die("No 'Address' field in \"Mail\" tag.");
    $self->{ADDRESS}=$attrnode->getValue();

    $self->{MAIL_SENDER} = 'root@localhost';
    $attrnode = $attributes->getNamedItem("Sender");
    if(defined $attrnode) {
        $self->{MAIL_SENDER} = $attrnode->getValue();
    }

    $self->{MAIL_SMTP} = 'localhost';
    $attrnode = $attributes->getNamedItem("SMTPServer");
    if(defined $attrnode) {
        $self->{MAIL_SMTP} = $attrnode->getValue();
    }

    $attrnode = $attributes->getNamedItem("Subject") ||
	die("No 'Subject' field in \"Mail\" tag.");
    $self->{SUBJECT}=$attrnode->getValue();
    
    $list = $node->getChildNodes();        
    $node = $list->item(0) or die("Action: invalid \"Mail\" Tag");
    
    $self->{MESSAGE} = $node->getNodeValue();
}


##*****************************************************************************
## Method Run public
##  Description  : Run the action
##  Parameters   : the alarm level
##*****************************************************************************
sub Run 
{
    my ($self, $alarm_level) = @_;

    my $entity = MIME::Entity->build(Type     => "text/plain",
                                     From     => "LogTrend agent <$self->{MAIL_SENDER}>",
                                     To       => "LogTrend Admin <$self->{ADDRESS}>",
                                     Subject  => "[LogTrend] $alarm_level : $self->{SUBJECT}",
                                     Data     => [$self->{MESSAGE}]);

    
    if($self->{MAIL_SMTP} eq 'localhost') {
        open(MAILER, "| /usr/lib/sendmail -t  -i -f$self->{MAIL_SENDER}");
        $entity->print(\*MAILER);
        close(MAILER);
    }
    else {
        my $smtp = Net::SMTP->new($self->{MAIL_SMTP});
        $smtp->mail($self->{MAIL_SENDER});
        $smtp->to($self->{ADDRESS});
        $smtp->data([ $entity->stringify ]);
        $smtp->quit;
    }
}

1;
