#!/usr/bin/perl -w

package LogTrend::ComplexAlarm::Function::last_date_older_than;

use strict;

sub Properties {
    my ($var1, $date) = @_;

    return ("anteriority($date)", $var1);
}

sub Run {
    my ($var_init_values_hash_ref, $var_types_hash_ref, $cur_res_value_ref, $var1, $date) = @_;

    my %result;

    my $data_list = $var_init_values_hash_ref->{$var1};
    my $last_data_date;

    if ($#$data_list == -1) {
        $result{$var1} = $data_list;
    }
    else {
        $last_data_date = $data_list->[$#$data_list]->[1];
        
        my $now = time;
        
        my $data_age = $now - $last_data_date;
        
        if($data_age >= $date) {
            $result{$var1} = $data_list;
        }
    }

    # return a reference on the result hash
    return \%result;
}

1;
