#!/usr/bin/perl -w

#$Header: /home2/cvsroot/LogTrend/ComplexAlarm/Function/DetFuncStdlib.pm,v 1.6 2001/07/25 12:14:53 lsimonneau Exp $
##*****************************************************************************
##  File DetFuncStdlib
##  Description  : Standard detection function library
##
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Laurent Simonneau l.simonneau@atrid.fr
##*****************************************************************************
#$Log: DetFuncStdlib.pm,v $
#Revision 1.6  2001/07/25 12:14:53  lsimonneau
#Minor bugfixes.
#
#Revision 1.5  2001/07/25 11:59:11  lsimonneau
#Remove debug outputs.
#
#Revision 1.4  2001/07/23 12:16:26  lsimonneau
#Bugfixe : Recriture de duration pour corriger le bug mis  jour lors de ma soutenance de stage
#
#Revision 1.3  2001/06/21 16:07:14  lsimonneau
#Dplacement de la clause 'package' avant les 'use'
#
#Revision 1.2  2001/06/07 14:41:04  lsimonneau
#Passage du unshift @INC, '..' au LogTrend::
#
#Revision 1.1  2001/05/30 09:36:57  lsimonneau
#Premire version du module d'alarmes complexes dans le CVS.
#Toutes les fonctionnalits ont t testes et correctement.
#

##*****************************************************************************
##  Package superior
##  Description  :  
##
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Laurent Simonneau l.simonneau@atrid.fr
##*****************************************************************************

use strict;

package LogTrend::ComplexAlarm::Function::superior;

sub Properties {
    my ($var, $limit, $duration) = @_;
    
    if(defined $duration) {
	my @dur_res = LogTrend::ComplexAlarm::Function::duration::Properties($duration);
	return ($dur_res[0], ($var));
    } 
    else {
	return ("", ($var));
    }    
}

sub Run {
    my ($var_init_values_hash_ref, $var_types_hash_ref, $cur_res_value_ref, $var, $limit, $duration) = @_;
    my $index1= 0; 
    my $index2 = 0;
    my $list_ref = $var_init_values_hash_ref->{$var};
    my %result;
    my @list_result;


    while(defined $list_ref->[$index1]){
	# if it's an integer, real, date, time or datetime 
	# (converted in seconds since epoch for date and datetime and in seconds for time)
	if($var_types_hash_ref->{$var} ne "text") {
	    if($list_ref->[$index1][0] > $limit) {
		$list_result[$index2] = $list_ref->[$index1];
		$index2++;
	    }
	    $index1++;
	}
	# if it's a string
	else {
	    if($list_ref->[$index1][0] gt $limit) {
		$list_result[$index2] = $list_ref->[$index1];
		$index2++;
	    }
	    $index1++;
	}
    }

    $result{$var} = \@list_result;    

    if(defined $duration) {
      return LogTrend::ComplexAlarm::Function::duration::Run($var_init_values_hash_ref, $var_types_hash_ref, \%result, $duration);
    }

    return \%result;    
}

##*****************************************************************************
##  Package inferior
##  Description  :  
##
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Laurent Simonneau l.simonneau@atrid.fr
##*****************************************************************************
package LogTrend::ComplexAlarm::Function::inferior;

sub Properties {
    my ($var, $limit, $duration) = @_;
    
    if(defined $duration) {
	my @dur_res = LogTrend::ComplexAlarm::Function::duration::Properties($duration);
	return ($dur_res[0], ($var));
    }
    else {
	return ("", ($var));
    }
}

sub Run {
    my ($var_init_values_hash_ref, $var_types_hash_ref, $cur_res_value_ref, $var, $limit, $duration) = @_;
    my $index1= 0; 
    my $index2 = 0;
    my $list_ref = $var_init_values_hash_ref->{$var};
    my %result;
    my @list_result;
    
    while(defined $list_ref->[$index1]){
	# if it's an integer, real, date, time or datetime (converted in seconds since epoch for date and datetime and in seconds for time)
	if($var_types_hash_ref->{$var} ne "text") {
	    if($list_ref->[$index1][0] < $limit) {
		$list_result[$index2] = $list_ref->[$index1];
		$index2++;
	    }
	    $index1++;
	}
	# if it's a string
	else {
	    if($list_ref->[$index1][0] lt $limit) {
		$list_result[$index2] = $list_ref->[$index1];
		$index2++;
	    }
	    $index1++;
	}
    }

    $result{$var} = \@list_result;

    if(defined $duration) {
      return LogTrend::ComplexAlarm::Function::duration::Run($var_init_values_hash_ref, $var_types_hash_ref, \%result, $duration);
    }

    return \%result;    
}


##*****************************************************************************
##  Package equal
##  Description  :  
##
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Laurent Simonneau l.simonneau@atrid.fr
##*****************************************************************************

package LogTrend::ComplexAlarm::Function::equal;

sub Properties {
    my ($var, $value, $duration) = @_;
    
    if(defined $duration) {
	my @dur_res = LogTrend::ComplexAlarm::Function::duration::Properties($duration);
	return ($dur_res[0], ($var));
    }
    else {
	return ("", ($var));
    }    
}

sub Run {
    my ($var_init_values_hash_ref, $var_types_hash_ref, $cur_res_value_ref, $var, $limit, $duration) = @_;
    my $index1= 0; 
    my $index2 = 0;
    my $list_ref = $var_init_values_hash_ref->{$var};
    my %result;
    my @list_result;
    
    while(defined $list_ref->[$index1]){
	# if it's an integer, real, date, time or datetime (converted in seconds since epoch for date and datetime and in seconds for time)
	if($var_types_hash_ref->{$var} ne "text") {
	    if($list_ref->[$index1][0] == $limit) {
		$list_result[$index2] = $list_ref->[$index1];
		$index2++;
	    }
	    $index1++;
	}
	# if it's a string
	else {
	    if($list_ref->[$index1][0] eq $limit) {
		$list_result[$index2] = $list_ref->[$index1];
		$index2++;
	    }
	    $index1++;
	}
    }

    $result{$var} = \@list_result;

    if(defined $duration) {
      return LogTrend::ComplexAlarm::Function::duration::Run($var_init_values_hash_ref, $var_types_hash_ref, \%result, $duration);
    }

    return \%result;    
}


##*****************************************************************************
##  Package different
##  Description  :  
##
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Laurent Simonneau l.simonneau@atrid.fr
##*****************************************************************************

package LogTrend::ComplexAlarm::Function::different;

sub Properties {
    my ($var, $value, $duration) = @_;
    
    if(defined $duration) {
	my @dur_res = LogTrend::ComplexAlarm::Function::duration::Properties($duration);
	return ($dur_res[0], ($var));
    }
    else {
	return ("", ($var));
    }    
}

sub Run {
    my ($var_init_values_hash_ref, $var_types_hash_ref, $cur_res_value_ref, $var, $limit, $duration) = @_;
    my $index1= 0; 
    my $index2 = 0;
    my $list_ref = $var_init_values_hash_ref->{$var};
    my %result;
    my @list_result;
    
    while(defined $list_ref->[$index1]){
	# if it's an integer, real, date, time or datetime (converted in seconds since epoch for date and datetime and in seconds for time)
	if($var_types_hash_ref->{$var} ne "text") {
	    if($list_ref->[$index1][0] != $limit) {
		$list_result[$index2] = $list_ref->[$index1];
		$index2++;
	    }
	    $index1++;
	}
	# if it's a string
	else {
	    if($list_ref->[$index1][0] ne $limit) {
		$list_result[$index2] = $list_ref->[$index1];
		$index2++;
	    }
	    $index1++;
	}
    }

    $result{$var} = \@list_result;

    if(defined $duration) {
      return LogTrend::ComplexAlarm::Function::duration::Run($var_init_values_hash_ref, $var_types_hash_ref, \%result, $duration);
    }

    return \%result;    
}



##*****************************************************************************
##  Package between
##  Description  :  
##
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Laurent Simonneau l.simonneau@atrid.fr
##*****************************************************************************

package LogTrend::ComplexAlarm::Function::between;

sub Properties {
    my ($var, $limitinf, $limitsup, $duration) = @_;
    
    if(defined $duration) {
	my @dur_res = LogTrend::ComplexAlarm::Function::duration::Properties($duration);
	return ($dur_res[0], ($var));
    }
    else {
	return ("", ($var));
    }    
}

sub Run {
    my ($var_init_values_hash_ref, $var_types_hash_ref, $cur_res_value_ref, $var, $limitinf, $limitsup, $duration) = @_;
    my $index1= 0; 
    my $index2 = 0;
    my $list_ref = $var_init_values_hash_ref->{$var};
    my %result;
    my @list_result;
    
    while(defined $list_ref->[$index1]){
	# if it's an integer, real, date, time or datetime (converted in seconds since epoch for date and datetime and in seconds for time)
	if($var_types_hash_ref->{$var} ne "text") {
	    if(($list_ref->[$index1][0] >= $limitinf) and ($list_ref->[$index1][0] <= $limitsup)) {
		$list_result[$index2] = $list_ref->[$index1];
		$index2++;
	    }
	    $index1++;
	}
	# if it's a string
	else {
	    if(($list_ref->[$index1][0] ge $limitinf) and ($list_ref->[$index1][0] le $limitsup)) {
		$list_result[$index2] = $list_ref->[$index1];
		$index2++;
	    }
	    $index1++;
	}
    }

    $result{$var} = \@list_result;

    if(defined $duration) {
      return LogTrend::ComplexAlarm::Function::duration::Run($var_init_values_hash_ref, $var_types_hash_ref, \%result, $duration);
    }

    return \%result;    
}





##*****************************************************************************
##  Package average
##  Description  :  
##
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Laurent Simonneau l.simonneau@atrid.fr
##*****************************************************************************

package LogTrend::ComplexAlarm::Function::average;

sub Properties {
    my ($var, $duration, $comp, @comp_args) = @_;
    
    return ("anteriority($duration)", ($var));
}

sub Run {
    my ($var_init_values_hash_ref, $var_types_hash_ref, $cur_res_value_ref, $var, $duration, $comp, @comp_args) = @_;
    my $result;
    my %temp_result;
    my @data_list;


    my @result_list;

    return {} unless defined $var_init_values_hash_ref->{$var}->[0];
    
    my $first_date = $var_init_values_hash_ref->{$var}->[0][1];
    
    my $var_init_index=0;
    my $cur_data_index;
    my $temp_index;

    my $average;

    # Initialize @data_list
    while((defined $var_init_values_hash_ref->{$var}->[$var_init_index]) and
	  (($var_init_values_hash_ref->{$var}->[$var_init_index][1] - $first_date) - $duration/2 <= 0)) {
	push @data_list, $var_init_values_hash_ref->{$var}->[$var_init_index];
	$var_init_index++;
    }    

    return {} unless defined $var_init_values_hash_ref->{$var}->[$var_init_index];
    
    $cur_data_index = $var_init_index-1;
    $first_date = $var_init_values_hash_ref->{$var}->[$cur_data_index][1];
    
    while((defined $var_init_values_hash_ref->{$var}->[$var_init_index]) and
	  (($var_init_values_hash_ref->{$var}->[$var_init_index][1] - $first_date) - $duration/2 <= 0)) {	
	push @data_list, $var_init_values_hash_ref->{$var}->[$var_init_index];
	$var_init_index++;
    }

    return {} unless  defined $var_init_values_hash_ref->{$var}->[$var_init_index];
    
    while(defined $var_init_values_hash_ref->{$var}->[$var_init_index]) {
	# process average
	$average = 0;
	foreach my $data (@data_list) {
	    $average += $data->[0];
	}
	
	$average /= $#data_list+1;
	push @result_list, [$average, $var_init_values_hash_ref->{$var}->[$cur_data_index][1]];

	$cur_data_index++;
	$first_date = $var_init_values_hash_ref->{$var}->[$cur_data_index][1];

	# update @data_list
	$temp_index = 0;
	while((defined $data_list[$temp_index]) and 
	      ($first_date - $data_list[$temp_index][1]) - $duration/2 > 0) {
	    $temp_index++;
	}
		
	@data_list = @data_list[$temp_index..$#data_list];
		
	while((defined $var_init_values_hash_ref->{$var}->[$var_init_index]) and
	      (($var_init_values_hash_ref->{$var}->[$var_init_index][1] - $first_date) - $duration/2 <= 0)) {
	    push @data_list, $var_init_values_hash_ref->{$var}->[$var_init_index];
	    $var_init_index++;
	}
    }

    $temp_result{$var} = \@result_list;
    
    # Run the comparison fonction
    $result = eval("LogTrend::ComplexAlarm::Function::${comp}".'::Run(\%temp_result, $var_types_hash_ref, $cur_res_value_ref, $var, @comp_args)');
    
    
    $var_init_index = 0;
    $cur_data_index = 0;

    # change average result by initial value
    while(defined $result->{$var}->[$cur_data_index]) {
	if($var_init_values_hash_ref->{$var}->[$var_init_index][1] == $result->{$var}->[$cur_data_index][1]) {
	    $result->{$var}->[$cur_data_index][0] = $var_init_values_hash_ref->{$var}->[$var_init_index][0];
	    $cur_data_index++;
	}
	
	$var_init_index++;	   
    }
        
    return $result;    
}


##*****************************************************************************
##  Package duration
##  Description  :  
##
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Laurent Simonneau l.simonneau@atrid.fr
##*****************************************************************************
package LogTrend::ComplexAlarm::Function::duration;

sub Properties {
    my $duration = shift;
    
    return ("anteriority($duration)", ());
}


sub Run {
    my ($var_init_hash_ref, $var_types_hash_ref, $cur_res_ref, $duration) = @_;
    my @var_list = keys %$cur_res_ref;
    my %seq_hash;

    ### Search sequences
    foreach my $key (@var_list) {
	my ($cur_index, $init_index) = (0, 0);
	my $cur_var_list = $cur_res_ref->{$key};
	my $var_init_list = $var_init_hash_ref->{$key};

	while(defined $cur_var_list->[$cur_index]) {
	    my $cur_date = $cur_var_list->[$cur_index][1];
	    
	    # search this date in the var_init_list
	    while($var_init_list->[$init_index][1] != $cur_date) {$init_index++;}
	
	    my $down_limit = $cur_date;

	    # search the end of the sequence
	    while(defined $cur_var_list->[$cur_index] and
		  $var_init_list->[$init_index][1] == $cur_var_list->[$cur_index][1]) {
		$init_index++;
		$cur_index++;
	    }

	    my $up_limit = $var_init_list->[$init_index-1][1];

	    # add this sequence to the seq_hash
	    push @{$seq_hash{$key}}, [$down_limit, $up_limit];
	}
    }

    ### Search intersections

    # copy the first variable sequences in cur_res;

    my $cur_res = $seq_hash{$var_list[0]};
    
    foreach my $key (@var_list) {
	my @temp_res = ();

	foreach my $seq (@$cur_res) {
	    foreach my $cur_seq (@{$seq_hash{$key}}) {
		my $down_limit;
		if($seq->[0] >= $cur_seq->[0]) {
		    $down_limit = $seq->[0];
		}
		else {
		    $down_limit = $cur_seq->[0];
		}
		
		my $up_limit;
		if($seq->[1] <= $cur_seq->[1]) {
		    $up_limit = $seq->[1];
		}
		else {
		    $up_limit = $cur_seq->[1];
		}

		if($down_limit <= $up_limit) {
		    push @temp_res, [$down_limit, $up_limit];
		}
	    }
	}
	
	$cur_res = \@temp_res;	
    }

    ### Look for sequences superior to $duration seconds
    my @temp_res = ();
    foreach my $seq (@$cur_res) {
	if($seq->[1] - $seq->[0] >= $duration) {
	    push @temp_res, $seq;
	}
    }


    ### Copy valid data in the result hash
   
    my %result;
    
    if($#temp_res == -1) {
	foreach my $key (@var_list) {
	    $result{$key} = [];
	}
    }
    else {
	foreach my $seq (@temp_res) {
	    foreach my $key (@var_list) {
		my $cur_var_list = $cur_res_ref->{$key};
		my $index = 0;
		
		while(defined $cur_var_list->[$index]) {
		    if($cur_var_list->[$index][1] >= $seq->[0] and 
		       $cur_var_list->[$index][1] <= $seq->[1]) {
			push @{$result{$key}}, \@{$cur_var_list->[$index]};
		    }
		    $index++;
		}
	    }
	}
    }
    
    return \%result;
}

##*****************************************************************************
##  Package time_interval
##  Description  :  
##
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Laurent Simonneau l.simonneau@atrid.fr
##*****************************************************************************
package LogTrend::ComplexAlarm::Function::time_interval;

require LogTrend::ComplexAlarm::Date::TimeIntervalParser;

sub Properties
{
    my ($start, $end) = @_;

    return ("", ());
}



sub Run
{
    my ($var_init_hash_ref, $var_types_hash_ref, $cur_res_ref, $start, $end) = @_;
    my %result;      

    my $timeintervalparser1 = LogTrend::ComplexAlarm::Date::TimeIntervalParser->new($start);
    my $timeintervalparser2 = LogTrend::ComplexAlarm::Date::TimeIntervalParser->new($end);       

    my @var_list = keys %$var_init_hash_ref;
    my $var_name;
    
    foreach $var_name (@var_list) {
	my @list_result;
	my ($index1, $index2) = (0,0);
	my $timeval;

	while(defined $var_init_hash_ref->{$var_name}->[$index1]){
	    $timeval = $var_init_hash_ref->{$var_name}->[$index1][1];

	    if($timeintervalparser1->IsSuperior($timeval) and 
	       $timeintervalparser2->IsInferior($timeval)){
		$list_result[$index2] = $var_init_hash_ref->{$var_name}->[$index1];
		$index2++;
	    }
	    $index1++;
	}
	
	$result{$var_name} = \@list_result;
    }
      

    return \%result;
}

1;
