#!/usr/bin/perl -w 
##*****************************************************************************
##  Package TimeIntervalParser
##  Description  : Date parser used by the time_interval detection function
##
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Laurent Simonneau l.simonneau@atrid.fr
##*****************************************************************************

package LogTrend::ComplexAlarm::Date::TimeIntervalParser;

use strict;
use LogTrend::ComplexAlarm::Date::DateTimeParser;

@LogTrend::ComplexAlarm::Date::TimeIntervalParser::ISA = ("LogTrend::ComplexAlarm::Date::DateTimeParser");


##*****************************************************************************
## Constructor  public
##  Description  : creat a new DateTimeParser
##  Parameters   : the datetime string
##*****************************************************************************
sub new 
{
    my ($classname, $datetime) = @_;
    my $self = $classname->SUPER::new($datetime);
    
    bless($self, $classname);
    
    # Mask for elements present in the datetime string
    # (year, month, day_number, day_of_week, hour, minute, second)
    @{$self->{DATETIMEMASK}} = (0, 0, 0, 0, 0, 0, 0);
    @{$self->{DATETIMEVALUE}} = (0, 0, 0, 0, 0, 0, 0);

    $self->Run();

    return $self;    
}


##*****************************************************************************
## Method IsSuperior protected
##  Description  : Compare the DateTime to a date
##  Parameters   : The date to compare in seconds since epoch 
##  Return       : 1 if the datetime match the argument, 0 otherwise
##*****************************************************************************

sub IsSuperior
{
    my ($self, $date) = @_ ;
    my @localtime_result = localtime($date);
    my $index = 0;
        
    my @date_value_list = ($localtime_result[6], $localtime_result[3], $localtime_result[4]+1, $localtime_result[5]+1900, $localtime_result[2], $localtime_result[1], $localtime_result[0]);


    # check if datetime is superior or equal to $date
    for($index = 0; $index < 7; $index++){
	if($self->{DATETIMEMASK}[$index]){
	    if($date_value_list[$index] < $self->{DATETIMEVALUE}[$index] ) {
		return 0;		
	    }
	    elsif($date_value_list[$index] > $self->{DATETIMEVALUE}[$index]){
		last;
	    }
	}
    }

    return 1;
}


##*****************************************************************************
## Method IsInferior protected
##  Description  : Compare the DateTime to a date
##  Parameters   : The date to compare in seconds since epoch 
##  Return       : 1 if the datetime match the argument, 0 otherwise
##*****************************************************************************

sub IsInferior
{
    my ($self, $date) = @_ ;
    my @localtime_result = localtime($date);
    my $index = 0;
    
    my @date_value_list = ($localtime_result[6], $localtime_result[3], $localtime_result[4]+1, $localtime_result[5]+1900, $localtime_result[2], $localtime_result[1], $localtime_result[0]);

    # check if datetime is inferior or equal to $date
    for($index = 0; $index < 7; $index++){
	if($self->{DATETIMEMASK}[$index]){
	    if($date_value_list[$index] > $self->{DATETIMEVALUE}[$index]) {
		return 0;
	    }
	    elsif( $date_value_list[$index] < $self->{DATETIMEVALUE}[$index]){
		last;
	    }
	}
    }
    return 1;
}


##*****************************************************************************
## Method AddDow protected
##  Description  : Add a day of week to the datetime condition
##  Parameters   : none
##*****************************************************************************

sub AddDow
{
    my ($self, $value) = @_ ;

    $self->{DATETIMEMASK}[0]=1;
    $self->{DATETIMEVALUE}[0]=$value;
}


##*****************************************************************************
## Method AddDay protected
##  Description  : Add a day number to the datetime condition
##  Parameters   : none
##*****************************************************************************

sub AddDay
{
    my ($self, $value) = @_ ;

    $self->{DATETIMEMASK}[1]=1;
    $self->{DATETIMEVALUE}[1]=$value;
}

##*****************************************************************************
## Method AddMonth protected
##  Description  : Add a month to the datetime condition
##  Parameters   : none
##*****************************************************************************

sub AddMonth
{
    my ($self, $value) = @_ ;

    $self->{DATETIMEMASK}[2]=1;
    $self->{DATETIMEVALUE}[2]=$value;
}


##*****************************************************************************
## Method AddYear protected
##  Description  : Add a year to the datetime condition
##  Parameters   : none
##*****************************************************************************

sub AddYear
{
    my ($self, $value) = @_ ;

    $self->{DATETIMEMASK}[3]=1;
    $self->{DATETIMEVALUE}[3]=$value;
}


##*****************************************************************************
## Method AddHour protected
##  Description  : Add an hour to the datetime condition
##  Parameters   : none
##*****************************************************************************

sub AddHour
{
    my ($self, $value) = @_ ;

    $self->{DATETIMEMASK}[4]=1;
    $self->{DATETIMEVALUE}[4]=$value;
}


##*****************************************************************************
## Method AddMin protected
##  Description  : Add a minute to the datetime condition
##  Parameters   : none
##*****************************************************************************

sub AddMin
{
    my ($self, $value) = @_ ;

    $self->{DATETIMEMASK}[5]=1;
    $self->{DATETIMEVALUE}[5]=$value;
}


##*****************************************************************************
## Method AddSec protected
##  Description  : Add a second to the datetime condition
##  Parameters   : none
##*****************************************************************************

sub AddSec
{
    my ($self, $value) = @_ ;

    $self->{DATETIMEMASK}[6]=1;
    $self->{DATETIMEVALUE}[6]=$value;
}

1;
