#!/usr/bin/perl -w

#$Header: /home2/cvsroot/LogTrend/ComplexAlarm/Date/DateTimeParser.pm,v 1.3 2001/06/21 16:07:14 lsimonneau Exp $
##*****************************************************************************
## Class DateTimeParser
##  Description  : 
##
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Laurent Simonneau l.simonneau@atrid.fr
##*****************************************************************************
#$Log: DateTimeParser.pm,v $
#Revision 1.3  2001/06/21 16:07:14  lsimonneau
#Dplacement de la clause 'package' avant les 'use'
#
#Revision 1.2  2001/06/07 14:41:04  lsimonneau
#Passage du unshift @INC, '..' au LogTrend::
#
#Revision 1.1  2001/05/30 09:36:57  lsimonneau
#Premire version du module d'alarmes complexes dans le CVS.
#Toutes les fonctionnalits ont t testes et correctement.
#

package LogTrend::ComplexAlarm::Date::DateTimeParser;

use strict;
use LogTrend::ComplexAlarm::Parser;

@LogTrend::ComplexAlarm::Date::DateTimeParser::ISA = ("LogTrend::ComplexAlarm::Parser");

my $daystring = "sunday sun monday mon tuesday tue wednesday wed thursday thu friday fri saturday sat";

my $monthstring = "january jan february feb march mar april apr may may june jun july jul august aug september sep october oct november nov december dec";

my $dow_regexp = $daystring;
$dow_regexp =~ s/ /\|/g;

my $month_regexp = $monthstring;
$month_regexp =~ s/ /\|/g;

my @tokenlist = (':', '/', '\d\d\d\d', '\d?\d', "hour(s)?", "min(ute(s)?)?", "sec(ond(s)?)?", "$dow_regexp", "$month_regexp");


##*****************************************************************************
## Constructor  public
##  Description  : creat a new DateTimeParser
##  Parameters   : the datetime string
##*****************************************************************************
sub new
{
    my ($classname, $datetime) = @_;

    # Remove the quotes to the begining and the end of the datetime string
    $datetime =~ s/^(\"|\')(.*)(\1)$/$2/;
    
    my $self = $classname->SUPER::new($datetime, @tokenlist);

    bless($self, $classname);

    return $self;
}

##*****************************************************************************
## Method Run public
##  Description  : parse the datetime and call the following protected methods
##  Parameters   : none
##*****************************************************************************
sub Run
{
    my $self = shift;
    my $endmark = $#tokenlist+1;
    my $state = 0;
    
    my ($token_id, $token_string) = $self->NextToken();

    my $last_number;

    while($token_id != $endmark) {
	if($token_id == -1) {
	  $self->ParseError("Unknown token '$token_string'");
	}
	# Token is ':'
	elsif($token_id == 0){
	    if(($state == 2) or ($state == 14) or ($state == 5)) {
		$self->AddHour($last_number);
		$state = 6;
	    }
	    elsif($state == 7){
		$state = 8;
	    }
	    else {
		$self->ParseError("Unexpected :");
	    }
	}
	# Token is '/'
	elsif($token_id == 1){
	    if($state == 2) {
		$self->AddDay($last_number);
		$state = 10;
	    }
	    elsif($state == 11){
		$state = 12;
	    }
	    else {
		$self->ParseError("Unexpected /");
	    }
	}
	# Token is '\d\d\d\d'
	elsif($token_id == 2){
	    if($state == 0 or $state == 3) {
		$self->AddYear($token_string);
		$state = 4;
	    }
	    elsif($state == 12) {
		$self->AddYear($token_string);
		$state = 13;
	    }
	    else {
		$self->ParseError("Unexpected $token_string");
	    }
	}
	# Token is '\d\d'
	elsif($token_id == 3){
	    if($state == 0) {
		$last_number = $token_string;
		$state = 2;
	    }
	    elsif($state == 1) {
		$last_number = $token_string;
		$state = 2;
	    }
	    elsif($state == 2) {
		$self->AddDay($last_number);
		$last_number = $token_string;
		$state = 14;
	    }
	    elsif($state == 3) {
		$last_number = $token_string;
		$state = 5;
	    }
	    elsif($state == 4) {
		$last_number = $token_string;
		$state = 5;
	    }
	    elsif($state == 6) {
		$self->AddMin($token_string);
		$state = 7;
	    }
	    elsif($state == 8) {
		$self->AddSec($token_string);
		$state = 9;
	    }
	    elsif($state == 10) {
		$self->AddMonth($token_string);
		$state = 11;
	    }
	    else {
		$self->ParseError("Unexpected $token_string");
	    }
	}
	# Token is 'hour(s)?'
	elsif($token_id == 4){
	    if(($state == 2) or ($state == 14) or ($state == 5)) {
		$self->AddHour($last_number);
		$state = 6;
	    }
	    else {
		$self->ParseError("Unexpected $token_string");
	    }
	}
	# Token is 'min' or 'minute(s)?'
	elsif($token_id == 5){
	    if($state == 7){
		$state = 8;
	    }
	    else {
		$self->ParseError("Unexpected $token_string");
	    }	    
	}
	# Token is 'sec' or 'second(s)?'
	elsif($token_id == 6){
	    if($state == 9) {
		$state = 15;
	    }
	    else {
		$self->ParseError("Unexpected $token_string");
	    }	    
	}	
	# Token is '$dow_regexp'
	elsif($token_id == 7){
	    if($state == 0) {
		my $index = 0;
		my $day;
		my @daylist = split(/ /, $daystring);
		foreach $day (@daylist){
		    if($day =~ /^$token_string$/i) {
			last;
		    }
		    $index++;
		}
		$index =int($index/2);		
		$self->AddDow($index);		
		$state = 1;
	    }
	    else {
		$self->ParseError("Unexpected $token_string");
	    }
	}
	# Token is '$month_regexp'
	elsif($token_id == 8){
	    if($state == 0 or $state == 2) {
		my $index = 0;
		my $month;
		my @monthlist = split(/ /, $monthstring);
		foreach $month (@monthlist){
		    if($month =~ /^$token_string$/i) {
			last;
		    }
		    $index++;
		}
		$index =int($index/2)+1;

		if($state == 0){
		    $self->AddMonth($index);
		}
		else {
		    $self->AddDay($last_number);
		    $self->AddMonth($index);
		}
		
		$state = 3;
	    }
	    else {
		$self->ParseError("Unexpected $token_string");
	    }
	}
	else {
	    $self->ParseError("Internal parser error : unknown token id");
	}

	($token_id, $token_string) = $self->NextToken();
    }

    if($state ==2) {
	$self->AddDay($last_number);
    }

    if(!($state == 1 or 
	 $state == 2 or 
	 $state == 3 or 
	 $state == 4 or 
	 $state == 6 or 
	 $state == 8 or 
	 $state == 9 or 
	 $state == 13 or
	 $state == 15)){
	$self->ParseError("Unexpected end of DateTime");
	return "";
    }
}


##*****************************************************************************
## Method ParseError protected
##  Description  : 
##  Parameters   : none
##*****************************************************************************
sub ParseError 
{
    my ($self, $string) = @_;
    
    die "Parse error : $string";
}


##*****************************************************************************
## Method AddDow protected
##  Description  : Add a day of week to the datetime condition
##  Parameters   : none
##*****************************************************************************

sub AddDow
{
}


##*****************************************************************************
## Method AddDay protected
##  Description  : Add a day number to the datetime condition
##  Parameters   : none
##*****************************************************************************

sub AddDay
{
}

##*****************************************************************************
## Method AddMonth protected
##  Description  : Add a month to the datetime condition
##  Parameters   : none
##*****************************************************************************

sub AddMonth
{
}


##*****************************************************************************
## Method AddYear protected
##  Description  : Add a year to the datetime condition
##  Parameters   : none
##*****************************************************************************

sub AddYear
{
}


##*****************************************************************************
## Method AddHour protected
##  Description  : Add an hour to the datetime condition
##  Parameters   : none
##*****************************************************************************

sub AddHour
{
}


##*****************************************************************************
## Method AddMin protected
##  Description  : Add a minute to the datetime condition
##  Parameters   : none
##*****************************************************************************

sub AddMin
{
}


##*****************************************************************************
## Method AddSec protected
##  Description  : Add a second to the datetime condition
##  Parameters   : none
##*****************************************************************************

sub AddSec
{
}

1;
