#!/usr/bin/perl -w

#$Header: /home2/cvsroot/LogTrend/ComplexAlarm/DataBase/ComplexAlarmDataBase.pm,v 1.7 2002/02/05 15:52:50 lsimonneau Exp $
##*****************************************************************************
##  DataBaseInterface
##  Description  : 
##                 
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Laurent Simonneau l.simonneau@atrid.fr
##*****************************************************************************
#$Log: ComplexAlarmDataBase.pm,v $
#Revision 1.7  2002/02/05 15:52:50  lsimonneau
#Several critical bugs fixed
#
#Revision 1.6  2001/10/24 12:49:22  lsimonneau
#Major bugfixes : Correct a bug in anteriority string interpretation.
#
#Revision 1.5  2001/10/10 16:33:53  lsimonneau
#Remove AcquitComplexAlarm. This feature is now in DatabaseAccess.
#
#Revision 1.4  2001/09/26 16:01:48  lsimonneau
#Reimplementation of Equation parser.
#
#Revision 1.3  2001/06/21 16:07:14  lsimonneau
#Dplacement de la clause 'package' avant les 'use'
#
#Revision 1.2  2001/06/07 14:41:04  lsimonneau
#Passage du unshift @INC, '..' au LogTrend::
#
#Revision 1.1  2001/05/30 09:36:57  lsimonneau
#Premire version du module d'alarmes complexes dans le CVS.
#Toutes les fonctionnalits ont t testes et correctement.
#

package LogTrend::ComplexAlarm::DataBase::ComplexAlarmDataBase;

use strict;
use DBI;

my $MAX_DATA = 1000000;

##*****************************************************************************
## StoreComplexAlarm public
##  Description  : Store a complex alarm in the database
##  Parameters   : The complex alarm description id
##*****************************************************************************
sub StoreComplexAlarm
{
}


##*****************************************************************************
## GetDataValues  public
##  Description  : Retrieve : 
##                   - data values ;
##                   - collection date of values ;
##                   - variables type.
##                 and update the 'last_checked_data_date' field
##                
##  Parameters   : A complex alarm descr id,
##                 A list of data decscription number,
##                 The datetime restriction string
##
##  Return       : - A reference on a hash of data values.
##                   Each variable has its own entry in the hash.
##                   Each entry is a reference on an array of references on
##                   list of (value, date) (In a few word, there are a lot 
##                   of references ;-)
##                 - A reference on a hash of data type
##*****************************************************************************
sub GetDataValues
{   
    my ($self, $source, $agent, $number, $timestring, $var_name_list_ref) = @_;

    my $anteriority = 0;

    my $id_alarm_description = $self->getIdAlarmDescription($source, $agent, $number);

    my $last_checked_data_date = $self->getLastCheckedDataDate($id_alarm_description);

    # Look for the biggest anteriority
    while ($timestring =~ s/anteriority\((\d+)\)//) {
	if($1 > $anteriority) {
	    $anteriority = $1;
	}
    }

    my @source_list;
    my @agent_list;
    my @data_name_list;
    my @start_date_list;

    # Build source, agent and data name lists foreach variable.
    my $var_name;
    foreach $var_name (@$var_name_list_ref) {
	if($var_name =~ /(\w+)\[(\d+), (\d+)\]/){
	    push @source_list, $2;
	    push @agent_list, $3;
	    push @data_name_list, $1;
	}
	else {
	    push @source_list, $source;
	    push @agent_list, $agent;
	    push @data_name_list, $var_name;
	}
	
	push @start_date_list, ($last_checked_data_date - $anteriority);
    }

    # Retrieve data type hash
    my $temp_data_type_hash_ref = $self->GetSeveralDataType(\@source_list, \@agent_list, \@data_name_list);

    # Retrieve data values hash
    my $temp_data_value_hash_ref = $self->GetSeveralDataInTimeInterval($MAX_DATA, \@source_list, \@agent_list, \@data_name_list, \@start_date_list);

    # convert hash keys [source, agent, data name] into variable name of var_name_list_ref
    my %data_type_hash;
    my %data_value_hash;

    foreach my $key (keys %$temp_data_type_hash_ref) {
	$key =~ /(\d+), (\d+), (\w+)/;
	
	my ($src, $agt, $dta) = ($1, $2, $3);
	my $ok = 0;
		

	# look for var_name[source, agent] in var_name_list_ref
	foreach $var_name (@$var_name_list_ref) {
	    if($var_name =~ /$dta\[$src, $agt\]/) {
		$ok = 1;
		last;
	    }
	}

	if($ok) {
	    $data_type_hash{"$dta\[$src, $agt\]"} = $temp_data_type_hash_ref->{$key};
	    $data_value_hash{"$dta\[$src, $agt\]"} = $temp_data_value_hash_ref->{$key};
	}
	else {
	    $data_type_hash{"$dta"} = $temp_data_type_hash_ref->{$key};
	    $data_value_hash{"$dta"} = $temp_data_value_hash_ref->{$key};
	}
    }
    
    # look for the new last checked data date
    my $new_last_date = 0;
    my $new_date;
    foreach my $key (keys %data_value_hash) {
	if($data_value_hash{$key} == 0) {
	    die "Unknown variable $key";
	}

	if($#{$data_value_hash{$key}} == -1) {
	    next;
	}
	
	$new_date = $data_value_hash{$key}->[$#{$data_value_hash{$key}}][1];
	if($new_date > $new_last_date) {
	    $new_last_date = $new_date;
	}
    }

    # Update the last checked data date
    if($new_last_date != 0) {
        $self->updateLastCheckedDataDate($id_alarm_description, 
					 $new_last_date);
    }

    # return a REFERENCE on the values hash and on the variables type hash
    return (\%data_value_hash, \%data_type_hash);
}

##*****************************************************************************
## StoreComplexAlarm  public
##  Description  : Store a complex alarm description in the database
##  Parameters   : 
##*****************************************************************************
sub StoreComplexAlarmDescription
{
}

1;
