Name:       log4shib
Version:    1.0.4
Release:    1
Summary:    Log for C++, Shibboleth Edition
License:    LGPL
Group:      Development/Libraries
Vendor:     Internet2
URL:        http://shibboleth.internet2.edu/downloads/log4shib/1.0.4
Source:     %name-%version.tar.gz
BuildRoot:  %_tmppath/%name-%version-root
BuildRequires:  gcc-c++
%{!?_without_doxygenrpm:BuildRequires: doxygen}
%if "%{_vendor}" == "redhat"  
BuildRequires: redhat-rpm-config  
%endif  

%if "%{_vendor}" == "suse"
%define pkgdocdir %{_docdir}/%{name}
%else
%define pkgdocdir %{_docdir}/%{name}-%{version}
%endif

%description
Log for C++ is a library of classes for flexible logging to files, syslog,
and other destinations. It is modeled after the Log for Java library and
stays as close to its API as is reasonable.

%if 0%{?suse_version} > 1030
%package -n liblog4shib1
Summary:    Log for C++, Shibboleth Edition
Group:      Development/Libraries
Provides:   log4shib = %{version}
Obsoletes:  log4shib

%description -n liblog4shib1
Log for C++ is a library of classes for flexible logging to files, syslog,
and other destinations. It is modeled after the Log for Java library and
stays as close to its API as is reasonable.

This package contains just the shared library.
%endif

%if 0%{?suse_version} > 1030
%package -n liblog4shib-devel
Requires:   liblog4shib1 = %version
Obsoletes:  log4shib-devel
%else
%package devel
Requires: %name = %version
%endif
Summary: Development tools for Log for C++
Group: Development/Libraries

%if 0%{?suse_version} > 1030
%description -n liblog4shib-devel
%else
%description devel
%endif
The log4shib-devel package contains the static libraries and header files
needed for development with log4shib.

%prep
%setup -q

%build
%configure %{!?_without_doxygenrpm:--enable-doxygen} %{?_without_doxygenrpm:--disable-doxygen}
%{__make}

%install
%{__make} DESTDIR=$RPM_BUILD_ROOT apidir=$RPM_BUILD_ROOT%{pkgdocdir}/api install
# If we use %doc down below to package the README files from the build tree,
# it will blow away the package's docdir folder, and the installed API docs with it.
# Instead, copy the README files manually into the platform's docdir.
config/install-sh -d $RPM_BUILD_ROOT%{pkgdocdir}
config/install-sh -m 644 -c AUTHORS COPYING INSTALL NEWS README THANKS ChangeLog $RPM_BUILD_ROOT%{pkgdocdir}

%clean
[ "$RPM_BUILD_ROOT" != "/" ] && %{__rm} -rf $RPM_BUILD_ROOT

%ifnos solaris2.8 solaris2.9 solaris2.10
%if 0%{?suse_version} > 1030
%post -n liblog4shib1 -p /sbin/ldconfig
%else
%post -p /sbin/ldconfig
%endif
%endif

%if 0%{?suse_version} > 1030
%post -n liblog4shib-devel
%else
%post devel
%endif
if test "x$RPM_INSTALL_PREFIX0" != "x" ; then
    %{__perl} -pi -e"s|^prefix=\"[^\"]*\"|prefix=\"$RPM_INSTALL_PREFIX0\"|" $RPM_INSTALL_PREFIX0/bin/log4shib-config
fi

%ifnos solaris2.8 solaris2.9 solaris2.10 
%if 0%{?suse_version} > 1030
%postun -n liblog4shib1 -p /sbin/ldconfig
%else
%postun -p /sbin/ldconfig
%endif
%endif

%if 0%{?suse_version} > 1030
%files -n liblog4shib1
%else
%files
%endif
%defattr(-,root,root,755)
%attr(755,root,root) %{_libdir}/lib*.so.*

%if 0%{?suse_version} > 1030
%files -n liblog4shib-devel
%else
%files devel
%endif
%defattr(-,root,root,755)
%{_includedir}/*
%{!?_without_doxygenrpm:%{_mandir}/man?/*}
%attr(755,root,root) %{_bindir}/log4shib-config
%attr(755,root,root) %{_libdir}/*.so
%attr(644,root,root) %{_libdir}/*.a
%attr(644,root,root) %{_libdir}/pkgconfig/log4shib.pc
%attr(644,root,root) %{_datadir}/aclocal/*.m4
%exclude %{_libdir}/*.la
%doc %{pkgdocdir}

%changelog
* Sat Oct 24 2009  Scott Cantor  <cantor.2@osu.edu>  - 1.0.3-2
- Cleaned up specfile for OpenSUSE build service

* Wed Aug 5 2009  Scott Cantor  <cantor.2@osu.edu>  - 1.0.3-1
- Cleaned up specfile for OpenSUSE build service
