#!/usr/bin/perl

use strict;
use warnings;

#use File::Temp qw/ tempfile/;

use IO::File;
use POSIX qw(tmpnam);


# set debugging
my $debug = 0;

# Helper subroutine to set debconf key/value pairs
# This is to be called before installation of packages
# to preset the debconf values with useful values,
# according to the locale chosen by the user.


sub preseed {
    # The arguments needed are:
    # lang:            the locale value, used as key for the debconf arrays
    # debconf_keys:    the associative array with the names of the debconf keys
    #                  as used in /var/cache/debconf/config.dat
    # debconf_values:  the associative array with the actual values using locale
    #                  entry as key.

    my ($package, $lang, $debconf_values, $debconf_keys) = @_;

    # my ($tmpfile, $tmpfilename) = tempfile( UNLINK => 0, SUFFIX => '.txt' );

    my ($tmpfname, $tmpf);
    
    # try new temporary filenames until we get one that didn't already exist
    do { $tmpfname = tmpnam() }
        until $tmpf = IO::File->new($tmpfname, O_RDWR|O_CREAT|O_EXCL);
    
    # install atexit-style handler so that when we exit or die,
    # we automatically delete this temporary file
    END { unlink($tmpfname) or die "Couldn't unlink $tmpfname : $!" }
    
    # now go on to use the file ...
    
    # Debconf seeding for the given keys and values
    # the associative array debconf_keys holds the key names for
    # debconf, while the debconf_values holds the actual values,
    # using locale value as the key.
    
    if(defined(my $conf = $debconf_values->{$lang})) {
       
        # Set debconf value for each given key/value pair
        for my $entry (sort keys %{$debconf_keys}) {
             if (defined($conf->{$entry})) {
                 print "$entry\t$debconf_keys->{$entry}\n" if $debug;
                 print $debconf_keys->{$entry}." -> ".$conf->{$entry}."\n" if $debug;

                 print $tmpf "$package $debconf_keys->{$entry} string $conf->{$entry}\n";
            }
        }
       
        my $cmd;
        if ( -x "/usr/bin/debconf-set-selections") {
           $cmd = "/usr/bin/debconf-set-selections ".$tmpfname;
	   system($cmd);
	} elsif ( -x "/usr/sbin/debconf-load-defaults") {
	   $cmd = "/usr/sbin/debconf-load-defaults ".$tmpfname;
	   system($cmd);
	}
	print $cmd."\n" if $debug;
    } else {
        print "$0: No support for language '$lang'\n" if $debug;
    }
    return;
}

1;
