/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 */

 /* (C) Marcin Kwadrans <quar@vitea.pl> */

#include "include/support.h"
#include "include/command.h"
#include "include/message.h"

class LWCommandSetPositionY: public LWCommand {

LWValue *execute1 (LWContext *context, guint argc, LWValue *args[])
{
	g_return_val_if_fail (argc == 1, NULL);
	
	LWPiece *piece = context->wizard->getPiece();
	LWRow *row = piece->getRow();
	LWBoard *board = row->getBoard();
	
	gint x = row->getPieceIndex (piece);
	gint y = CLAMP (args[0]->toInt(), 1, (gint) board->getHeight());
	row = board->getRowNth (y-1);
	piece = row->getPieceNth (x);
	context->wizard->setPiece (piece);
	
	return NULL;
}

const gchar *getName ()
{
	return "setpositiony";
}	

gchar *getHint ()
{
	return _("Set vertical position");
}

void checkArgc (guint n)
{
	if (n != 1) 
		throw new LWMessage (LW_ERROR_WrongNumberOfArguments);
}

};

LWSymbol *new_LWCommandSetPositionY()
{
	return new LWCommandSetPositionY();
}
