/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 */

 /* (C) Marcin Kwadrans <quar@vitea.pl> */

#include "include/support.h"
#include "include/command.h"
#include "include/message.h"

class LWCommandSet: public LWCommand {

LWValue *execute1 (LWContext *context, guint argc, LWValue *args[])
{
	g_return_val_if_fail (argc == 2, NULL);
	g_return_val_if_fail (args[0]->isVariable() == TRUE, NULL);
	
	args[0]->set(args[1]);
	
	/* To jest zmienna, nie potrzeba tworzyć jej kopii przez konstruktor
		kopiujący bo nie zostanie ona nigdy zwolniona */
	return args[0];
}

gchar *getName ()
{
	return "set";
}

gchar *getHint ()
{
	return _("Set");
}

guint getPriority ()
{
	return 2;
}

LWLink getLinkType ()
{
	return LW_LINK_RIGHT;
}

gboolean hasReturn()
{
	return TRUE;
}

void checkArgument (guint n, LWValue *value)
{
	if (n == 0)
		if (FALSE == value->isVariable())
			throw new LWMessage (LW_ERROR_LValueIsNotVariable);
}

void checkArgc (guint n)
{
	if (n != 2) 
		throw new LWMessage (LW_ERROR_WrongNumberOfArguments);
}	

};

LWSymbol *new_LWCommandSet()
{
	return new LWCommandSet();
}
