/*b
 * Copyright (C) 2001,2002  Rick Richardson
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author: Rick Richardson <rickr@mn.rr.com>
b*/

/*
 * sonictrading.com
 *
 * Binary data.  Requires delayed open until symbols are known, cannot
 * change symbols without making a new connection.
 *
 * N.B. Needs code added for livequotes.
 *
 */
#include <stdio.h>
#include <stdlib.h>
#include <ncurses.h>
#include <panel.h>
#include <errno.h>
#include <string.h>
#include <time.h>
#include <sys/time.h>
#include <unistd.h>
#include <sys/socket.h>
#include <netdb.h>
#include <netinet/in.h>
#include "error.h"
#include "debug.h"
#include "rc.h"
#include "streamer.h"
#include "linuxtrade.h"
#include "util.h"

#include "optchain.h"
#include "info.h"

#define	streamer_write	streamer_write_binary

typedef struct streamerpriv
{
	RCFILE	*rcp;
	int	state;
} STREAMERDATA;

static void
streamer_init(STREAMER sr)
{
	sr->refresh = 0;
	sr->fd[0] = -1;
	sr->nfd = 1;
	strcpy(sr->id, "sonictrading");
	sr->priv->rcp = NULL;
	sr->priv->state = 0;
}

static void
streamer_close(STREAMER sr)
{
	close(sr->fd[0]);
	sr->fd[0] = -1;
}

static int
realopen(STREAMER sr, char *zsyms)
{
	struct hostent		*hep;
	struct sockaddr_in	sockaddr;
	int			rc;
	char			content[BUFSIZ];
	int			content_length;
	char			buf[BUFSIZ];
	int			len;
	int			conn_tries;
	RCFILE			*rcp = sr->priv->rcp;
	// char			*username = get_rc_value(rcp, "username");
	// char			*password = get_rc_value(rcp, "encpasswd");
	char			*hostname = get_rc_value(rcp, "hostname");
	int			port = atoi(get_rc_value(rcp, "port"));

	++sr->cnt_realopens;
	time(&sr->time_realopen);

	hep = mygethostbyname(hostname);
	if (!hep)
		return (-1);

	memcpy(&sockaddr.sin_addr, hep->h_addr, hep->h_length);
	sockaddr.sin_family = AF_INET;
	sockaddr.sin_port = htons(port);

	conn_tries = 0;
reconnect:
	if (++conn_tries >= 5)
		return -4;

	debug(5, "Open socket...\n");

	sr->fd[0] = socket(AF_INET, SOCK_STREAM, 0);
	if (sr->fd[0] < 0)
		return -2;

	debug(5, "Connect to '%s' with socket fd=%d...\n", hostname, sr->fd[0]);

	// TODO: need a timeout here...
	rc = connect_timeout(sr->fd[0], (SA *) &sockaddr, sizeof(sockaddr), 15);
	if (rc < 0)
	{
		if (Debug >= 5)
			syserror(0, "Couldn't connect\n");
		streamer_close(sr);
		goto reconnect;
		return -3;
	}

	debug(5, "Send POST...\n");

	content_length = sprintf(content,
		"MfcISAPICommand=OnRequestQuote&RequestText=ZL++++++++++++++"
		"%s", zsyms);

	len = sprintf(buf,
	"POST /Scripts/WebQuote.dll? HTTP/1.1\r\n"
	"content-type: application/x-www-form-urlencoded\r\n"
	//"cookie: AUTH=Pass10; CFID=2120; CFTOKEN=56802252; USERID=rickrich\r\n"
	"User-Agent: Java1.3.1_02\r\n"
	"Host: download.sonictrading.com\r\n"
	"Accept: text/html, image/gif, image/jpeg, *; q=.2, */*; q=.2\r\n"
	"Connection: keep-alive\r\n"
	"Content-length: %d\r\n"
	"\r\n"
	"%s"
	, content_length, content
	);

	rc = streamer_write_binary(sr->fd[0], buf, len);
	if (rc != len)
		syserror(1, "Error sending request to server\n");

	return 0;
}

static int 
streamer_open( STREAMER sr, RCFILE *rcp, FILE *readfile)
{
	streamer_init(sr);
	++sr->cnt_opens;
	time(&sr->time_open);

	sr->priv->rcp = rcp;
	return 0;
}
static int
streamer_select(
		STREAMER sr,
		int n, fd_set *readfds, fd_set *writefds,
		fd_set *exceptfds, struct timeval *timeout
		)
{
	return select(n, readfds, writefds, exceptfds, timeout);
}

static void
streamer_record(STREAMER sr, FILE *fp) {}

static void
streamer_timetick(STREAMER sr, time_t now) {}

static void
streamer_send_quickquote(STREAMER sr, char *sym) {}

static void
streamer_send_livequote(STREAMER sr, char *sym) {}

static void
streamer_send_livequote_end(STREAMER sr) {}

static void
streamer_send_symbols(STREAMER sr, char *symbols, int add) {}

static void
streamer_send_symbols_end(STREAMER sr, int add, int all)
{
	char	buf[200*10];
	char	*p;
	int	i;

	// Its very expensive to change symbols, so ignore deletes
	if (!add)
		return;

	// Close old streamer
	streamer_close(sr);

	// Walk list of all stocks and start new streamer
	p = buf;
	for (i = 0; i < NumStock; ++i)
	{
		int	len = strlen(Stock[i].sym);

		p += sprintf(p, "ZA%.5s%*s1",
			Stock[i].sym, len < 5 ? 5-len : 0, "");
	}
	for (p = buf; *p; ++p)
		if (*p == ' ')
			*p = '+';

	// Open new streamer
	realopen(sr, buf);
}

#if 0
static void
streamer_send_disconnect(STREAMER sr) {}

static void
streamer_send_top10(STREAMER sr, char market, int type, int add) {}

static void
streamer_send_movers(STREAMER sr, int on) {}

static void
streamer_send_info(STREAMER sr, char *sym, int type) {}

static void
streamer_send_optchain(STREAMER sr, char *sym) {}

static void
streamer_send_chart(STREAMER sr, char *sym, int freq, int periods) {}
#endif

static unsigned int
nextN(unsigned char **bp, int n)
{
	unsigned int val = 0;

	while (n--)
	{
		val <<= 8;
		val |= *(*bp)++;
	}
	return val;
}

static void
do_fullquote(unsigned char *buf)
{
	char		*p;
	short		shrt;
	unsigned char	byte;
	char		sbyte;
	float		change;
	char		tick;
	QUOTE		q;
	QUICKQUOTE	qq;
	LIVEQUOTE	lq;

	memset(&q, 0, sizeof(q));
	memset(&qq, 0, sizeof(qq));

	qq.timetrade = q.time = nextN(&buf, 4);

	shrt = nextN(&buf, 2); byte = nextN(&buf, 1);
	qq.bid = q.bid = shrt + byte/100.0;

	shrt = nextN(&buf, 2); byte = nextN(&buf, 1);
	qq.high = q.high = shrt + byte/100.0;

	shrt = nextN(&buf, 2); byte = nextN(&buf, 1);
	qq.ask = q.ask = shrt + byte/100.0;

	shrt = nextN(&buf, 2); byte = nextN(&buf, 1);
	qq.low = q.low = shrt + byte/100.0;

	q.bid_size = nextN(&buf, 4);
	q.ask_size = nextN(&buf, 4);
	q.last_size = nextN(&buf, 4);
	qq.volume = q.volume = nextN(&buf, 4);

	shrt = nextN(&buf, 2); byte = nextN(&buf, 1);
	lq.last = qq.last = q.last = shrt + byte/100.0;

	tick = nextN(&buf, 1);

	shrt = nextN(&buf, 2); sbyte = nextN(&buf, 1);
	change = shrt + sbyte/100.0;

	memcpy(q.sym, buf, 5); q.sym[5] = 0;
	p = strchr(q.sym, ' '); if (p) *p = 0;
	// TODO
	// streamer_sym2canon(q.sym, q.sym);
	strcpy(qq.sym, q.sym);
	strcpy(lq.sym, q.sym);

	lq.close = qq.prev_close = q.close = q.last - change;

	qq.bid_id = qq.ask_id = '?';
	qq.last_eps = 12345678;
	qq.cur_eps = 12345678;
	qq.sharesout = 12345678;

	display_quote(&q, 0);
	optchain_quote(&q);

	info_quickquote(&qq);

	display_livequote(&lq);
}

static int
streamer_process(STREAMER sr, int fdindex)
{
	int	len;
	char	buf[2048];
	char	*bp = buf;

	len = streamer_read(sr, 0, buf, sizeof(buf));
	if (len <= 0)
	{
	    sleep(1);
	    return -1;
	}

	if (len > 0)
		sr->cnt_rx += len;

	if (sr->priv->state == 1)
	{
		sr->priv->state = 0;
		if (len >= 44)
			goto Y1;
		else
			len = 0;
	}

	while (len > 0)
	{
		switch (bp[0])
		{
		case 'Z':
			switch (bp[1])
			{
			case 'I':
				bp += 2;
				len -= 2;
				break;
			case 'R':
				bp += 2;
				len -= 2;
				break;
			default:
				len = 0;
				break;
			}
			break;
		case 'Y':
			switch (bp[1])
			{
			case '1':
				bp += 2;
				len -= 2;
			Y1:
				if (len == 0)
				{
					sr->priv->state = 1;
					return 0;
				}
				else if (len >= 44)
				{
					do_fullquote(bp);
					bp += 44;
					len -= 44;
				}
				else
					len = 0;
				break;
			case 'A':
				bp += 8;
				len -= 8;
				break;
			default:
				len = 0;
				break;
			}
			break;
		case 'N':
			bp += 8;
			len -= 8;
			break;
		default:
			len = 0;
			break;
		}
	}

	return 0;
}

STREAMER
sonictrading_new(void)
{
	STREAMER	sr;

	sr = (STREAMER) malloc(sizeof(*sr));
	if (!sr)
		return NULL;
	memset(sr, 0, sizeof(*sr));

	sr->open = streamer_open;
	sr->select = streamer_select;
	sr->close = streamer_close;
	sr->record = streamer_record;
	sr->timetick = streamer_timetick;

	sr->send_quickquote = streamer_send_quickquote;
	sr->send_livequote = streamer_send_livequote;
	sr->send_livequote_end = streamer_send_livequote_end;
	sr->send_symbols = streamer_send_symbols;
	sr->send_symbols_end = streamer_send_symbols_end;

	// sr->send_disconnect = streamer_send_disconnect;
	// sr->send_top10 = streamer_send_top10;
	// sr->send_movers = streamer_send_movers;
	// sr->send_info = streamer_send_info;
	// sr->send_optchain = streamer_send_optchain;
	// sr->send_chart = streamer_send_chart;

	sr->process = streamer_process;

	sr->priv = (STREAMERDATA *) malloc(sizeof(*sr->priv));
	if (!sr->priv)
	{
		free(sr);
		return NULL;
	}

	time(&sr->time_start);

	streamer_init(sr);

	return (sr);
}
