/*  This file is part of LingoTeach, the Language Teaching program 
 *  Copyright (C) 2001-2003 The LingoTeach Team
 *
 *  This program is free software; you can redistribute it and/or modify 
 *  it under the terms of the GNU General Public License as published by 
 *  the Free Software Foundation; either version 2 of the License, or 
 *  (at your option) any later version. 
 *
 *  This program is distributed in the hope that it will be useful, 
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *  GNU General Public License for more details. 
 * 
 *  You should have received a copy of the GNU General Public License 
 *  along with this program; if not, write to the Free Software 
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
 */

#include <stdlib.h>
#include <lingoteach.h>

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /*HAVE_CONFIG_H */

#include "learningpref.h"
#include "util.h"
#include "onebyone.h"
#include "lingoteach-i18n.h"

/* external global variables */
extern lingLesson *lessons;
extern struct lpreferences genLprefs;
extern GtkTooltips *tooltips;
extern GtkWidget *win_main;

static GtkWidget *box_trans;
static GtkWidget *lbl_langword;
static GtkWidget *lbl_word;
static GtkWidget *btn_playword;
static GtkWidget *btn_infoword;

static gulong handle;
static gulong handle1;

/* the current meaning */
lingMeaning *obocurrent[30];

/* prototypes */
static void on_btn_info_clicked (lingMeaning *meaning);

/*********************
 * private functions *
 *********************/

/*
 * opens a popup dialog with additional information
 */
static 
void on_btn_info_clicked (lingMeaning *meaning)
{
  GtkWidget *dlg_info;
  GtkWidget *frm_picture;
  GtkWidget *frm_info;
  GtkWidget *tbl_info;
  GtkWidget *lbl_phonetic;
  GtkWidget *lbl_description;
  // GtkWidget *lbl_phonetic2;
  GtkWidget *lbl_description2;
  // GtkWidget *lbl_more;
  gint       result;

  dlg_info = gtk_dialog_new_with_buttons (_("Information"), 
					  (GtkWindow *) win_main,
					  GTK_DIALOG_MODAL | 
					  GTK_DIALOG_DESTROY_WITH_PARENT,
					  GTK_STOCK_CLOSE,
					  GTK_RESPONSE_CLOSE,
					  NULL);

    gtk_window_set_default_size (GTK_WINDOW (dlg_info), 175, 100);
  frm_picture = gtk_frame_new (_("Picture"));
  frm_info = gtk_frame_new (_("Information"));

  tbl_info = gtk_table_new (2, 2, FALSE);

  lbl_phonetic = gtk_label_new (_("Phonetic notation"));
  gtk_misc_set_alignment (GTK_MISC (lbl_phonetic), 0.0, 0.5);
  gtk_table_attach (GTK_TABLE (tbl_info), lbl_phonetic, 0, 1, 0, 1,
		    GTK_FILL, (GTK_EXPAND | GTK_FILL), 2, 2);

  lbl_description = gtk_label_new (_("Description"));
  gtk_misc_set_alignment (GTK_MISC (lbl_description), 0.0, 0.5);
  gtk_table_attach (GTK_TABLE (tbl_info), lbl_description, 0, 1, 1, 2,
		    GTK_FILL, (GTK_EXPAND | GTK_FILL), 2, 2);

  lbl_description2 = gtk_label_new (meaning->description);
  gtk_table_attach (GTK_TABLE (tbl_info), lbl_description2, 1, 2, 1, 2,
		    (GTK_EXPAND | GTK_FILL), (GTK_EXPAND | GTK_FILL), 2, 2);
  
  gtk_container_add (GTK_CONTAINER (frm_info), tbl_info);

  gtk_box_pack_start (GTK_BOX (GTK_DIALOG(dlg_info)->vbox), frm_picture,
		      TRUE, TRUE, 2);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG(dlg_info)->vbox), frm_info,
		      TRUE, TRUE, 2);

  gtk_widget_show_all (GTK_DIALOG(dlg_info)->vbox);

  result = gtk_dialog_run (GTK_DIALOG (dlg_info));
  if (result == GTK_RESPONSE_CLOSE)
    gtk_widget_destroy (dlg_info);

  return;
					  
}

/********************
 * public functions *
 ********************/


GtkWidget*
create_obo_box (void)
{
  GtkWidget *tbl_main;
  GtkWidget *sep_obo1;
  GtkWidget *img_info;
  GtkWidget *lbl_arrow;

  tbl_main = gtk_table_new (3, 4, FALSE);
  gtk_table_set_row_spacings (GTK_TABLE (tbl_main), 2);
  
  sep_obo1 = gtk_hseparator_new ();
  gtk_table_attach (GTK_TABLE (tbl_main), sep_obo1, 0, 4, 0, 1,
                    GTK_FILL, GTK_FILL, 2, 0);

  lbl_langword = gtk_label_new ("");
  gtk_label_set_justify (GTK_LABEL (lbl_langword), GTK_JUSTIFY_RIGHT);
  gtk_misc_set_alignment (GTK_MISC (lbl_langword), 0.1, 0.5);
  gtk_table_attach (GTK_TABLE (tbl_main), lbl_langword, 0, 1, 1, 2,
		    (GTK_EXPAND | GTK_FILL), 0, 2, 0);

  lbl_word = gtk_label_new ("");
  gtk_label_set_justify (GTK_LABEL (lbl_word), GTK_JUSTIFY_RIGHT);
  gtk_misc_set_alignment (GTK_MISC (lbl_word), 0.1, 0.5);
  gtk_table_attach (GTK_TABLE (tbl_main), lbl_word, 1, 2, 1, 2,
		    (GTK_EXPAND | GTK_FILL), 0, 2, 0);

  img_info = gtk_image_new_from_stock (GTK_STOCK_DIALOG_INFO,
				       GTK_ICON_SIZE_MENU);
  btn_infoword = gtk_button_new ();
  gtk_container_add (GTK_CONTAINER (btn_infoword), img_info);
  gtk_tooltips_set_tip (tooltips, btn_infoword, _("More Information"), 
			NULL);
  handle = g_signal_connect_swapped (G_OBJECT (btn_infoword), "clicked", 
				     G_CALLBACK (on_btn_info_clicked), 
				     obocurrent[0]);
  gtk_table_attach (GTK_TABLE (tbl_main), btn_infoword, 2, 3, 1, 2,
		    GTK_FILL, GTK_FILL, 2, 0);
  
  lbl_arrow = gtk_arrow_new (GTK_ARROW_RIGHT, GTK_SHADOW_NONE);
  btn_playword = gtk_button_new ();
  gtk_container_add (GTK_CONTAINER (btn_playword), lbl_arrow);
  gtk_tooltips_set_tip (tooltips, btn_playword, _("Play Sound"), NULL);
  handle1 = g_signal_connect_swapped (G_OBJECT (btn_playword), "clicked", 
				      G_CALLBACK (util_on_btn_play_clicked), 
				      NULL);
  gtk_table_attach (GTK_TABLE (tbl_main), btn_playword, 3, 4, 1, 2,
		    GTK_FILL, GTK_FILL, 2, 0);
  
  sep_obo1 = gtk_hseparator_new ();
  gtk_table_attach (GTK_TABLE (tbl_main), sep_obo1, 0, 4, 2, 3,
                    GTK_FILL, GTK_FILL, 2, 0);

  box_trans = gtk_vbox_new (FALSE, 2);
  gtk_table_attach (GTK_TABLE (tbl_main), box_trans, 0, 4, 3, 4,
		    (GTK_EXPAND | GTK_FILL), 0, 0, 0);

  gtk_widget_show_all (tbl_main);

  return tbl_main;
}

/*
 * display new tranlsations, descriptions, etc.
 */
void
on_btn_obo_next_clicked (void)
{
  GtkWidget  *lbl_lang;
  GtkWidget  *lbl_trans;
  GtkWidget  *btn_play;
  GtkWidget  *btn_info;
  GtkWidget  *img_info;
  GtkWidget  *lbl_arrow;
  GtkWidget  *tbl_trans_set;
  GList      *children;
  gint        i = 0;
  gint        id;
  lingLesson *less;

  PangoFontDescription *font = pango_font_description_new ();
  pango_font_description_set_style (font, PANGO_STYLE_ITALIC);
  pango_font_description_set_weight (font, PANGO_WEIGHT_BOLD);

  if (util_check_settings () == FALSE)
    {
      gtk_widget_hide_all (btn_playword);
      gtk_widget_hide_all (btn_infoword);
      return;
    }
  else
    {
      gtk_widget_show_all (btn_playword);
      gtk_widget_show_all (btn_infoword);
    }

  less = util_return_lesson (lessons, genLprefs.method);
  if (less == NULL)
    {
      pango_font_description_free (font);  
      return;
    }

  while (obocurrent[i] != NULL)
    {
      
#ifdef DEBUG
      printf ("Debug: freeing lingMeaning element %i\n", i);
#endif
      
      ling_meaning_free_meaning (obocurrent[i]);
      i++;
    }
  i = 0;

  /* clear all items of both boxes */
  children = gtk_container_get_children (GTK_CONTAINER (box_trans));
  if (children != NULL)
    {
      while (children->next != NULL)
	{
	  gtk_object_destroy (GTK_OBJECT (children->data));
	  children = children->next;
	}
      gtk_object_destroy (GTK_OBJECT (children->data));
      g_list_free (children);
    }

  /* new labels */
  obocurrent[0] = ling_meaning_get_another_meaning (less, genLprefs.method, 
						    genLprefs.mlanguage);
  id = obocurrent[0]->id;
  
  gtk_label_set_text (GTK_LABEL (lbl_langword), obocurrent[0]->language);
  gtk_label_set_text (GTK_LABEL (lbl_word), obocurrent[0]->translation);

  g_signal_handler_disconnect (btn_infoword, handle);
  g_signal_handler_disconnect (btn_playword, handle1);
  handle = g_signal_connect_swapped (G_OBJECT (btn_infoword), "clicked", 
				     G_CALLBACK (on_btn_info_clicked), 
				     obocurrent[0]);
  handle1 = g_signal_connect_swapped (G_OBJECT (btn_playword), "clicked", 
				      G_CALLBACK (util_on_btn_play_clicked), 
				      obocurrent[0]);

  gtk_widget_modify_font (lbl_langword, font);
  
  while (genLprefs.languages[i] != NULL)
    {
      tbl_trans_set = gtk_table_new (1, 4, FALSE);
      
      /* i + 1 needed, because element 0 is already filled */
      obocurrent[i + 1] = ling_meaning_get_by_word_id (less, id, 
    						       genLprefs.languages[i]);
      
      lbl_lang = gtk_label_new (genLprefs.languages[i]);
      gtk_label_set_justify (GTK_LABEL (lbl_lang), GTK_JUSTIFY_RIGHT);
      gtk_misc_set_alignment (GTK_MISC (lbl_lang), 0.1, 0.5);
      gtk_widget_modify_font (lbl_lang, font);
      gtk_table_attach (GTK_TABLE (tbl_trans_set), lbl_lang, 0, 1, 0, 1,
			(GTK_EXPAND | GTK_FILL), 0, 2, 0);

      lbl_trans = gtk_label_new (obocurrent[i + 1]->translation);
      gtk_label_set_justify (GTK_LABEL (lbl_trans), GTK_JUSTIFY_RIGHT);
      gtk_misc_set_alignment (GTK_MISC (lbl_trans), 0.1, 0.5);
      gtk_table_attach (GTK_TABLE (tbl_trans_set), lbl_trans, 1, 2, 0, 1,
			(GTK_EXPAND | GTK_FILL), 0, 2, 0);

      img_info = gtk_image_new_from_stock (GTK_STOCK_DIALOG_INFO,
					   GTK_ICON_SIZE_MENU);
      btn_info = gtk_button_new ();
      gtk_container_add (GTK_CONTAINER (btn_info), img_info);
      gtk_tooltips_set_tip (tooltips, btn_info, _("More Information"), NULL);
      g_signal_connect_swapped (G_OBJECT (btn_info), "clicked", 
				G_CALLBACK (on_btn_info_clicked), 
				obocurrent[i + 1]);

      gtk_table_attach (GTK_TABLE (tbl_trans_set), btn_info, 2, 3, 0, 1,
			GTK_FILL, GTK_FILL, 2, 0);
      
      btn_play = gtk_button_new ();
      lbl_arrow = gtk_arrow_new (GTK_ARROW_RIGHT, GTK_SHADOW_NONE);
      gtk_container_add (GTK_CONTAINER (btn_play), lbl_arrow);
      g_signal_connect_swapped (G_OBJECT (btn_play), "clicked", 
				G_CALLBACK (util_on_btn_play_clicked), 
				obocurrent[i + 1]);
      gtk_tooltips_set_tip (tooltips, btn_play, _("Play Sound"), NULL);
      gtk_table_attach (GTK_TABLE (tbl_trans_set), btn_play, 3, 4, 0, 1,
			GTK_FILL, GTK_FILL, 2, 0);

      i++;

      gtk_widget_show_all (tbl_trans_set);
      gtk_box_pack_start (GTK_BOX (box_trans), tbl_trans_set, TRUE, TRUE, 0);
    }
  pango_font_description_free (font);  
  return;
}
