/*  This file is part of LingoTeach, the Language Teaching program 
 *  Copyright (C) 2001-2003 The LingoTeach Team
 *
 *  This program is free software; you can redistribute it and/or modify 
 *  it under the terms of the GNU General Public License as published by 
 *  the Free Software Foundation; either version 2 of the License, or 
 *  (at your option) any later version. 
 *
 *  This program is distributed in the hope that it will be useful, 
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *  GNU General Public License for more details. 
 * 
 *  You should have received a copy of the GNU General Public License 
 *  along with this program; if not, write to the Free Software 
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
 */

#include <stdlib.h>
#include <gtk/gtk.h>

#include "lingoteach-i18n.h"

/* prototypes */
static void on_button_click_cb (GtkWidget* widget, GtkWidget* label);
const gchar* module_name (void);
const gchar* module_desc (void);
GtkWidget* module_box (void);
void module_free (void);

/* swap label */
static void
on_button_click_cb (GtkWidget* widget, GtkWidget* label)
{
  gtk_label_set_text (GTK_LABEL (label), _("Button was clicked."));
  return;
}

/*
 * public members start here 
 */
const gchar* 
module_name (void)
{
  return "Test Module";
}

const gchar* 
module_desc (void)
{
  return "This is a test module for LingoTeach";
}

GtkWidget*
module_box (void)
{
  GtkWidget* box;
  GtkWidget* label;
  GtkWidget* button;

  box    = gtk_vbox_new (FALSE, 0);
  label  = gtk_label_new (_("This is a test module for LingoTeach"));
  button = gtk_button_new_with_mnemonic (_("_Click event"));
  
  g_signal_connect (G_OBJECT (button), "clicked", 
		    G_CALLBACK (on_button_click_cb), (gpointer) label);

  gtk_box_pack_start (GTK_BOX (box), label,  FALSE, FALSE, 2);
  gtk_box_pack_start (GTK_BOX (box), button, FALSE, FALSE, 2);

  gtk_widget_show_all (box);
  
  return box;
}

void 
module_free (void)
{
  /* this module does not need to free any stuff in itself */
  return;
}
