/* $Id: hig-widgets.h,v 1.1 2005/03/28 12:51:58 marcusva Exp $
 *
 *  This file is part of LingoTeach, the Language Teaching program
 *  Copyright (C) 2004-2005 Marcus von Appen. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef LING_GTKHIG_H
#define LING_GTKHIG_H 1

#include <gtk/gtk.h>

/* markups */
#define MARKUP_BOLD "<b>%s</b>"
#define MARKUP_LARGER_BOLD "<span size=\"larger\" weight=\"bold\">%s</span>"
#define MARKUP_LARGE_BOLD "<span size=\"large\" weight=\"bold\">%s</span>"
#define MARKUP_XXLARGE_BOLD "<span size=\"xx-large\" weight=\"bold\">%s</span>"
#define MARKUP_ITALIC "<i>%s</i>"
#define MARKUP_ITALIC_BOLD "<i><b>%s</b></i>"
#define MARKUP_LINK "<span underline=\"single\" foreground=\"blue\">%s</span>"

/* constants for GNOME HIG */
#define WIDGET_BORDER 6
#define BOX_SPACING 6
#define TBL_ROW_SPACING 6
#define TBL_COL_SPACING 12

GtkWidget*
hig_window_new (const gchar *title);

GtkWidget*
hig_hbox_new (void);

GtkWidget*
hig_vbox_new (void);

GtkWidget*
hig_frame_new (const gchar *label);

GtkWidget*
hig_table_new (guint rows, guint columns);

GtkWidget*
hig_scrolled_window_new (void);

#endif /* LING_GTKHIG_H */
