#!/usr/bin/perl

use POSIX;

if($#ARGV != 2) {
    print "usage: make_control_tab.pl <header-file> <device> <columns>\n";
    exit 1;
}

$file = @ARGV[0];
$device = @ARGV[1];
$columns = @ARGV[2];

open(file, $file);

while(<file>) {
    next if /\(undocumented\)/;
    next if !/${device}_(.*?)\s*=/;
    $control = $1;
    $control =~ s/__.*//;
    next if $used{$control};
    push(@controls, $control);
    $used{$control} = 1;
}

@controls = sort(@controls);
$rows = POSIX::ceil(($#controls + 1) / $columns);
print "\\begin{center}\n\\begin{tabular}{|";

foreach $col(0 .. $columns - 1) {
    print "l|";
}

print "}\n\\hline\n";

foreach $row(0 .. $rows - 1) {
    foreach $col(0 .. $columns - 1) {
	$c = @controls[$row + $col * $rows];
	$c =~ s/_/\\_/g;
	print "\\control{$c}";
	print "&" if $col < $columns - 1;
    }

    print "\\\\\\hline\n";
}

print "\\end{tabular}\n\\end{center}\n";
