/* Editor Settings: expandtabs and use 4 spaces for indentation
 * ex: set softtabstop=4 tabstop=8 expandtab shiftwidth=4: *
 * -*- mode: c, c-basic-offset: 4 -*- */

/*
 * Copyright Likewise Software    2004-2008
 * All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the license, or (at
 * your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
 * General Public License for more details.  You should have received a copy
 * of the GNU Lesser General Public License along with this program.  If
 * not, see <http://www.gnu.org/licenses/>.
 *
 * LIKEWISE SOFTWARE MAKES THIS SOFTWARE AVAILABLE UNDER OTHER LICENSING
 * TERMS AS WELL.  IF YOU HAVE ENTERED INTO A SEPARATE LICENSE AGREEMENT
 * WITH LIKEWISE SOFTWARE, THEN YOU MAY ELECT TO USE THE SOFTWARE UNDER THE
 * TERMS OF THAT SOFTWARE LICENSE AGREEMENT INSTEAD OF THE TERMS OF THE GNU
 * LESSER GENERAL PUBLIC LICENSE, NOTWITHSTANDING THE ABOVE NOTICE.  IF YOU
 * HAVE QUESTIONS, OR WISH TO REQUEST A COPY OF THE ALTERNATE LICENSING
 * TERMS OFFERED BY LIKEWISE SOFTWARE, PLEASE CONTACT LIKEWISE SOFTWARE AT
 * license@likewisesoftware.com
 */

/* -*- mode: c; c-basic-offset: 4 -*- */
#include "includes.h"


NTSTATUS SamrCreateUser2(handle_t bind, PolicyHandle *domain_handle,
			 wchar16_t *account_name, uint32 account_flags,
			 uint32 account_mask, PolicyHandle *account_handle,
			 uint32 *access_granted, uint32 *rid)
{
    NTSTATUS status;
    UnicodeStringEx acct_name;

    if (bind == NULL || domain_handle == NULL || account_name == NULL ||
	account_handle == NULL || access_granted == NULL || rid == NULL) {
	return STATUS_INVALID_PARAMETER;
    }

    *access_granted = 0;
    *rid            = 0;

    InitUnicodeStringEx(&acct_name, account_name);

    TRY
    {
	status = _SamrCreateUser2(bind, domain_handle, &acct_name,
				  account_flags, account_mask, account_handle,
				  access_granted, rid);
    }
    CATCH_ALL
    {
	return STATUS_UNHANDLED_EXCEPTION;
    }
    ENDTRY;

    FreeUnicodeStringEx(&acct_name);

    return status;
}
