<?php
/*
	$Id: selfServiceMain.php,v 1.15 2008-10-02 15:22:20 roland Exp $
	
	This code is part of LDAP Account Manager Pro (http://www.sourceforge.net/projects/lam)
	Copyright (C) 2006 - 2007  Roland Gruber
*/

/**
* User page for self service.
*
* @package selfService
*
* @author Roland Gruber
*/

/** Access to self service profiles */
include_once('../../lib/selfService.inc');
/** status messages */
include_once('../../lib/status.inc');

// start session
session_save_path("../../sess");
@session_start();

setlanguage();

/**
 * Shows an error message and then terminates.
 *
 * @param array $args arguments for StatusMessage function
 * @see StatusMessage
 */
function showErrorMessage($args) {
	echo $_SESSION['header'];
	echo "<link rel=\"stylesheet\" type=\"text/css\" href=\"../../style/layout.css\">\n";
	echo "<link rel=\"shortcut icon\" type=\"image/x-icon\" href=\"../../graphics/favicon.ico\">\n";
	echo "<title></title>\n";
	echo "</head>\n";
	echo "<body>\n";
	call_user_func_array('StatusMessage', $args);
	echo "<br><br><br>\n";
	echo "<big><a href=\"selfServiceLogin.php?scope=" . $_GET['scope'] . "&amp;name=" . $_GET['name'] . "\">" . _('Logout') . "</a></big>";
	echo "</body>\n";
	echo "</html>\n";
	die();
}

$scope = $_GET['scope'];
$name = $_GET['name'];
$profile = loadSelfServiceProfile($name, $scope);
$_SESSION['selfServiceProfile'] = $profile;
$clientDN = $_SESSION['selfService_clientDN'];
$clientPassword = $_SESSION['selfService_clientPassword'];
if (!isset($clientDN)) die();

// connect to LDAP server
$serverURL = $profile->serverURL;
// connect to LDAP server
$server = @ldap_connect($serverURL);
$attributes = array();
if ($server) {
	// use LDAPv3
	ldap_set_option($server, LDAP_OPT_PROTOCOL_VERSION, 3);
	// start TLS if possible
	if (function_exists('ldap_start_tls')) {
		@ldap_start_tls($server);
		// connect without TLS if it failed
		if (ldap_errno($server) != 0) {
			@ldap_close($server);
			$server = @ldap_connect($serverURL);
			ldap_set_option($server, LDAP_OPT_PROTOCOL_VERSION, 3);
		}
	}
	$_SESSION['ldapHandle'] = $server;
	$bind = @ldap_bind($server, $clientDN, $clientPassword);
	if (!$bind) {
		// check if password was changed
		if (isset($_SESSION['selfService_clientPasswordNew'])) {
			$bind = @ldap_bind($server, $clientDN, $_SESSION['selfService_clientPasswordNew']);
			if ($bind) {
				$_SESSION['selfService_clientPassword'] = $_SESSION['selfService_clientPasswordNew'];
			}
		}
		if (!$bind) {
			showErrorMessage(array('ERROR', _("Cannot connect to specified LDAP server. Please try again."), ldap_error($server)));
		}
	}
	// read user entry from LDAP
	$result = ldap_read($server, $clientDN, 'objectClass=*');
	if ($result) {
		$attributes = ldap_get_entries($server, $result);
		if (sizeof($attributes) > 0) $attributes = $attributes[0];
		// unset count entries and obsolete values
		unset($attributes['count']);
		for ($i = 0; $i < count($attributes); $i++) {
			if (isset($attributes[$i])) unset($attributes[$i]);
		}
		$attrNames = array_keys($attributes);
		for ($i = 0; $i < sizeof($attrNames); $i++) {
			if (is_array($attributes[$attrNames[$i]])) unset($attributes[$attrNames[$i]]['count']);
		}
		// get binary attributes
		$binaryAttr = array('jpegphoto');
		for ($i = 0; $i < sizeof($binaryAttr); $i++) {
			if (isset($attributes[$binaryAttr[$i]][0]) && (sizeof($attributes[$binaryAttr[$i]][0]) < 100)) {
				// looks like we have read broken binary data, reread photo
				$result = ldap_search($server, escapeDN($clientDN), $binaryAttr[$i] . "=*", array($binaryAttr[$i]));
				if ($result) {
					$tempEntry = ldap_first_entry($server, $result);
					if ($tempEntry) {
						$binData = ldap_get_values_len($server, $tempEntry, $binaryAttr[$i]);
						if (isset($binData['count'])) unset($binData['count']);
						$attributes[$binaryAttr[$i]] = $binData;
					}
				}
			}
		}
		$container =  new accountContainer($scope, "none");
		$attributes = $container->fixLDAPAttributes($attributes, getAvailableModules($scope));
	}
}
else die();


// build list of fields
$fields = array();
for ($i = 0; $i < sizeof($profile->inputFields); $i++) {
	for ($f = 0; $f < sizeof($profile->inputFields[$i]['fields']); $f++) {
		$parts = split("_", $profile->inputFields[$i]['fields'][$f]);
		if (sizeof($parts) == 2) $fields[$parts[0]][] = $parts[1];
	}
}

$errors = array();

// check if save button was pressed
if (isset($_POST['save'])) {
	$result = checkSelfServiceOptions($scope, $fields, $attributes);
	$errors = $result['messages'];
	$toAdd = $result['add'];
	$toDel = $result['del'];
	$toMod = $result['mod'];
	$completeSuccess = true;
	if (sizeof($toAdd) > 0) {
		$success = @ldap_mod_add($server, $clientDN, $toAdd);
		if (!$success) {
			$completeSuccess = false;
			logNewMessage(LOG_ERR, "[" . $clientDN . "] SelfService: Error while adding attributes: " . ldap_error($server));
		}
		else {
			logNewMessage(LOG_NOTICE, "[" . $clientDN . "] SelfService: Added attributes: " . implode(", ", array_keys($toAdd)));
		}
	}
	if (sizeof($toDel) > 0) {
		$success = @ldap_mod_del($server, $clientDN, $toDel);
		if (!$success) {
			$completeSuccess = false;
			logNewMessage(LOG_ERR, "[" . $clientDN . "] SelfService: Error while deleting attributes: " . ldap_error($server));
		}
		else {
			logNewMessage(LOG_NOTICE, "[" . $clientDN . "] SelfService: Deleted attributes: " . implode(", ", array_keys($toDel)));
		}
	}
	if (sizeof($toMod) > 0) {
		$success = @ldap_mod_replace($server, $clientDN, $toMod);
		if (!$success) {
			$completeSuccess = false;
			logNewMessage(LOG_ERR, "[" . $clientDN . "] SelfService: Error while changing attributes: " . ldap_error($server));
		}
		else {
			logNewMessage(LOG_NOTICE, "[" . $clientDN . "] SelfService: Modified attributes: " . implode(", ", array_keys($toMod)));
		}
	}
	
	if (!$completeSuccess) {
		$errors[] = array("ERROR", _("Unable to change your account. Maybe you do not have enough rights to change the settings."));
	}
	else {
		for ($i = 0; $i < sizeof($errors); $i++) {
			if ($errors[$i][0] === "ERROR") {
				$completeSuccess = false;
				break;
			}
		}
		if ($completeSuccess) {
			$errors[] = array('INFO', _('All changes were successful.'));
		}
	}
	// reread LDAP entry
	$result = ldap_read($server, $clientDN, 'objectClass=*');
	if ($result) {
		$attributes = ldap_get_entries($server, $result);
		if (sizeof($attributes) > 0) $attributes = $attributes[0];
		// unset count entries and obsolete values
		unset($attributes['count']);
		for ($i = 0; $i < count($attributes); $i++) {
			if (isset($attributes[$i])) unset($attributes[$i]);
		}
		$attrNames = array_keys($attributes);
		for ($i = 0; $i < sizeof($attrNames); $i++) {
			if (is_array($attributes[$attrNames[$i]])) unset($attributes[$attrNames[$i]]['count']);
		}
		// get binary attributes
		$binaryAttr = array('jpegphoto');
		for ($i = 0; $i < sizeof($binaryAttr); $i++) {
			if (isset($attributes[$binaryAttr[$i]][0]) && (sizeof($attributes[$binaryAttr[$i]][0]) < 100)) {
				// looks like we have read broken binary data, reread photo
				$result = ldap_search($server, escapeDN($clientDN), $binaryAttr[$i] . "=*", array($binaryAttr[$i]));
				if ($result) {
					$tempEntry = ldap_first_entry($server, $result);
					if ($tempEntry) {
						$binData = ldap_get_values_len($server, $tempEntry, $binaryAttr[$i]);
						if (isset($binData['count'])) unset($binData['count']);
						$attributes[$binaryAttr[$i]] = $binData;
					}
				}
			}
		}
		$container =  new accountContainer($scope, "none");
		$attributes = $container->fixLDAPAttributes($attributes, getAvailableModules($scope));
	}
}

?>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
<meta http-equiv="content-type" content="text/html; charset=UTF-8">
<meta http-equiv="pragma" content="no-cache">
		<meta http-equiv="cache-control" content="no-cache">		
	<title>LAM self service</title>
	<link rel="stylesheet" type="text/css" href="../../style/layout.css">
</head>
<body>
	<p align="center"><a href="http://lam.sourceforge.net" target="_blank">
		<img src="../../graphics/banner.jpg" border=1 alt="LDAP Account Manager"></a>
	</p>
	<hr>
	<?php
		for ($i = 0; $i < sizeof($errors); $i++) {
			call_user_func_array('StatusMessage', $errors[$i]);
		}
		echo $profile->mainPageText;
		echo "<br><br>";
		echo "<form enctype=\"multipart/form-data\" action=\"selfServiceMain.php?scope=" . $scope . "&amp;name=" . $name . "\" method=\"post\">";
		// get meta HTML code
		$metaHTML = getSelfServiceOptions($scope, $fields, $attributes);
		$tabindex = 100;
		$tabindexLink = 10000;
		for ($i = 0; $i < sizeof($profile->inputFields); $i++) {
			echo "<fieldset>\n";
				echo "<legend><b>" . $profile->inputFields[$i]['name'] . "</b></legend><br>";
				$currentFields = $profile->inputFields[$i]['fields'];
				$currentMetaHTML = array();
				for ($f = 0; $f < sizeof($currentFields); $f++) {
					$parts = split("_", $currentFields[$f]);
					if (sizeof($parts) == 2) {
						if (array_key_exists($parts[0], $metaHTML) && array_key_exists($parts[1], $metaHTML[$parts[0]])) {
							$currentMetaHTML[] = $metaHTML[$parts[0]][$parts[1]];
						}
					}
				}
				parseHtml("none", $currentMetaHTML, array(), true, $tabindex, $tabindexLink, $scope);
			echo "</fieldset><br>\n";
		}
	?>
	
	<BR>
	&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<INPUT type="submit" name="save" value="<?php echo _('Save'); ?>">
	<BR><br><br><br>
	<?PHP
	echo "<big><a href=\"selfServiceLogin.php?scope=" . $scope . "&amp;name=" . $name . "\">" . _('Logout') . "</a></big>";
	?>
	
	</form>

</body>
</html>
