#ifndef SPREADSHEET_H
#define SPREADSHEET_H

#include <qwidget.h>
#include <qtable.h>
#include <kprocess.h>
#include "MainWin.h"
#include "widgettype.h"
#include "input.h"

//#define USE_NEW_TABLE

#ifdef USE_NEW_TABLE
#include <LTable.h>
#endif

/*#ifdef HAVE_UNDO
extern "C" {
#include "undo.h"
}
#endif*/

#include <new>

class MainWin;
class ListDialog;
class ExportDialog;
class SpreadsheetValuesDialog;

#define MAX_COLS 676

class Spreadsheet: public QWidget
{
	Q_OBJECT
// this leads to loops on KDE 3.4
//	Q_PROPERTY(QString title READ Title WRITE setTitle)
public:
	Spreadsheet(QWidget *parent, MainWin *mw, const char *name);
	void update();
	void closeNow();
	WidgetType getWidgetType() { return widgettype; }
	QStringList Info();
	MainWin *getMainWin() { return mw; }
#ifdef USE_NEW_TABLE
	LTable *Table() { return table; }
#else
	QTable *Table() { return table; }
#endif
	void setText(int i, int j, QString text);
	void save(QTextStream *t);
	void open(QTextStream *t, int version);
	QDomElement saveXML(QDomDocument doc);
	void openXML(QDomNode node);
	bool eventFilter(QObject *object, QEvent *e);
public slots:
	void Menu(QPopupMenu *menu);				//!< open context menu
	void updateValuesDialog();
	void selectionChanged();
	QString Title() const { return title; }			//!< get title
	void setTitle(QString t="");				//!< set spreadsheet title
	QString Notes() const { return notes; }			//!< get notes
	void setNotes(QString notes="");			//!< set spreadsheet notes
	void setListDialog(ListDialog *l) {ld=l; setCaption(i18n("Spreadsheet")+QString(" : ")+i18n("Edit data") ); }
	void setGraph(Graph *g) { graph=g; }
	QStringList columnInfo(int col);			//!< get info about column col
	QString columnTitle(int col);				//!< get title of column col
	void setColumnTitle(int col, QString name=0);
	QString columnType(int col);				//!< get type of column col
	void setColumnType(int col, QString type=0);
	QString columnFormat(int col);				//!< get format of column col
	void setColumnFormat(int col, QString format=0);
	void Clear();								//!< clear spreadsheet	
	int filledRows(int col=1);
	int selectedColumns();
	int selectedRows();
	int getColumnIndex(QString title);			//!< get the index of the column with name title

	void plot2DSimple() { plot2D(P2D,false); }	//!< make a simple 2d plot of all selected columns
	void plot2DPie() { plot2D(PPIE,false); }		//!< make a pie plot of all selected columns
	void plotLPie() { plotL(PPIE); }		//!< make a pie plot with value and label
	void plot2DPolar() { plot2D(PPOLAR,false); }	//!< make a polar plot of all selected columns
	void plot3DXYPX() { plot3DXYDY(I2DXYPX); }
	void plot3DXYPY() { plot3DXYDY(I2DXYPY); }
	void plot2DLine() { plot2D(P2D,true); }
	void plotMSurface() { plotMatrix(PSURFACE); }	//!< make a surface plot of all selected columns
	void plot3DSurface() { plot3D(PSURFACE); }		//!< make a surface plot of x-y-z
	void plotM3D() { plotMatrix(P3D); }			//!< make a 3d plot from matrix 
	void plotQWT3D() { plot3D(PQWT3D); }
	void plotMQWT3D() { plotMatrix(PQWT3D); }
	void plot3DXYDY(Input2D mode=I2DXYDY);		//!< make a 2d y-error plot of all selected columns
	void plot4DXYDXDY();						//!< make a 2d x-y-error plot of all selected columns
	void plot4DXYDYDY();						//!< make a 2d y1-y2-error plot of all selected columns
	void plot3DSimple() { plot3D(P3D); }			//!< make a simple 3d plot of all selected columns
	void plot3DTernary() { plot3D(PTERNARY); }		//!< make a ternary plot of all selected columns

	void selectDestination();						//!< select destination for plot
	int Destination() { return destination; }
	void setDestination(int v) { destination=v; }
	
	void addGraph2D(Graph2D *g);					// add data from graph 2d
	void addGraph3D(Graph3D *g);					// add data from graph 3d
	void addGraph4D(Graph4D *g);					// add data from graph 4d
	void addGraphM(GraphM *g);					// add data from graph m
	void addGraphL(GraphL *g);					// add data from graph l
	Graph2D* getGraph2D();					// get data for graph 2d
	Graph3D* getGraph3D();					// get data for graph 3d
	Graph4D* getGraph4D();					// get data for graph 4d
	GraphM* getGraphM();					// get data for graph m
	GraphL* getGraphL();					// get data for graph l
	
	void cutSelection();							//!< cut current selection
	void copySelection();						//!< copy current selection
	void pasteSelection();						//!< paste current selection
	void clearSelection();						//!< clear current selection
	
	void fillRowNumber();						//!< fill selected column with row numbers
	void fillRandom(double max=1.0);				//!< fill selected column with random numbers (0..max)
	void setCurrentColumn(int i);					//!< set column i to current column (first column : 0) 
	
	void selectAll();							//!< select everything
	void selectNone();							//!< deselect everything
	void selectInvert();							//!< invert selection
	
	void normSum();							//!< normalize current column to sum = 1.0
	void normMax(double max=1.0);				//!< normalize current column to maximum = max
	void convertComma();						//!< replace all ',' with '.'
	void convertFORTRAN();						//!< replace all 'd' and 'D' with 'e'
	void transposeMatrix();						//!< transpose spreadsheet matrix
	void convertMatrixtoXYZ();					//!< convert matrix data to x-y-z data
	void convertXYZtoMatrix();					//!< convert x-y-z data to matrix data
	void convertColumntoMatrix();				//!< convert one column to matrix
	ExportDialog* exportData();				//!< export data
	void addColumn();							//!< add a column
	void toggleMask();
	void maskSelection();
	void unMask();
	void maskNthRow();
	void maskFirstRow();
	void sortAscending();						//!< sort current column ascending
	void sortDescending();						//!< sort current column descending
	void rowStatistics() { Statistics(false); }			//!< slot wrapper
	void Statistics(bool col=true);					//!< row/column statistics
	void selectColumns(int left, int right=-1);		//!< select columns from right to left
	void selectRows(int top, int bottom=-1);			//!< select rows from top to bottom
	void deleteRows();							//!< delete selected rows
	void deleteColumns();						//!< delete selected columns
	void setValues(int srow=1, int erow=0, QString expr=0);	//!< set value of rows srow to erow in currentColumn to expr
	void setProperties(QString label=0, int type=1, int format=0, int rows=100);	
									//!< set properties of current columns (label, type, format, rows)
private slots:
	void plot2D(PType type,bool line);
	void plot3D(PType type);
	void plotL(PType type);
	void plotMatrix(PType type);
	void editEditor(int editor);
	void readfile(KProcess *process);
	void editVI() { editEditor(0); }
	void editKVIM() { editEditor(1); }
	void editGVIM() { editEditor(2); }
	void editKATE() { editEditor(3); }
	void editKWRITE() { editEditor(4); }
	void editEMACS() { editEditor(5); }
	void editXEMACS() { editEditor(6); }
	void editKWORD() { editEditor(7); }
	void editSOFFICE() { editEditor(8); }
private:
	int formatItem(int col);
	void sort();
	void qsort(int s, int e);
	void updateGraphList();
	void setColumnNames(int nrcols);
	void contextMenuEvent(QContextMenuEvent *);
	void mousePressEvent ( QMouseEvent *);
	void resizeEvent(QResizeEvent *);
	void closeEvent(QCloseEvent *);
	MainWin *mw;
	WidgetType widgettype;
	QString title;
	QString notes;			// notes string
#ifdef USE_NEW_TABLE
	LTable *table;
#else
	QTable *table;
#endif
	ListDialog *ld;				// used when editing data from list dialog
	SpreadsheetValuesDialog *values_dialog;
	Graph *graph;				// used for editing
	GRAPHType gtype;			// -""-
	QString datafile;			// used for online data
	QString tmpfilename;			// tmp filename for editing with editor
	bool ascending;				// for sorting a column
	int destination;			// for plots
	QPopupMenu *plotmenu, *destmenu, *selmenu, *fillmenu, *normmenu;
	QPopupMenu *editmenu, *convertmenu, *sortmenu, *maskmenu;
};

#endif //SPREADSHEET
