//LabPlot : VTKDialog.cc

#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <iostream>
#include <klocale.h>

#include "PlotVTK.h"
#include "VTKDialog.h"

using namespace std;

/*! newtype -> new 3D Plot type*/
VTKDialog::VTKDialog(Worksheet *p, const char *name,int item)
	: Dialog(p, name)
{
	setCaption(i18n("VTK Dialog")+i18n(" : ")+QString(name));
	
	type = PVTK;
	Plot *plot = p->getPlot(p->getAPI());

	QColor color=QColor(Qt::blue);
	bool boxed = true;

	if (item == -1) {       // new graph
                graph = 0;
        }
	else {
		GraphList *graphlist = plot->getGraphList();
        	graph = graphlist->getGraph(item);
		GRAPHType s = graphlist->getStruct(item);
		if (s == GRAPHVTK) {
			GraphVTK *g = graphlist->getGraphVTK(item);
			color=g->getColor();
			boxed = g->getBoxed();
		}
	}

	kdDebug()<<"VTKDialog"<<endl;
	kdDebug()<<"Type = "<<type<<endl;

	setCaption(i18n("VTK Dialog"));

	// TODO : VTK values
	QHBox *hb = new QHBox(vbox);
	new QLabel(i18n("Object : "),hb);
	QStringList objectlist;
	objectlist << i18n("cone");
	objectlist << i18n("cube");
	objectlist << i18n("sphere");
	objectlist << i18n("cylinder");
	objectlist << i18n("point");
	objectcb = new KComboBox(hb);
	objectcb->insertStringList(objectlist);

	hb = new QHBox(vbox);
	colorbutton = new KColorButton(color,hb);

	hb = new QHBox(vbox);
	boxedcb = new QCheckBox(i18n("draw Box"),hb);
	boxedcb->setChecked(boxed);

	QObject::connect(ok,SIGNAL(clicked()),SLOT(ok_clicked()));
	QObject::connect(apply,SIGNAL(clicked()),SLOT(agree()));

	setMinimumSize(vbox->minimumSizeHint()+gbox->minimumSizeHint());
	resize(vbox->minimumSizeHint()+gbox->minimumSizeHint());
}



int VTKDialog::agree() {
	kdDebug()<<"VTKDialog::agree()"<<endl;

	//TODO : GraphVTK *g = new GraphVTK(fun,label,range,type,style,symbol,a,NX,NY);
	GraphVTK *g = new GraphVTK("VTK","test");

	// set values
	g->setObject(objectcb->currentItem());
	g->setColor(colorbutton->color());
	g->setBoxed(boxedcb->isChecked());

	p->addGraphVTK(g);

	return 0;
}
