//LabPlot : RichTextWidget.h

#ifndef RICHTEXTWIDGET_H
#define RICHTEXTWIDGET_H

#include <klineedit.h>
#include <qfont.h>
#include <qcheckbox.h>
#include <qcombobox.h>
#include <qtextedit.h>
#include <kcolorbutton.h>
#include <kpopupmenu.h>
#include "Worksheet.h"
#include "Label.h"

class RichTextWidget: public QWidget
{
	Q_OBJECT
public:
	RichTextWidget(QWidget *parent, Label *label, const char *name);
public slots:
	void setLabel(Label *label) { l = label;update(); }
	Label* label() { apply(); return l; }
	void update();
private slots:
	void selectFont();
	void setTEColor();
	void toggleBold();
	void toggleItalic();
	void toggleUnderline();
	void toggleSuperscript();
	void toggleSubscript();
	void insertChar(int ch);
	void insertGChar(int ch);
	void boxedChanged(bool b) { l->setBoxed(b); }
private:
	void apply();
	Label *l;
	QTextEdit *te;
	KLineEdit *xle, *yle, *titleFont;
	QToolButton *bold, *italic, *underline, *superscript, *subscript;
	KPopupMenu *sgletters, *bgletters, *oletters;
	KColorButton *kcb;
	QCheckBox *boxedcb;
};

#endif //RICHTEXTWIDGET_H
